/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.math.BigInteger;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase1;

public class Math_exp10
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("exp10", v)) {
            case OP_INTEGER: {
                int x = v.getInteger().intValue();
                if (x >= 0) {
                    return NodeValue.makeInteger(BigInteger.TEN.pow(x));
                }
            }
            case OP_DECIMAL: 
            case OP_DOUBLE: 
            case OP_FLOAT: {
                return NodeValue.makeDouble(Math.pow(10.0, v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }
}

