/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase1;

public class date
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        if (!v.isString()) {
            Log.warn(this, "date: argument not a string: " + v);
            throw new ExprEvalException("date: argument not a string: " + v);
        }
        String lexicalForm = v.getString();
        if (!lexicalForm.matches("\\d{4}-\\d{2}-\\d{2}")) {
            Log.warn(this, "date: argument not in date format: " + v);
            throw new ExprEvalException("date: argument not in date format: " + v);
        }
        lexicalForm = String.valueOf(lexicalForm) + "T00:00:00Z";
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }
}

