/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.user;

import java.util.List;
import java.util.Map;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.function.user.UserDefinedFunction;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.sse.builders.ExprBuildException;

public class ExprTransformExpand
extends ExprTransformCopy {
    private Map<String, UserDefinedFunctionDefinition> definitions;

    public ExprTransformExpand(Map<String, UserDefinedFunctionDefinition> defs) {
        if (defs == null) {
            throw new IllegalArgumentException("defs cannot be null");
        }
        this.definitions = defs;
    }

    @Override
    public Expr transform(ExprFunctionN func, ExprList args) {
        ExprFunction f = func.getFunction();
        if (this.shouldExpand(f)) {
            UserDefinedFunctionDefinition def = this.definitions.get(f.getFunction().getFunctionIRI());
            UserDefinedFunction uFunc = (UserDefinedFunction)def.newFunctionInstance();
            List<Var> defArgs = def.getArgList();
            ExprList subArgs = new ExprList();
            int i = 0;
            while (i < args.size()) {
                Expr arg = args.get(i);
                String var = arg.getVarName();
                if (var == null) {
                    subArgs.add(arg);
                } else {
                    if (i > defArgs.size()) {
                        throw new ExprBuildException("Unable to expand function dependency, the function <" + def.getUri() + "> is called but uses an argument ?" + var + " which is not an argument to the outer function");
                    }
                    subArgs.add(arg);
                }
                ++i;
            }
            uFunc.build(def.getUri(), subArgs);
            return uFunc.getActualExpr();
        }
        return super.transform(func, args);
    }

    private boolean shouldExpand(ExprFunction func) {
        return this.definitions.containsKey(func.getFunctionIRI());
    }
}

