/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetPrefixStorage;

public class GraphPrefixesProjection
implements PrefixMapping {
    private final String graphName;
    private final DatasetPrefixStorage prefixes;

    public GraphPrefixesProjection(String graphName, DatasetPrefixStorage prefixes) {
        this.graphName = graphName;
        this.prefixes = prefixes;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.prefixes.insertPrefix(this.graphName, prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.prefixes.removeFromPrefixMap(this.graphName, prefix);
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.prefixes.removeAllFromPrefixMap(this.graphName);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        this.setNsPrefixes(other.getNsPrefixMap());
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.entrySet().forEach(entry -> this.setNsPrefix((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping other) {
        other.getNsPrefixMap().entrySet().forEach(entry -> {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (this.getNsPrefixURI(prefix) == null && this.getNsURIPrefix(uri) == null) {
                this.setNsPrefix(prefix, uri);
            }
        });
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.prefixes.readPrefix(this.graphName, prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.prefixes.readByURI(this.graphName, uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.prefixes.readPrefixMap(this.graphName);
    }

    @Override
    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.prefixes.readPrefix(this.graphName, prefix);
        return uri == null ? prefixed : String.valueOf(uri) + prefixed.substring(colon + 1);
    }

    @Override
    public String qnameFor(String uri) {
        int split = Util.splitNamespaceXML(uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.prefixes.readByURI(this.graphName, ns);
        return prefix == null ? null : String.valueOf(prefix) + ":" + local;
    }

    @Override
    public String shortForm(String uri) {
        Optional<Map.Entry<String, String>> e2 = this.findMapping(uri, true);
        if (!e2.isPresent()) {
            return uri;
        }
        return String.valueOf(e2.get().getKey()) + ":" + uri.substring(e2.get().getValue().length());
    }

    @Override
    public boolean hasNoMappings() {
        return this.getNsPrefixMap().isEmpty();
    }

    @Override
    public int numPrefixes() {
        return this.getNsPrefixMap().size();
    }

    private Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        return ((Stream)this.getNsPrefixMap().entrySet().stream().sequential()).filter(e2 -> {
            String ss = (String)e2.getValue();
            return uri.startsWith(ss) && (partial || ss.length() == uri.length());
        }).findFirst();
    }

    @Override
    public PrefixMapping lock() {
        return this;
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }
}

