/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.serializer.SerializationContext;

public class CSVInputIterator
extends QueryIteratorBase {
    private BufferedReader reader;
    private BindingMap binding;
    private int expectedItems;
    private List<Var> vars;
    private long lineNum = 1L;

    public CSVInputIterator(BufferedReader reader, List<Var> vars) {
        this.reader = reader;
        this.expectedItems = vars.size();
        this.vars = vars;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println("CSVInputIterator");
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.reader != null) {
            if (this.binding == null) {
                return this.parseNextBinding();
            }
            return true;
        }
        return false;
    }

    private boolean parseNextBinding() {
        String line;
        block6: {
            try {
                line = this.reader.readLine();
                if (line != null) break block6;
                return false;
            }
            catch (IOException e2) {
                throw new QueryException("Error parsing CSV results - " + e2.getMessage());
            }
        }
        ++this.lineNum;
        if (line.isEmpty()) {
            if (this.expectedItems > 1) {
                throw new QueryException(String.format("Error Parsing CSV results at Line %d - The result row had 0/1 values when %d were expected", this.lineNum, this.expectedItems));
            }
            this.binding = BindingFactory.create();
            if (this.expectedItems == 1) {
                this.binding.add(this.vars.get(0), NodeConst.emptyString);
            }
            return true;
        }
        this.binding = this.parseLine(this.vars, line);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private BindingMap parseLine(List<Var> vars, String line) {
        binding = BindingFactory.create();
        terms = new ArrayList<String>();
        idx = 0;
        while (idx < line.length()) {
            block10: {
                ch = line.charAt(idx);
                s = new StringBuilder();
                if (ch != '\"' && ch != '\'') ** GOTO lbl25
                qCh = ch;
                ++idx;
                while (idx < line.length()) {
                    ch = line.charAt(idx);
                    ++idx;
                    if (ch == qCh) break;
                    s.append(ch);
                }
                if (ch != qCh) {
                    throw new QueryException(String.format("Error Parsing CSV results at Line %d  - Unterminated quoted string", new Object[]{this.lineNum}));
                }
                if (idx >= line.length() || (ch = line.charAt(idx)) == ',') break block10;
                throw new QueryException(String.format("Error Parsing CSV results at Line %d - Expected comma after quote", new Object[]{this.lineNum}));
                while ((ch = line.charAt(idx)) != ',') {
                    ++idx;
                    s.append(ch);
lbl25:
                    // 2 sources

                    if (idx < line.length()) continue;
                }
            }
            terms.add(s.toString());
            if (ch == ',' && idx == line.length() - 1) {
                terms.add("");
                break;
            }
            ++idx;
        }
        if (terms.size() != vars.size()) {
            throw new QueryException(String.format("Error Parsing CSV results at Line %d - The result row '%s' has %d items when %d was expected", new Object[]{this.lineNum, line, terms.size(), vars.size()}));
        }
        i = 0;
        while (i < vars.size()) {
            binding.add(vars.get(i), NodeFactory.createLiteral((String)terms.get(i)));
            ++i;
        }
        return binding;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingMap b = this.binding;
        this.binding = null;
        return b;
    }

    @Override
    protected void closeIterator() {
        IO.close(this.reader);
        this.reader = null;
    }

    @Override
    protected void requestCancel() {
    }
}

