/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.RDF;

public class RDFOutput {
    private boolean reportAllVars = false;
    private boolean includeTypeProperties = false;

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean all) {
        this.reportAllVars = all;
    }

    public Model asModel(ResultSet resultSet) {
        Model m = GraphFactory.makeJenaDefaultModel();
        this.asRDF(m, resultSet);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        return m;
    }

    public Resource asRDF(Model model, ResultSet resultSet) {
        return this.asRDF(model, resultSet, false);
    }

    public Resource asRDF(Model model, ResultSet resultSet, boolean includeRowIndex) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, ResultSetGraphVocab.ResultSet);
        for (String vName : resultSet.getResultVars()) {
            results.addProperty(ResultSetGraphVocab.resultVariable, vName);
        }
        int count = 0;
        while (resultSet.hasNext()) {
            ++count;
            QuerySolution rBind = resultSet.nextSolution();
            Resource thisSolution = model.createResource();
            if (this.includeTypeProperties) {
                thisSolution.addProperty(RDF.type, ResultSetGraphVocab.ResultSolution);
            }
            results.addProperty(ResultSetGraphVocab.solution, thisSolution);
            if (includeRowIndex) {
                Literal x = model.createTypedLiteral(String.valueOf(count), (RDFDatatype)XSDDatatype.XSDinteger);
                thisSolution.addLiteral(ResultSetGraphVocab.index, x);
            }
            Iterator<String> iter = this.getAllVars() ? rBind.varNames() : resultSet.getResultVars().iterator();
            while (iter.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = iter.next();
                RDFNode n = rBind.get(rVar);
                if (n == null) continue;
                if (this.includeTypeProperties) {
                    thisBinding.addProperty(RDF.type, ResultSetGraphVocab.ResultBinding);
                }
                thisBinding.addProperty(ResultSetGraphVocab.variable, rVar);
                thisBinding.addProperty(ResultSetGraphVocab.value, n);
                thisSolution.addProperty(ResultSetGraphVocab.binding, thisBinding);
            }
        }
        results.addProperty(ResultSetGraphVocab.size, model.createTypedLiteral(count));
        this.addPrefixes(model);
        return results;
    }

    public Model asModel(boolean result) {
        Model m = GraphFactory.makeJenaDefaultModel();
        RDFOutput.encodeAsRDF(m, result);
        this.addPrefixes(m);
        return m;
    }

    private void addPrefixes(Model model) {
        if (model.getNsPrefixURI("rs") == null) {
            model.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (model.getNsPrefixURI("rdf") == null) {
            model.setNsPrefix("rdf", RDF.getURI());
        }
        if (model.getNsPrefixURI("xsd") == null) {
            model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
    }

    public Resource asRDF(Model model, boolean result) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, ResultSetGraphVocab.ResultSet);
        Literal lit = model.createTypedLiteral(result);
        results.addProperty(ResultSetGraphVocab.p_boolean, lit);
        return results;
    }

    public static Model encodeAsModel(boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asModel(booleanResult);
    }

    public static Model encodeAsModel(ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asModel(resultSet);
    }

    public static Resource encodeAsRDF(Model model, boolean booleanResult) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, booleanResult);
    }

    public static Resource encodeAsRDF(Model model, ResultSet resultSet) {
        RDFOutput rOut = new RDFOutput();
        return rOut.asRDF(model, resultSet);
    }

    private static void outputAsRDF(PrintWriter out, String format, ResultSet resultSet) {
        Model m = RDFOutput.encodeAsModel(resultSet);
        m.write(out, format);
        out.flush();
    }

    public static void outputAsRDF(OutputStream outStream, String format, ResultSet resultSet) {
        PrintWriter out = FileUtils.asPrintWriterUTF8(outStream);
        RDFOutput.outputAsRDF(out, format, resultSet);
        out.flush();
    }

    public static void outputAsRDF(String format, ResultSet resultSet) {
        RDFOutput.outputAsRDF((OutputStream)System.out, format, resultSet);
    }

    public static void outputAsRDF(String format, boolean booleanResult) {
        RDFOutput.outputAsRDF((OutputStream)System.out, format, booleanResult);
    }

    public static void outputAsRDF(OutputStream outStream, String format, boolean booleanResult) {
        PrintWriter out = FileUtils.asPrintWriterUTF8(outStream);
        RDFOutput.outputAsRDF(out, format, booleanResult);
        out.flush();
    }

    private static void outputAsRDF(PrintWriter out, String format, boolean booleanResult) {
        Model m = RDFOutput.encodeAsModel(booleanResult);
        m.write(out, format);
        out.flush();
    }
}

