/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetPeekable;

public class ResultSetMem
implements ResultSetRewindable,
ResultSetPeekable {
    protected List<Binding> rows = new ArrayList<Binding>();
    protected List<String> varNames = null;
    private int rowNumber = 0;
    private PeekIterator<Binding> iterator = null;
    private Model model = null;

    public ResultSetMem(ResultSetMem imrs2) {
        this(imrs2, false);
    }

    public ResultSetMem(ResultSetMem imrs2, boolean takeCopy) {
        this.varNames = imrs2.varNames;
        if (takeCopy) {
            this.rows.addAll(imrs2.rows);
        } else {
            this.rows = imrs2.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet qr) {
        this.model = qr.getResourceModel();
        if (qr instanceof ResultSetMem) {
            ResultSetMem qrm = (ResultSetMem)qr;
            this.rows = qrm.rows;
            this.varNames = qrm.varNames;
        } else {
            this.varNames = qr.getResultVars();
            List<Var> vars = Var.varList(this.varNames);
            while (qr.hasNext()) {
                Binding rb = BindingFactory.copy(qr.nextBinding());
                this.rows.add(rb);
            }
        }
        this.reset();
    }

    /*
     * Unable to fully structure code
     */
    public ResultSetMem(ResultSet ... sets) {
        super();
        this.varNames = sets[0].getResultVars();
        var5_2 = sets;
        var4_3 = sets.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            block3: {
                rs = var5_2[var3_4];
                if (!this.varNames.equals(rs.getResultVars())) {
                    throw new ResultSetException("ResultSet must have the same variables.");
                }
                if (!(rs instanceof ResultSetMem)) ** GOTO lbl21
                this.rows.addAll(((ResultSetMem)rs).rows);
                break block3;
lbl-1000:
                // 1 sources

                {
                    this.rows.add(rs.nextBinding());
lbl21:
                    // 2 sources

                    ** while (rs.hasNext())
                }
            }
            ++var3_4;
        }
        this.reset();
    }

    public ResultSetMem() {
        this.varNames = new ArrayList<String>();
        this.reset();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.valueOf(Lib.className(this)) + ": Attempt to remove an element");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    @Override
    public Binding nextBinding() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    public void rewind() {
        this.reset();
    }

    @Override
    public void reset() {
        this.iterator = new PeekIterator<Binding>(this.rows.iterator());
        this.rowNumber = 0;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public List<String> getResultVars() {
        return this.varNames;
    }

    @Override
    public QuerySolution peek() {
        return new ResultBinding(this.model, this.peekBinding());
    }

    @Override
    public Binding peekBinding() {
        return this.iterator.element();
    }
}

