/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.TSVInput;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class TSVInputIterator
extends QueryIteratorBase {
    private BufferedReader reader;
    private BindingMap binding;
    private int expectedItems;
    private List<Var> vars;
    private long lineNum = 1L;

    public TSVInputIterator(BufferedReader reader, List<Var> vars) {
        this.reader = reader;
        this.expectedItems = vars.size();
        this.vars = vars;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println("TSVInputIterator");
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.reader != null) {
            if (this.binding == null) {
                return this.parseNextBinding();
            }
            return true;
        }
        return false;
    }

    private boolean parseNextBinding() {
        String line;
        block11: {
            try {
                line = this.reader.readLine();
                if (line != null) break block11;
                return false;
            }
            catch (IOException e2) {
                throw new ResultSetException("Error parsing TSV results - " + e2.getMessage());
            }
        }
        ++this.lineNum;
        if (line.isEmpty()) {
            if (this.expectedItems > 1) {
                throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row had 0/1 values when %d were expected", this.lineNum, this.expectedItems));
            }
            this.binding = BindingFactory.create();
            return true;
        }
        String[] tokens2 = TSVInput.pattern.split(line, -1);
        if (tokens2.length != this.expectedItems) {
            throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row '%s' has %d values instead of the expected %d.", this.lineNum, line, tokens2.length, this.expectedItems));
        }
        this.binding = BindingFactory.create();
        int i = 0;
        while (i < tokens2.length) {
            String token = tokens2[i];
            if (!token.equals("")) {
                try {
                    Node node = NodeFactoryExtra.parseNode(token);
                    if (!node.isConcrete()) {
                        throw new ResultSetException(String.format("Line %d: Not a concrete RDF term: %s", this.lineNum, token));
                    }
                    this.binding.add(this.vars.get(i), node);
                }
                catch (RiotException ex) {
                    throw new ResultSetException(String.format("Line %d: Data %s contains error: %s", this.lineNum, token, ex.getMessage()));
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BindingMap b = this.binding;
        this.binding = null;
        return b;
    }

    @Override
    protected void closeIterator() {
        IO.close(this.reader);
        this.reader = null;
    }

    @Override
    protected void requestCancel() {
    }
}

