/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.OutputBase;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.FileUtils;

public class TextOutput
extends OutputBase {
    protected SerializationContext context = null;
    static final String notThere = " ";

    public TextOutput(Prologue prologue) {
        this.context = new SerializationContext(prologue);
    }

    public TextOutput(PrefixMapping pMap) {
        this.context = new SerializationContext(pMap);
    }

    public TextOutput(SerializationContext cxt) {
        this.context = cxt;
    }

    @Override
    public void format(OutputStream outs, ResultSet resultSet) {
        this.write(outs, resultSet);
    }

    public void format(Writer w, ResultSet resultSet) {
        PrintWriter pw = new PrintWriter(w);
        this.write(pw, resultSet);
        pw.flush();
    }

    private int[] colWidths(ResultSetRewindable rs) {
        int numCols = rs.getResultVars().size();
        int numRows = 0;
        int[] colWidths = new int[numCols];
        int i = 0;
        while (i < numCols) {
            colWidths[i] = rs.getResultVars().get(i).length();
            ++i;
        }
        while (rs.hasNext()) {
            ++numRows;
            QuerySolution rBind = rs.nextSolution();
            int col = -1;
            for (String s1 : rs.getResultVars()) {
                String rVar = s1;
                String s = this.getVarValueAsString(rBind, rVar);
                if (colWidths[++col] >= s.length()) continue;
                colWidths[col] = s.length();
            }
        }
        rs.reset();
        return colWidths;
    }

    public void write(PrintWriter pw, ResultSet resultSet) {
        this.write(pw, resultSet, "| ", " | ", " |");
    }

    public void write(OutputStream outs, ResultSet resultSet) {
        this.write(outs, resultSet, "| ", " | ", " |");
    }

    public void write(OutputStream outs, ResultSet resultSet, String colStart, String colSep, String colEnd) {
        PrintWriter pw = FileUtils.asPrintWriterUTF8(outs);
        this.write(pw, resultSet, colStart, colSep, colEnd);
        pw.flush();
    }

    public void write(PrintWriter pw, ResultSet resultSet, String colStart, String colSep, String colEnd) {
        if (resultSet.getResultVars().size() == 0) {
            pw.println("==== No variables ====");
        }
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable(resultSet);
        int numCols = resultSetRewindable.getResultVars().size();
        int[] colWidths = this.colWidths(resultSetRewindable);
        String[] row = new String[numCols];
        int lineWidth = 0;
        int col = 0;
        while (col < numCols) {
            String rVar;
            row[col] = rVar = resultSet.getResultVars().get(col);
            lineWidth += colWidths[col];
            if (col > 0) {
                lineWidth += colSep.length();
            }
            ++col;
        }
        if (colStart != null) {
            lineWidth += colStart.length();
        }
        if (colEnd != null) {
            lineWidth += colEnd.length();
        }
        int i = 0;
        while (i < lineWidth) {
            pw.print('-');
            ++i;
        }
        pw.println();
        this.printRow(pw, row, colWidths, colStart, colSep, colEnd);
        i = 0;
        while (i < lineWidth) {
            pw.print('=');
            ++i;
        }
        pw.println();
        while (resultSetRewindable.hasNext()) {
            QuerySolution rBind = resultSetRewindable.nextSolution();
            int col2 = 0;
            while (col2 < numCols) {
                String rVar = resultSet.getResultVars().get(col2);
                row[col2] = this.getVarValueAsString(rBind, rVar);
                ++col2;
            }
            this.printRow(pw, row, colWidths, colStart, colSep, colEnd);
        }
        i = 0;
        while (i < lineWidth) {
            pw.print('-');
            ++i;
        }
        pw.println();
        resultSetRewindable = null;
    }

    private void printRow(PrintWriter out, String[] row, int[] colWidths, String rowStart, String colSep, String rowEnd) {
        out.print(rowStart);
        int col = 0;
        while (col < colWidths.length) {
            String s = row[col];
            int pad = colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(colSep);
            }
            sbuff.append(s);
            int j = 0;
            while (j < pad - s.length()) {
                sbuff.append(' ');
                ++j;
            }
            out.print(sbuff);
            ++col;
        }
        out.print(rowEnd);
        out.println();
    }

    protected String getVarValueAsString(QuerySolution rBind, String varName) {
        RDFNode obj = rBind.get(varName);
        if (obj == null) {
            return notThere;
        }
        return FmtUtils.stringForRDFNode(obj, this.context);
    }

    @Override
    public void format(OutputStream out, boolean answer) {
        PrintWriter pw = FileUtils.asPrintWriterUTF8(out);
        if (answer) {
            pw.write("yes");
        } else {
            pw.write("no");
        }
        pw.flush();
    }
}

