/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.util.NodeToLabelMap;

public class SerializationContext {
    private Prologue prologue;
    private NodeToLabelMap bNodeMap;
    private boolean usePlainLiterals = true;

    public SerializationContext(SerializationContext cxt) {
        this.prologue = cxt.prologue;
        this.bNodeMap = cxt.bNodeMap;
    }

    public SerializationContext(Prologue prologue) {
        this(prologue, null);
    }

    public SerializationContext(PrefixMapping prefixMap) {
        this(new Prologue(prefixMap));
    }

    public SerializationContext() {
        this((Prologue)null, (NodeToLabelMap)null);
    }

    public SerializationContext(PrefixMapping prefixMap, NodeToLabelMap bMap) {
        this(new Prologue(prefixMap), bMap);
    }

    public SerializationContext(Prologue prologue, NodeToLabelMap bMap) {
        this.prologue = prologue;
        if (this.prologue == null) {
            this.prologue = new Prologue();
        }
        this.bNodeMap = bMap;
        if (bMap == null) {
            this.bNodeMap = new NodeToLabelMap("b", false);
        }
    }

    public SerializationContext(boolean usePlainLiterals) {
        this((Prologue)null, (NodeToLabelMap)null, usePlainLiterals);
    }

    public SerializationContext(PrefixMapping prefixMap, boolean usePlainLiterals) {
        this(new Prologue(prefixMap), null);
        this.usePlainLiterals = usePlainLiterals;
    }

    public SerializationContext(PrefixMapping prefixMap, NodeToLabelMap bMap, boolean usePlainLiterals) {
        this(new Prologue(prefixMap), bMap);
        this.usePlainLiterals = usePlainLiterals;
    }

    public SerializationContext(Prologue prologue, boolean usePlainLiterals) {
        this(prologue, null, usePlainLiterals);
    }

    public SerializationContext(Prologue prologue, NodeToLabelMap bMap, boolean usePlainLiterals) {
        this(prologue, bMap);
        this.usePlainLiterals = usePlainLiterals;
    }

    public NodeToLabelMap getBNodeMap() {
        return this.bNodeMap;
    }

    public void setBNodeMap(NodeToLabelMap nodeMap) {
        this.bNodeMap = nodeMap;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prologue.getPrefixMapping();
    }

    public void setPrefixMapping(PrefixMapping prefixMap) {
        this.prologue.setPrefixMapping(prefixMap);
    }

    public void setBaseIRI(String baseIRI) {
        this.prologue.setBaseURI(baseIRI);
    }

    public String getBaseIRI() {
        return this.prologue.getBaseURI();
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    public boolean getUsePlainLiterals() {
        return this.usePlainLiterals;
    }

    public void setUsePlainLiterals(boolean usePlainLiterals) {
        this.usePlainLiterals = usePlainLiterals;
    }
}

