/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemException;
import org.apache.jena.sparql.sse.ItemLocation;

public class ItemList
extends ItemLocation
implements Iterable<Item> {
    private final List<Item> elements;
    private final int offset;

    private int index(int i) {
        return this.offset + i;
    }

    private int _size() {
        return this.elements.size() - this.offset;
    }

    private List<Item> slice() {
        return this.elements.subList(this.offset, this.elements.size());
    }

    public ItemList(int line, int column) {
        this(line, column, 0, new ArrayList<Item>());
    }

    public ItemList() {
        this(-1, -1);
    }

    public ItemList(int line, int column, int offset, List<Item> elts) {
        super(line, column);
        this.elements = elts;
        this.offset = offset;
    }

    public int size() {
        return this._size();
    }

    public boolean isEmpty() {
        return this._size() == 0;
    }

    public int hashCode() {
        return this.elements.hashCode() ^ this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ItemList)) {
            return false;
        }
        ItemList list = (ItemList)other;
        if (list.size() != this.size()) {
            return false;
        }
        return this.slice().equals(list.slice());
    }

    public void addAll(ItemList itemList) {
        this.elements.addAll(itemList.elements);
    }

    public void add(Item item) {
        this.elements.add(item);
    }

    public void add(Node node) {
        this.elements.add(Item.createNode(node));
    }

    public void add(String symbol) {
        this.elements.add(Item.createSymbol(symbol));
    }

    public Item get(int idx) {
        return this.elements.get(this.index(idx));
    }

    public Item getFirst() {
        return this.get(0);
    }

    public Item getLast() {
        return this.get(this._size() - 1);
    }

    @Override
    public Iterator<Item> iterator() {
        return this.elements.listIterator(this.offset);
    }

    public Item car() {
        if (this._size() == 0) {
            throw new ItemException("ItemList.car: list is zero length");
        }
        return this.get(0);
    }

    public ItemList cdr() {
        if (this._size() == 0) {
            throw new ItemException("ItemList.cdr: list is zero length");
        }
        ItemList x = new ItemList(super.getLine(), super.getColumn(), this.offset + 1, this.elements);
        return x;
    }

    public ItemList cdrOrNull() {
        if (this._size() == 0) {
            return null;
        }
        ItemList x = new ItemList(super.getLine(), super.getColumn(), this.offset + 1, this.elements);
        return x;
    }

    public ItemList sublist(int start) {
        if (this._size() < start + this.offset) {
            return null;
        }
        ItemList x = new ItemList(-1, -1, this.offset + start, this.elements);
        return x;
    }

    public ItemList sublist(int start, int finish) {
        if (start < 0 || finish < 0 || finish < start) {
            return null;
        }
        if (this._size() < start) {
            return null;
        }
        if (finish > this._size()) {
            return null;
        }
        ItemList x = new ItemList();
        x.elements.addAll(this.elements.subList(start + this.offset, finish + this.offset));
        return x;
    }

    public String shortString() {
        if (this._size() == 0) {
            return "()";
        }
        if (this.get(0).isSymbol()) {
            if (this._size() == 1) {
                return "(" + this.get(0).getSymbol() + ")";
            }
            return "(" + this.get(0).getSymbol() + " ...)";
        }
        return "(...)";
    }

    @Override
    public String toString() {
        String str2 = "";
        if (this.hasLocation()) {
            str2 = str2.concat(this.location());
        }
        return String.valueOf(str2) + this.slice().toString();
    }
}

