/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.util.FmtUtils;

public class BuilderBinding {
    public static Binding build(Item item) {
        BuilderLib.checkList(item, "Attempt to build a binding from non-list: " + item);
        return BuilderBinding.buildBinding(item.getList());
    }

    private static Binding buildBinding(ItemList list) {
        Item head;
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list");
        }
        if (!(head = list.get(0)).isSymbolIgnoreCase("row") && !head.isSymbolIgnoreCase("binding")) {
            BuilderLib.broken((ItemLocation)list, "Does not start (row ...) or (binding ...)", head);
        }
        BindingMap binding = BindingFactory.create();
        int i = 1;
        while (i < list.size()) {
            Item item = list.get(i);
            BuilderLib.checkList(item, "Attempt to build a binding pair from non-list: " + item);
            ItemList pair = item.getList();
            BuilderLib.checkLength(2, pair, "Need a pair for a binding");
            Var v = BuilderNode.buildVar(pair.get(0));
            Item cdr = pair.get(1);
            if (!cdr.isSymbolIgnoreCase("undef") && !cdr.isSymbolIgnoreCase("null")) {
                Node node = BuilderNode.buildNode(item.getList().get(1));
                if (node == null) {
                    BuilderLib.broken(item.getList().get(1), "Null node from " + item.getList().get(1));
                }
                if (node.isVariable()) {
                    BuilderLib.broken(item.getList().get(1), "No variables as table values: " + FmtUtils.stringForNode(node));
                }
                if (!node.isConcrete()) {
                    BuilderLib.broken(item.getList().get(1), "Only concrete nodes as table values: " + FmtUtils.stringForNode(node));
                }
                binding.add(v, node);
            }
            ++i;
        }
        return binding;
    }
}

