/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.lang;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.lang.ParseHandlerPlain;

public abstract class ParseHandlerForm
extends ParseHandlerPlain {
    private boolean inDecl = false;
    private FrameStack frameStack = new FrameStack();

    @Override
    public void listStart(int line, int column) {
        super.listStart(line, column);
    }

    @Override
    public void listFinish(int line, int column) {
        ItemList list = this.currentList();
        if (!this.frameStack.isCurrent(list)) {
            super.listFinish(line, column);
            return;
        }
        if (this.inDecl) {
            ParseHandlerForm.throwException("Inconsistent form: Still in DECL at end of the form", line, column);
        }
        this.inDecl = false;
        this.finishForm(list);
        Frame f = this.frameStack.pop();
        this.popList();
        Item item = f.result;
        this.listAdd(item);
    }

    @Override
    protected void listAdd(Item item) {
        super.listAdd(item);
        ItemList list = super.currentList();
        if (list == null) {
            return;
        }
        Frame lastFrame = this.frameStack.getCurrent();
        if (!this.inDecl && list.size() == 1 && this.isForm(list.getFirst())) {
            this.startForm(list);
            Frame f = new Frame(list);
            this.frameStack.push(f);
            this.inDecl = true;
            return;
        }
        if (this.inDecl) {
            boolean atTopOfDecl;
            boolean bl = atTopOfDecl = lastFrame != null && lastFrame.listItem == list;
            if (!atTopOfDecl) {
                return;
            }
            this.declItem(list, item);
            if (this.endOfDecl(list, item)) {
                this.inDecl = false;
                return;
            }
        }
    }

    protected boolean inFormDecl() {
        return this.inDecl;
    }

    protected abstract void declItem(ItemList var1, Item var2);

    protected abstract boolean isForm(Item var1);

    protected abstract boolean endOfDecl(ItemList var1, Item var2);

    protected abstract void startForm(ItemList var1);

    protected abstract void finishForm(ItemList var1);

    protected void setFormResult(Item item) {
        if (this.frameStack.getCurrent() == null) {
            ParseHandlerForm.throwException("Internal error : no current form", item.getLine(), item.getColumn());
        }
        this.frameStack.getCurrent().result = item;
    }

    private static class Frame {
        ItemList listItem;
        Item result;

        Frame(ItemList listItem) {
            this.listItem = listItem;
        }
    }

    private static class FrameStack {
        private Deque<Frame> frames = new ArrayDeque<Frame>();

        private FrameStack() {
        }

        boolean isCurrent(ItemList list) {
            if (this.frames.size() == 0) {
                return false;
            }
            Frame f = this.frames.peek();
            return f.listItem == list;
        }

        Frame getCurrent() {
            if (this.frames.size() == 0) {
                return null;
            }
            return this.frames.peek();
        }

        void push(Frame f) {
            this.frames.push(f);
        }

        Frame pop() {
            return this.frames.pop();
        }
    }
}

