/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.system.Txn;

public class DatasetUtils {
    private DatasetUtils() {
    }

    public static Dataset createDataset(String uri, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uri, namedSourceList, null);
    }

    public static Dataset createDataset(String uri, List<String> namedSourceList, String baseURI) {
        List<String> uriList = Arrays.asList(uri);
        return DatasetUtils.createDataset(uriList, namedSourceList, baseURI);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.createDataset(uriList, namedSourceList, null);
    }

    public static Dataset createDataset(DatasetDescription datasetDesc) {
        return DatasetUtils.createDataset(datasetDesc, null);
    }

    public static Dataset createDataset(DatasetDescription datasetDesc, String baseURI) {
        return DatasetUtils.createDataset(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), baseURI);
    }

    public static Dataset createDataset(List<String> uriList, List<String> namedSourceList, String baseURI) {
        Dataset ds = DatasetFactory.createGeneral();
        return DatasetUtils.addInGraphs(ds, uriList, namedSourceList, baseURI);
    }

    public static Dataset addInGraphs(Dataset ds, List<String> uriList, List<String> namedSourceList) {
        return DatasetUtils.addInGraphs(ds, uriList, namedSourceList, null);
    }

    public static Dataset addInGraphs(Dataset ds, List<String> uriList, List<String> namedSourceList, String baseURI) {
        DatasetUtils.addInGraphs(ds.asDatasetGraph(), uriList, namedSourceList, baseURI);
        return ds;
    }

    public static DatasetGraph createDatasetGraph(DatasetDescription datasetDesc) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), null);
    }

    public static DatasetGraph createDatasetGraph(DatasetDescription datasetDesc, String baseURI) {
        return DatasetUtils.createDatasetGraph(datasetDesc.getDefaultConstructQuerys(), datasetDesc.getDefaultDescribeQuerys(), datasetDesc.getDefaultServiceConstructQuerys(), datasetDesc.getDefaultServiceDescribeQuerys(), datasetDesc.getDefaultGraphURIs(), datasetDesc.getNamedGraphURIs(), baseURI);
    }

    public static DatasetGraph createDatasetGraph(String uri, List<String> namedSourceList, String baseURI) {
        ArrayList<String> uriList = new ArrayList<String>();
        uriList.add(uri);
        return DatasetUtils.createDatasetGraph(uriList, namedSourceList, baseURI);
    }

    public static DatasetGraph createDatasetGraph(List<String> uriList, List<String> namedSourceList, String baseURI) {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        DatasetUtils.addInGraphs(dsg, uriList, namedSourceList, baseURI);
        return dsg;
    }

    public static DatasetGraph createDatasetGraph(List<Query> constQuerys, List<Query> descQuerys, List<HashMap<String, Object>> servConstQuerys, List<HashMap<String, Object>> servDescQuerys, List<String> uriList, List<String> namedSourceList, String baseURI) {
        DatasetGraph dsg = DatasetGraphFactory.createGeneral();
        DatasetUtils.addInGraphs(dsg, constQuerys, descQuerys, servConstQuerys, servDescQuerys, uriList, namedSourceList, baseURI);
        return dsg;
    }

    public static void addInGraphs(DatasetGraph dsg, List<String> uriList, List<String> namedSourceList) {
        DatasetUtils.addInGraphs(dsg, uriList, namedSourceList, null);
    }

    public static void addInGraphs(DatasetGraph dsg, List<String> uriList, List<String> namedSourceList, String baseURI) {
        if (!dsg.supportsTransactions()) {
            DatasetUtils.addInGraphsWorker(dsg, uriList, namedSourceList, baseURI);
        }
        if (dsg.isInTransaction()) {
            DatasetUtils.addInGraphsWorker(dsg, uriList, namedSourceList, baseURI);
        }
        Txn.executeWrite(dsg, () -> DatasetUtils.addInGraphsWorker(dsg, uriList, namedSourceList, baseURI));
    }

    public static void addInGraphs(DatasetGraph dsg, List<Query> constQuerys, List<Query> descQuerys, List<HashMap<String, Object>> servConstQuerys, List<HashMap<String, Object>> servDescQuerys, List<String> uriList, List<String> namedSourceList, String baseURI) {
        if (!dsg.supportsTransactions()) {
            DatasetUtils.addInGraphsWorker(dsg, constQuerys, descQuerys, servConstQuerys, servDescQuerys, uriList, namedSourceList, baseURI);
        }
        if (dsg.isInTransaction()) {
            DatasetUtils.addInGraphsWorker(dsg, constQuerys, descQuerys, servConstQuerys, servDescQuerys, uriList, namedSourceList, baseURI);
        }
        Txn.executeWrite(dsg, () -> DatasetUtils.addInGraphsWorker(dsg, constQuerys, descQuerys, servConstQuerys, servDescQuerys, uriList, namedSourceList, baseURI));
    }

    private static void addInGraphsWorker(DatasetGraph dsg, List<String> uriList, List<String> namedSourceList, String baseURI) {
        String absBaseURI = null;
        if (baseURI != null) {
            absBaseURI = IRIResolver.resolveString(baseURI);
        }
        if (uriList != null && !uriList.isEmpty()) {
            Graph gTmp = GraphFactory.createJenaDefaultGraph();
            for (String sourceURI : uriList) {
                String absURI = DatasetUtils.baseURI(sourceURI, absBaseURI);
                RDFDataMgr.read(gTmp, sourceURI, absURI, null);
            }
            GraphUtil.addInto(dsg.getDefaultGraph(), gTmp);
        }
        if (namedSourceList != null && !namedSourceList.isEmpty()) {
            for (String sourceURI : namedSourceList) {
                String absURI = DatasetUtils.baseURI(sourceURI, absBaseURI);
                Graph gTmp = GraphFactory.createJenaDefaultGraph();
                RDFDataMgr.read(gTmp, sourceURI, absBaseURI, null);
                Node gn = NodeFactory.createURI(sourceURI);
                dsg.addGraph(gn, gTmp);
            }
        }
    }

    private static void addInGraphsWorker(DatasetGraph dsg, List<Query> constQuerys, List<Query> descQuerys, List<HashMap<String, Object>> servConstQuerys, List<HashMap<String, Object>> servDescQuerys, List<String> uriList, List<String> namedSourceList, String baseURI) {
        QueryEngineHTTP remoteQE;
        Map<String, String> tmpmap;
        String tmpqstring;
        Query tmpq;
        QueryExecution qexec;
        String absBaseURI = null;
        if (baseURI != null) {
            absBaseURI = IRIResolver.resolveString(baseURI);
        }
        if (uriList != null && !uriList.isEmpty()) {
            Graph graph = GraphFactory.createJenaDefaultGraph();
            for (String sourceURI : uriList) {
                String absURI = DatasetUtils.baseURI(sourceURI, absBaseURI);
                RDFDataMgr.read(graph, sourceURI, absURI, null);
            }
            GraphUtil.addInto(dsg.getDefaultGraph(), graph);
        }
        if (constQuerys != null && !constQuerys.isEmpty()) {
            for (Query query2 : constQuerys) {
                qexec = QueryExecutionFactory.create(query2);
                Dataset constds = qexec.execConstructDataset();
                DatasetGraph cdsg = constds.asDatasetGraph();
                GraphUtil.addInto(dsg.getDefaultGraph(), cdsg.getDefaultGraph());
            }
        }
        if (descQuerys != null && !descQuerys.isEmpty()) {
            for (Query query3 : descQuerys) {
                qexec = QueryExecutionFactory.create(query3);
                Model descmod = qexec.execDescribe();
                Dataset descds = DatasetFactory.create(descmod);
                DatasetGraph descg = descds.asDatasetGraph();
                GraphUtil.addInto(dsg.getDefaultGraph(), descg.getDefaultGraph());
            }
        }
        if (servConstQuerys != null && !servConstQuerys.isEmpty()) {
            for (HashMap hashMap : servConstQuerys) {
                tmpq = (Query)hashMap.get("First");
                tmpqstring = tmpq.serialize();
                tmpmap = tmpq.getPrologue().getPrefixMapping().getNsPrefixMap();
                for (Map.Entry<String, String> entry : tmpmap.entrySet()) {
                    tmpqstring = "PREFIX " + entry.getKey() + ": <" + entry.getValue() + ">\n" + tmpqstring;
                }
                remoteQE = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)hashMap.get("Second"), tmpqstring);
                Dataset descds = remoteQE.execConstructDataset();
                DatasetGraph descg = descds.asDatasetGraph();
                GraphUtil.addInto(dsg.getDefaultGraph(), descg.getDefaultGraph());
            }
        }
        if (servDescQuerys != null && !servDescQuerys.isEmpty()) {
            for (HashMap hashMap : servDescQuerys) {
                tmpq = (Query)hashMap.get("First");
                tmpqstring = tmpq.serialize();
                tmpmap = tmpq.getPrologue().getPrefixMapping().getNsPrefixMap();
                for (Map.Entry<String, String> entry : tmpmap.entrySet()) {
                    tmpqstring = "PREFIX " + entry.getKey() + ": <" + entry.getValue() + ">\n" + tmpqstring;
                }
                remoteQE = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)hashMap.get("Second"), tmpqstring);
                Model descmod = remoteQE.execDescribe();
                Dataset descds = DatasetFactory.create(descmod);
                DatasetGraph descg = descds.asDatasetGraph();
                GraphUtil.addInto(dsg.getDefaultGraph(), descg.getDefaultGraph());
            }
        }
        if (namedSourceList != null && !namedSourceList.isEmpty()) {
            for (String sourceURI : namedSourceList) {
                String absURI = DatasetUtils.baseURI(sourceURI, absBaseURI);
                Graph gTmp = GraphFactory.createJenaDefaultGraph();
                RDFDataMgr.read(gTmp, sourceURI, absBaseURI, null);
                Node gn = NodeFactory.createURI(sourceURI);
                dsg.addGraph(gn, gTmp);
            }
        }
    }

    private static String baseURI(String sourceURI, String absBaseURI) {
        if (absBaseURI == null) {
            return IRIResolver.resolveString(sourceURI);
        }
        return IRIResolver.resolveString(sourceURI, absBaseURI);
    }
}

