/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.tdb.base.file.FileBase;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.file.PlainFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainFilePersistent
extends PlainFile {
    private static Logger log = LoggerFactory.getLogger(PlainFilePersistent.class);
    private FileBase file;

    PlainFilePersistent(Location loc, String filename) {
        this(loc.getPath(filename, "dat"));
    }

    PlainFilePersistent(String filename) {
        this.file = FileBase.create(filename);
        this.byteBuffer = this.allocateBuffer(this.filesize);
    }

    @Override
    public void sync() {
        this.file.sync();
    }

    @Override
    public void close() {
        this.file.close();
    }

    @Override
    protected ByteBuffer allocateBuffer(long size) {
        try {
            return this.file.channel().map(FileChannel.MapMode.READ_WRITE, 0L, size);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }
}

