/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.page;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.page.Page;

public abstract class PageBase
implements Page {
    private final int id;
    private Block block;

    protected PageBase(Block block) {
        this.block = block;
        long x = block.getId();
        if (x < 0L) {
            throw new TDBException("Page id is negative: " + x);
        }
        if (x > Integer.MAX_VALUE) {
            throw new TDBException("Page id is large than MAX_INT: " + x);
        }
        this.id = block.getId().intValue();
    }

    @Override
    public final void reset(Block block2) {
        if (block2.getId() != (long)this.id) {
            Log.error(this, "Block id changed: " + this.id + " => " + block2.getId());
        }
        this._reset(block2);
        this.block = block2;
    }

    protected abstract void _reset(Block var1);

    @Override
    public final Block getBackingBlock() {
        return this.block;
    }

    @Override
    public final int getId() {
        return this.id;
    }
}

