/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.loader.BulkLoaderException;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class DataToTuplesInlineSingle
implements StreamRDFCounting,
BulkStartFinish {
    public static final int DataTickPoint = 100000;
    public static final int DataSuperTick = 10;
    private final Consumer<Tuple<NodeId>> dest3;
    private final Consumer<Tuple<NodeId>> dest4;
    private final DatasetGraphTDB dsgtdb;
    private final NodeTable nodeTable;
    private final DatasetPrefixStorage prefixes;
    private final MonitorOutput output;
    private long countTriples = 0L;
    private long countQuads = 0L;
    private List<Tuple<NodeId>> quads = null;
    private List<Tuple<NodeId>> triples = null;
    private TransactionCoordinator coordinator;
    private Transaction transaction;

    public DataToTuplesInlineSingle(DatasetGraphTDB dsgtdb, Consumer<Tuple<NodeId>> dest3, Consumer<Tuple<NodeId>> dest4, MonitorOutput output) {
        this.dsgtdb = dsgtdb;
        this.dest3 = dest3;
        this.dest4 = dest4;
        this.output = output;
        this.nodeTable = dsgtdb.getTripleTable().getNodeTupleTable().getNodeTable();
        this.prefixes = dsgtdb.getPrefixes();
        NodeTable nodeTable2 = dsgtdb.getQuadTable().getNodeTupleTable().getNodeTable();
        if (this.nodeTable != nodeTable2) {
            throw new BulkLoaderException("Different node tables");
        }
    }

    @Override
    public void startBulk() {
        this.coordinator = CoLib.newCoordinator();
        CoLib.add(this.coordinator, this.nodeTable);
        NodeTupleTable p = ((DatasetPrefixesTDB)this.prefixes).getNodeTupleTable();
        CoLib.add(this.coordinator, p.getNodeTable());
        CoLib.add(this.coordinator, p.getTupleTable().getIndexes());
        CoLib.start(this.coordinator);
        this.transaction = this.coordinator.begin(TxnType.WRITE);
    }

    @Override
    public void finishBulk() {
        this.transaction.commit();
        this.transaction.end();
        CoLib.finish(this.coordinator);
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
    }

    @Override
    public long count() {
        return this.countTriples() + this.countQuads();
    }

    @Override
    public long countTriples() {
        return this.countTriples;
    }

    @Override
    public long countQuads() {
        return this.countQuads;
    }

    @Override
    public void triple(Triple triple) {
        ++this.countTriples;
        Tuple<NodeId> tuple = DataToTuplesInlineSingle.nodes(this.nodeTable, triple);
        this.dest3.accept(tuple);
    }

    @Override
    public void quad(Quad quad) {
        if (quad.isTriple() || quad.isDefaultGraph()) {
            this.triple(quad.asTriple());
            return;
        }
        ++this.countQuads;
        Tuple<NodeId> tuple = DataToTuplesInlineSingle.nodes(this.nodeTable, quad);
        this.dest4.accept(tuple);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.prefixes.insertPrefix("", prefix, iri2);
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Triple triple) {
        NodeId s = DataToTuplesInlineSingle.idForNode(nt, triple.getSubject());
        NodeId p = DataToTuplesInlineSingle.idForNode(nt, triple.getPredicate());
        NodeId o = DataToTuplesInlineSingle.idForNode(nt, triple.getObject());
        return TupleFactory.tuple(s, p, o);
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Quad quad) {
        NodeId g = DataToTuplesInlineSingle.idForNode(nt, quad.getGraph());
        NodeId s = DataToTuplesInlineSingle.idForNode(nt, quad.getSubject());
        NodeId p = DataToTuplesInlineSingle.idForNode(nt, quad.getPredicate());
        NodeId o = DataToTuplesInlineSingle.idForNode(nt, quad.getObject());
        return TupleFactory.tuple(g, s, p, o);
    }

    private static final NodeId idForNode(NodeTable nodeTable, Node node) {
        return nodeTable.getAllocateNodeId(node);
    }
}

