/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Node;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.LoaderBase;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitor;
import org.apache.jena.tdb2.loader.base.ProgressMonitorOutput;
import org.apache.jena.tdb2.loader.main.BulkProcesses;
import org.apache.jena.tdb2.loader.main.DataBatcher;
import org.apache.jena.tdb2.loader.main.DataBlock;
import org.apache.jena.tdb2.loader.main.DataToTuples;
import org.apache.jena.tdb2.loader.main.DataToTuplesInline;
import org.apache.jena.tdb2.loader.main.DataToTuplesInlineSingle;
import org.apache.jena.tdb2.loader.main.Destination;
import org.apache.jena.tdb2.loader.main.Indexer;
import org.apache.jena.tdb2.loader.main.IndexerInline;
import org.apache.jena.tdb2.loader.main.LoaderPlan;
import org.apache.jena.tdb2.loader.main.PhasedOps;
import org.apache.jena.tdb2.loader.main.PrefixHandler;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.sys.TDBInternal;

public class LoaderMain
extends LoaderBase
implements DataLoader {
    public static final int DataTickPoint = 500000;
    public static final int DataSuperTick = 10;
    public static final int IndexTickPoint = 1000000;
    public static final int IndexSuperTick = 10;
    private final LoaderPlan loaderPlan;
    private final DatasetGraphTDB dsgtdb;
    private final StreamRDF stream;
    private final Map<String, TupleIndex> indexMap;
    private final StreamRDFCounting dataInput;
    private final List<BulkStartFinish> dataProcess = new ArrayList<BulkStartFinish>();

    public LoaderMain(LoaderPlan loaderPlan, DatasetGraph dsg, MonitorOutput output) {
        this(loaderPlan, dsg, null, output);
    }

    public LoaderMain(LoaderPlan loaderPlan, DatasetGraph dsg, Node graphName, MonitorOutput output) {
        super(dsg, graphName, output);
        this.loaderPlan = loaderPlan;
        this.dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        this.indexMap = PhasedOps.indexMap(this.dsgtdb);
        switch (loaderPlan.dataInputType()) {
            case MULTI: {
                this.dataInput = LoaderMain.executeData(loaderPlan, this.dsgtdb, this.indexMap, this.dataProcess, output);
                break;
            }
            case PARSE_NODE: {
                this.dataInput = LoaderMain.executeDataParseId(loaderPlan, this.dsgtdb, this.indexMap, this.dataProcess, output);
                break;
            }
            case PARSE_NODE_INDEX: {
                this.dataInput = LoaderMain.executeDataOneThread(loaderPlan, this.dsgtdb, this.indexMap, this.dataProcess, output);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.stream = LoaderOps.toNamedGraph(this.dataInput, graphName);
    }

    private static StreamRDFCounting executeData(LoaderPlan loaderPlan, DatasetGraphTDB dsgtdb, Map<String, TupleIndex> indexMap, List<BulkStartFinish> dataProcess, MonitorOutput output) {
        DataBatcher dataBatcher;
        DatasetPrefixesTDB dps = (DatasetPrefixesTDB)dsgtdb.getPrefixes();
        PrefixHandler prefixHandler = new PrefixHandler(dps, output);
        dataProcess.add(prefixHandler);
        TupleIndex[] idx3 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad3(), indexMap);
        Indexer indexer3 = new Indexer(output, idx3);
        TupleIndex[] idx4 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad4(), indexMap);
        Indexer indexer4 = new Indexer(output, idx4);
        dataProcess.add(indexer4);
        dataProcess.add(indexer3);
        Destination<Tuple<NodeId>> functionIndexer3 = indexer3.index();
        Destination<Tuple<NodeId>> functionIndexer4 = indexer4.index();
        DataToTuples dtt = new DataToTuples(dsgtdb, functionIndexer3, functionIndexer4, output);
        Consumer<DataBlock> dest = dtt.data();
        DataBatcher baseInput = dataBatcher = new DataBatcher(dest, prefixHandler.handler(), output);
        dataProcess.add(dtt);
        dataProcess.add(dataBatcher);
        return dataBatcher;
    }

    private static StreamRDFCounting executeDataParseId(LoaderPlan loaderPlan, DatasetGraphTDB dsgtdb, Map<String, TupleIndex> indexMap, List<BulkStartFinish> dataProcess, MonitorOutput output) {
        TupleIndex[] idx3 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad3(), indexMap);
        Indexer indexer3 = new Indexer(output, idx3);
        TupleIndex[] idx4 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad4(), indexMap);
        Indexer indexer4 = new Indexer(output, idx4);
        DataToTuplesInline dttInline = new DataToTuplesInline(dsgtdb, indexer3.index(), indexer4.index(), output);
        dataProcess.add(indexer3);
        dataProcess.add(indexer4);
        dataProcess.add(dttInline);
        return dttInline;
    }

    private static StreamRDFCounting executeDataOneThread(LoaderPlan loaderPlan, DatasetGraphTDB dsgtdb, Map<String, TupleIndex> indexMap, List<BulkStartFinish> dataProcess, MonitorOutput output) {
        TupleIndex[] idx3 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad3(), indexMap);
        IndexerInline indexer3 = new IndexerInline(output, idx3);
        Consumer<Tuple<NodeId>> dest3 = tuple -> indexer3.load((Tuple<NodeId>)tuple);
        TupleIndex[] idx4 = PhasedOps.indexSetFromNames(loaderPlan.primaryLoad4(), indexMap);
        IndexerInline indexer4 = new IndexerInline(output, idx4);
        Consumer<Tuple<NodeId>> dest4 = tuple -> indexer4.load((Tuple<NodeId>)tuple);
        DataToTuplesInlineSingle dataToTuples = new DataToTuplesInlineSingle(dsgtdb, dest3, dest4, output);
        dataProcess.add(indexer3);
        dataProcess.add(indexer4);
        dataProcess.add(dataToTuples);
        return dataToTuples;
    }

    @Override
    public StreamRDF stream() {
        return this.stream;
    }

    @Override
    public boolean bulkUseTransaction() {
        return false;
    }

    @Override
    public void startBulk() {
        this.dsgtdb.getTxnSystem().getTxnMgr().startExclusiveMode();
        super.startBulk();
        BulkProcesses.start(this.dataProcess);
    }

    @Override
    public void finishBulk() {
        boolean doQuads;
        BulkProcesses.finish(this.dataProcess);
        boolean doTriples = this.countTriples() != 0L;
        boolean bl = doQuads = this.countQuads() != 0L;
        if (doTriples) {
            TupleIndex srcIdx3 = PhasedOps.findInIndexMap(this.loaderPlan.primaryLoad3()[0], this.indexMap);
            TupleIndex[][] indexSets3 = PhasedOps.indexSetsFromNames(this.loaderPlan.secondaryIndex3(), this.indexMap);
            LoaderMain.executeSecondary(srcIdx3, indexSets3, this.dsgtdb, this.output);
        }
        if (doQuads) {
            TupleIndex srcIdx4 = PhasedOps.findInIndexMap(this.loaderPlan.primaryLoad4()[0], this.indexMap);
            TupleIndex[][] indexSets4 = PhasedOps.indexSetsFromNames(this.loaderPlan.secondaryIndex4(), this.indexMap);
            LoaderMain.executeSecondary(srcIdx4, indexSets4, this.dsgtdb, this.output);
        }
        super.finishBulk();
        this.dsgtdb.getTxnSystem().getTxnMgr().finishExclusiveMode();
    }

    private static void executeSecondary(TupleIndex srcIdx, TupleIndex[][] indexSets, DatasetGraphTDB dsgtdb, MonitorOutput output) {
        if (indexSets.length == 0) {
            return;
        }
        ArrayList<BulkStartFinish> processes = new ArrayList<BulkStartFinish>();
        output.print("Start replay index %s", srcIdx.getName());
        for (TupleIndex[] indexes : indexSets) {
            if (indexes.length == 0) continue;
            LoaderMain.indexPhase(processes, srcIdx, indexes, output);
        }
        BulkProcesses.finish(processes);
    }

    private static void indexPhase(List<BulkStartFinish> processes, TupleIndex srcIdx, TupleIndex[] indexes, MonitorOutput output) {
        String indexSetLabel = PhasedOps.indexMappings(indexes);
        output.print("Index set:  %s => %s", srcIdx.getName(), indexSetLabel);
        Indexer indexer = new Indexer(output, indexes);
        Destination<Tuple<NodeId>> dest = indexer.index();
        indexer.startBulk();
        TransactionCoordinator coordinator = CoLib.newCoordinator();
        CoLib.add(coordinator, srcIdx);
        CoLib.start(coordinator);
        Transaction transaction = coordinator.begin(TxnType.READ);
        processes.add(indexer);
        PhasedOps.ReplayResult result = PhasedOps.replay(srcIdx, dest, output);
        transaction.end();
        String timeStr = "---";
        if (result.elapsed != 0L) {
            double time = (double)result.elapsed / 1000.0;
            timeStr = String.format("%,.1f", time);
        }
        output.print("Index set:  %s => %s [%,d items, %s seconds]", srcIdx.getName(), indexSetLabel, result.items, timeStr);
    }

    @Override
    public void finishException(Exception ex) {
        try {
            this.dsgtdb.getTxnSystem().getTxnMgr().finishExclusiveMode();
        }
        catch (Exception ex2) {
            ex.addSuppressed(ex2);
        }
    }

    @Override
    public long countTriples() {
        return this.dataInput.countTriples();
    }

    @Override
    public long countQuads() {
        return this.dataInput.countQuads();
    }

    @Override
    protected ProgressMonitor createProgressMonitor(MonitorOutput output) {
        return ProgressMonitorOutput.create(output, "<unset>", 500000L, 10);
    }
}

