/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.RepeatApplyIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.tdb2.solver.BindingNodeId;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class StageMatchTuple
extends RepeatApplyIterator<BindingNodeId> {
    private final NodeTupleTable nodeTupleTable;
    private final Tuple<Node> patternTuple;
    private final ExecutionContext execCxt;
    private boolean anyGraphs;
    private Predicate<Tuple<NodeId>> filter;
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4(NodeId.NodeIdAny, item.get(1), item.get(2), item.get(3));

    public StageMatchTuple(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> tuple, boolean anyGraphs, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        super(input);
        this.filter = filter;
        this.nodeTupleTable = nodeTupleTable;
        this.patternTuple = tuple;
        this.execCxt = execCxt;
        this.anyGraphs = anyGraphs;
    }

    public static boolean prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.len(); ++i) {
            Node n = patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.isDoesNotExist(nId)) {
                return false;
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
        return true;
    }

    @Override
    protected Iterator<BindingNodeId> makeNextStage(BindingNodeId input) {
        NodeId[] ids = new NodeId[this.patternTuple.len()];
        Var[] var = new Var[this.patternTuple.len()];
        boolean b = StageMatchTuple.prepare(this.nodeTupleTable.getNodeTable(), this.patternTuple, input, ids, var);
        if (!b) {
            return Iter.nullIterator();
        }
        Iterator<Tuple<NodeId>> iterMatches = this.nodeTupleTable.find(TupleFactory.create(ids));
        if (this.filter != null) {
            iterMatches = Iter.filter(iterMatches, this.filter);
        }
        if (this.anyGraphs) {
            iterMatches = Iter.map(iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent(iterMatches);
        }
        Function<Tuple, BindingNodeId> binder = tuple -> {
            BindingNodeId output = new BindingNodeId(input);
            for (int i = 0; i < var.length; ++i) {
                Var v = var[i];
                if (v == null) continue;
                NodeId id = (NodeId)tuple.get(i);
                if (StageMatchTuple.reject(output, v, id)) {
                    return null;
                }
                output.put(v, id);
            }
            return output;
        };
        return Iter.iter(iterMatches).map(binder).removeNulls();
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List<Tuple<NodeId>> r = Iter.toList(iter);
            String str2 = Iter.asString(r, "\n");
            System.err.println(str2);
            iter = Iter.iter(r);
        }
        return iter;
    }

    private static boolean reject(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return false;
        }
        return !((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar(node)) {
            return Var.alloc(node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar(node)) {
            NodeId n = (NodeId)input.get(Var.alloc(node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

