/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.graph.GraphPrefixesProjection;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class DatasetPrefixesTDB
implements DatasetPrefixStorage {
    static final RecordFactory factory = new RecordFactory(24, 0);
    public static final String unnamedGraphURI = "";
    private final NodeTupleTable nodeTupleTable;

    public DatasetPrefixesTDB(NodeTupleTable nodeTupleTable) {
        this.nodeTupleTable = nodeTupleTable;
    }

    @Override
    public void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        Node g = NodeFactory.createURI(graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        iter.forEachRemaining(tuple -> {
            Node prefix = (Node)tuple.get(1);
            Node uri = (Node)tuple.get(2);
            pmap.setNsPrefix(prefix.getLiteralLexicalForm(), uri.getURI());
        });
    }

    @Override
    public void insertPrefix(String graphName, String prefix, String uri) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        Node u = NodeFactory.createURI(uri);
        this.nodeTupleTable.addRow(g, p, u);
    }

    @Override
    public Set<String> graphNames() {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(new Node[]{null, null, null});
        HashSet<String> x = new HashSet<String>();
        while (iter.hasNext()) {
            x.add(iter.next().get(0).getURI());
        }
        Iter.close(iter);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readPrefix(String graphName, String prefix) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        try {
            if (!iter.hasNext()) {
                String string = null;
                return string;
            }
            Tuple<Node> t = iter.next();
            Node uri = t.get(2);
            String string = uri.getURI();
            return string;
        }
        finally {
            Iter.close(iter);
        }
    }

    @Override
    public String readByURI(String graphName, String uriStr) {
        Node g = NodeFactory.createURI(graphName);
        Node u = NodeFactory.createURI(uriStr);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, u);
        if (!iter.hasNext()) {
            return null;
        }
        Node prefix = iter.next().get(1);
        Iter.close(iter);
        return prefix.getLiteralLexicalForm();
    }

    @Override
    public Map<String, String> readPrefixMap(String graphName) {
        HashMap<String, String> map = new HashMap<String, String>();
        Node g = NodeFactory.createURI(graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            try {
                Tuple<Node> t = iter.next();
                String prefix = t.get(1).getLiteralLexicalForm();
                String uri = t.get(2).getURI();
                map.put(prefix, uri);
            }
            catch (Exception ex) {
                Log.warn(this, "Mangled prefix map: graph name=" + graphName, (Throwable)ex);
            }
        }
        Iter.close(iter);
        return map;
    }

    @Override
    public void removeFromPrefixMap(String graphName, String prefix) {
        Node g = NodeFactory.createURI(graphName);
        Node p = NodeFactory.createLiteral(prefix);
        this.removeAll(g, p, null);
    }

    @Override
    public void removeAllFromPrefixMap(String graphName) {
        Node g = NodeFactory.createURI(graphName);
        this.removeAll(g, null, null);
    }

    private synchronized void removeAll(Node g, Node p, Node uri) {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, uri);
        List<Tuple<Node>> list = Iter.toList(iter);
        Iter.close(iter);
        for (Tuple<Node> tuple : list) {
            this.nodeTupleTable.deleteRow(tuple.get(0), tuple.get(1), tuple.get(2));
        }
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.nodeTupleTable;
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(unnamedGraphURI);
    }

    @Override
    public PrefixMapping getPrefixMapping(String graphName) {
        GraphPrefixesProjection pm = new GraphPrefixesProjection(graphName, this);
        return pm;
    }

    @Override
    public void close() {
        this.nodeTupleTable.close();
    }

    @Override
    public void sync() {
        this.nodeTupleTable.sync();
    }
}

