/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.lang.UpdateParser;
import org.apache.jena.sparql.modify.UpdateRequestSink;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.modify.UsingList;
import org.apache.jena.sparql.modify.UsingUpdateSink;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateRequest;

public class UpdateFactory {
    public static UpdateRequest create() {
        return new UpdateRequest();
    }

    public static UpdateRequest create(String string) {
        return UpdateFactory.create(string, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest create(String string, Syntax syntax) {
        return UpdateFactory.create(string, null, syntax);
    }

    public static UpdateRequest create(String string, String baseURI) {
        return UpdateFactory.create(string, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest create(String string, String baseURI, Syntax syntax) {
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.make(request, string, baseURI, syntax);
        return request;
    }

    private static void make(UpdateRequest request, String input, String baseURI, Syntax syntax) {
        UpdateParser parser = UpdateFactory.setupParser(request, baseURI, syntax);
        parser.parse((UpdateSink)new UpdateRequestSink(request), input);
    }

    public static void parse(UpdateRequest request, String updateString) {
        UpdateFactory.make(request, updateString, null, Syntax.defaultUpdateSyntax);
    }

    public static void parse(UpdateRequest request, String updateString, Syntax syntax) {
        UpdateFactory.make(request, updateString, null, syntax);
    }

    public static void parse(UpdateRequest request, String updateString, String baseURI) {
        UpdateFactory.make(request, updateString, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static void parse(UpdateRequest request, String updateString, String baseURI, Syntax syntax) {
        UpdateFactory.make(request, updateString, baseURI, syntax);
    }

    protected static UpdateParser setupParser(Prologue prologue, String baseURI, Syntax syntax) {
        UpdateParser parser = UpdateParser.createParser(syntax);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing update: " + syntax);
        }
        if (prologue.getResolver() == null) {
            IRIResolver resolver = null;
            try {
                resolver = baseURI != null ? IRIResolver.create(baseURI) : IRIResolver.create();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resolver == null) {
                resolver = IRIResolver.create("http://localhost/update/defaultBase#");
            }
            prologue.setResolver(resolver);
        }
        return parser;
    }

    public static UpdateRequest read(UsingList usingList, String fileName) {
        return UpdateFactory.read(usingList, fileName, null, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(String fileName) {
        return UpdateFactory.read(fileName, fileName, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(String fileName, Syntax syntax) {
        return UpdateFactory.read(fileName, fileName, syntax);
    }

    public static UpdateRequest read(UsingList usingList, String fileName, Syntax syntax) {
        return UpdateFactory.read(usingList, fileName, fileName, syntax);
    }

    public static UpdateRequest read(String fileName, String baseURI, Syntax syntax) {
        return UpdateFactory.read(null, fileName, baseURI, syntax);
    }

    public static UpdateRequest read(UsingList usingList, String fileName, String baseURI, Syntax syntax) {
        InputStream in = null;
        try {
            if (fileName.equals("-")) {
                in = System.in;
            } else {
                in = IO.openFile(fileName);
                if (in == null) {
                    throw new UpdateException("File could not be opened: " + fileName);
                }
            }
            UpdateRequest updateRequest = UpdateFactory.read(usingList, in, baseURI, syntax);
            return updateRequest;
        }
        finally {
            if (in != null && !fileName.equals("-")) {
                IO.close(in);
            }
        }
    }

    public static UpdateRequest read(InputStream input) {
        return UpdateFactory.read(input, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input) {
        return UpdateFactory.read(usingList, input, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(InputStream input, Syntax syntax) {
        return UpdateFactory.read(input, null, syntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, Syntax syntax) {
        return UpdateFactory.read(usingList, input, null, syntax);
    }

    public static UpdateRequest read(InputStream input, String baseURI) {
        return UpdateFactory.read(input, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, String baseURI) {
        return UpdateFactory.read(usingList, input, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(InputStream input, String baseURI, Syntax syntax) {
        return UpdateFactory.read(null, input, baseURI, syntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, String baseURI, Syntax syntax) {
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.make(request, usingList, input, baseURI, syntax);
        return request;
    }

    private static void make(UpdateRequest request, UsingList usingList, InputStream input, String baseURI, Syntax syntax) {
        UpdateParser parser = UpdateFactory.setupParser(request, baseURI, syntax);
        try (UsingUpdateSink sink = new UsingUpdateSink(new UpdateRequestSink(request), usingList);){
            parser.parse((UpdateSink)sink, input);
        }
    }
}

