/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TSaslTransportException;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TThreadPoolServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private final TimeUnit stopTimeoutUnit;
    private final long stopTimeoutVal;
    private final TimeUnit requestTimeoutUnit;
    private final long requestTimeout;
    private final long beBackoffSlotInMillis;
    private Random random = new Random(System.currentTimeMillis());

    public TThreadPoolServer(Args args) {
        super(args);
        this.stopTimeoutUnit = args.stopTimeoutUnit;
        this.stopTimeoutVal = args.stopTimeoutVal;
        this.requestTimeoutUnit = args.requestTimeoutUnit;
        this.requestTimeout = args.requestTimeout;
        this.beBackoffSlotInMillis = args.beBackoffSlotLengthUnit.toMillis(args.beBackoffSlotLength);
        this.executorService_ = args.executorService != null ? args.executorService : TThreadPoolServer.createDefaultExecutorService(args);
    }

    private static ExecutorService createDefaultExecutorService(Args args) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, args.stopTimeoutVal, TimeUnit.SECONDS, executorQueue);
    }

    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.stopped_ = false;
        this.setServing(true);
        int failureCount = 0;
        block10: while (!this.stopped_) {
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                int retryCount = 0;
                long remainTimeInMillis = this.requestTimeoutUnit.toMillis(this.requestTimeout);
                while (true) {
                    try {
                        this.executorService_.execute(wp);
                        continue block10;
                    }
                    catch (Throwable t) {
                        if (t instanceof RejectedExecutionException) {
                            ++retryCount;
                            try {
                                if (remainTimeInMillis > 0L) {
                                    long sleepTimeInMillis = (long)(this.random.nextDouble() * (double)(1L << Math.min(retryCount, 20))) * this.beBackoffSlotInMillis;
                                    sleepTimeInMillis = Math.min(sleepTimeInMillis, remainTimeInMillis);
                                    TimeUnit.MILLISECONDS.sleep(sleepTimeInMillis);
                                    remainTimeInMillis -= sleepTimeInMillis;
                                    continue;
                                }
                                client.close();
                                wp = null;
                                LOGGER.warn("Task has been rejected by ExecutorService " + retryCount + " times till timedout, reason: " + t);
                            }
                            catch (InterruptedException e2) {
                                LOGGER.warn("Interrupted while waiting to place client on executor queue.");
                                Thread.currentThread().interrupt();
                            }
                            continue block10;
                        }
                        if (t instanceof Error) {
                            LOGGER.error("ExecutorService threw error: " + t, t);
                            throw (Error)t;
                        }
                        LOGGER.warn("ExecutorService threw error: " + t, t);
                    }
                    break;
                }
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", ttx);
            }
        }
        this.executorService_.shutdown();
        long now2 = System.currentTimeMillis();
        for (long timeoutMS = this.stopTimeoutUnit.toMillis(this.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now2) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now2 = newnow;
                continue;
            }
        }
        this.setServing(false);
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            TServerEventHandler eventHandler = null;
            ServerContext connectionContext = null;
            try {
                processor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                eventHandler = TThreadPoolServer.this.getEventHandler();
                if (eventHandler != null) {
                    connectionContext = eventHandler.createContext(inputProtocol, outputProtocol);
                }
                do {
                    if (eventHandler == null) continue;
                    eventHandler.processContext(connectionContext, inputTransport, outputTransport);
                } while (!TThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol));
                if (eventHandler != null) {
                    eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                }
                if (inputTransport != null) {
                    inputTransport.close();
                }
                if (outputTransport != null) {
                    outputTransport.close();
                }
                if (!this.client_.isOpen()) return;
                this.client_.close();
                return;
            }
            catch (TSaslTransportException tSaslTransportException) {
                if (eventHandler != null) {
                    eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                }
                if (inputTransport != null) {
                    inputTransport.close();
                }
                if (outputTransport != null) {
                    outputTransport.close();
                }
                if (!this.client_.isOpen()) return;
                this.client_.close();
                return;
                catch (TTransportException tTransportException) {
                    if (eventHandler != null) {
                        eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                    }
                    if (inputTransport != null) {
                        inputTransport.close();
                    }
                    if (outputTransport != null) {
                        outputTransport.close();
                    }
                    if (!this.client_.isOpen()) return;
                    this.client_.close();
                    return;
                    catch (TException tx) {
                        LOGGER.error("Thrift error occurred during processing of message.", tx);
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        catch (Exception x) {
                            LOGGER.error("Error occurred during processing of message.", x);
                            return;
                        }
                    }
                }
            }
            finally {
                if (eventHandler != null) {
                    eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                }
                if (inputTransport != null) {
                    inputTransport.close();
                }
                if (outputTransport != null) {
                    outputTransport.close();
                }
                if (this.client_.isOpen()) {
                    this.client_.close();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends TServer.AbstractServerArgs<Args> {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public ExecutorService executorService;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
        public int requestTimeout = 20;
        public TimeUnit requestTimeoutUnit = TimeUnit.SECONDS;
        public int beBackoffSlotLength = 100;
        public TimeUnit beBackoffSlotLengthUnit = TimeUnit.MILLISECONDS;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public Args minWorkerThreads(int n) {
            this.minWorkerThreads = n;
            return this;
        }

        public Args maxWorkerThreads(int n) {
            this.maxWorkerThreads = n;
            return this;
        }

        public Args stopTimeoutVal(int n) {
            this.stopTimeoutVal = n;
            return this;
        }

        public Args requestTimeout(int n) {
            this.requestTimeout = n;
            return this;
        }

        public Args requestTimeoutUnit(TimeUnit tu) {
            this.requestTimeoutUnit = tu;
            return this;
        }

        public Args beBackoffSlotLength(int n) {
            this.beBackoffSlotLength = n;
            return this;
        }

        public Args beBackoffSlotLengthUnit(TimeUnit tu) {
            this.beBackoffSlotLengthUnit = tu;
            return this;
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

