/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;

public class ConnectionSet
implements Serializable {
    protected Set connections = new HashSet();
    protected Set edges = new HashSet();

    public static ConnectionSet create(GraphModel graphModel, Object[] objectArray, boolean bl) {
        ConnectionSet connectionSet = new ConnectionSet();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (graphModel.isEdge(object)) {
                if (bl) {
                    connectionSet.disconnect(object);
                } else {
                    connectionSet.connect(object, graphModel.getSource(object), graphModel.getTarget(object));
                }
            }
            Iterator iterator = graphModel.edges(object);
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (graphModel.getSource(e2) == object) {
                    ConnectionSet.connect(connectionSet, e2, object, true, bl);
                    continue;
                }
                if (graphModel.getTarget(e2) != object) continue;
                ConnectionSet.connect(connectionSet, e2, object, false, bl);
            }
        }
        return connectionSet;
    }

    public ConnectionSet() {
    }

    public ConnectionSet(Object object, Object object2, boolean bl) {
        this.connect(object, object2, bl);
    }

    public ConnectionSet(Set set) {
        this.setConnections(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            this.edges.add(connection.getEdge());
        }
    }

    public ConnectionSet(Object object, Object object2, Object object3) {
        this.connect(object, object2, object3);
    }

    protected static void connect(ConnectionSet connectionSet, Object object, Object object2, boolean bl, boolean bl2) {
        if (bl2) {
            connectionSet.disconnect(object, bl);
        } else {
            connectionSet.connect(object, object2, bl);
        }
    }

    public void addConnections(CellView[] cellViewArray) {
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)cellViewArray[i];
            Object object = edgeView.getCell();
            CellView cellView = edgeView.getSource();
            CellView cellView2 = edgeView.getTarget();
            Object object2 = null;
            if (cellView != null) {
                object2 = cellView.getCell();
            }
            Object object3 = null;
            if (cellView2 != null) {
                object3 = cellView2.getCell();
            }
            this.connect(object, object2, object3);
        }
    }

    public void connect(Object object, Object object2, Object object3) {
        this.connect(object, object2, true);
        this.connect(object, object3, false);
    }

    public void connect(Object object, Object object2, boolean bl) {
        Connection connection = new Connection(object, object2, bl);
        this.connections.remove(connection);
        this.connections.add(connection);
        this.edges.add(object);
    }

    public void disconnect(Object object) {
        this.disconnect(object, true);
        this.disconnect(object, false);
    }

    public void disconnect(Object object, boolean bl) {
        this.connections.add(new Connection(object, null, bl));
        this.edges.add(object);
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public int size() {
        return this.connections.size();
    }

    public Iterator connections() {
        return this.connections.iterator();
    }

    public Set getChangedEdges() {
        return this.edges;
    }

    public Object getPort(Object object, boolean bl) {
        if (this.edges.contains(object)) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                if (connection.getEdge() != object || connection.isSource() != bl) continue;
                return connection.getPort();
            }
        }
        return null;
    }

    public ConnectionSet clone(Map map) {
        ConnectionSet connectionSet = new ConnectionSet();
        Iterator iterator = this.connections();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            Object v = map.get(connection.getEdge());
            Object object = connection.getPort();
            if (object != null) {
                object = map.get(object);
            }
            if (v != null && object != null) {
                connectionSet.connect(v, object, connection.isSource());
                continue;
            }
            if (v == null) continue;
            connectionSet.connect(v, connection.getPort(), connection.isSource());
        }
        return connectionSet;
    }

    public Set getConnections() {
        return this.connections;
    }

    public Set getEdges() {
        return this.edges;
    }

    public void setConnections(Set set) {
        this.connections = set;
    }

    public void setEdges(Set set) {
        this.edges = set;
    }

    public static class Connection
    implements Serializable {
        protected Object edge;
        protected Object port;
        protected boolean isSource;

        public Connection() {
        }

        public Connection(Object object, Object object2, boolean bl) {
            this.edge = object;
            this.port = object2;
            this.isSource = bl;
        }

        public Object getEdge() {
            return this.edge;
        }

        public Object getPort() {
            return this.port;
        }

        public boolean isSource() {
            return this.isSource;
        }

        public boolean equals(Object object) {
            if (object instanceof Connection) {
                Connection connection = (Connection)object;
                return connection.getEdge().equals(this.edge) && connection.isSource() == this.isSource;
            }
            return false;
        }

        public int hashCode() {
            return this.edge.hashCode();
        }

        public void setEdge(Object object) {
            this.edge = object;
        }

        public void setSource(boolean bl) {
            this.isSource = bl;
        }

        public void setPort(Object object) {
            this.port = object;
        }
    }
}

