/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class ConnectivityInspector<V, E>
implements GraphListener<V, E> {
    private static final String GRAPH_MUST_BE_DIRECTED_OR_UNDIRECTED = "Graph must be directed or undirected";
    private List<Set<V>> connectedSets;
    private Map<V, Set<V>> vertexToConnectedSet;
    private Graph<V, E> graph;

    public ConnectivityInspector(Graph<V, E> g) {
        this.init();
        if (g.getType().isDirected()) {
            this.graph = new AsUndirectedGraph<V, E>(g);
        } else if (g.getType().isUndirected()) {
            this.graph = g;
        } else {
            throw new IllegalArgumentException(GRAPH_MUST_BE_DIRECTED_OR_UNDIRECTED);
        }
    }

    public boolean isGraphConnected() {
        return this.lazyFindConnectedSets().size() == 1;
    }

    public Set<V> connectedSetOf(V vertex) {
        Set<V> connectedSet = this.vertexToConnectedSet.get(vertex);
        if (connectedSet == null) {
            connectedSet = new HashSet<V>();
            BreadthFirstIterator<V, E> i = new BreadthFirstIterator<V, E>(this.graph, vertex);
            while (i.hasNext()) {
                connectedSet.add(i.next());
            }
            this.vertexToConnectedSet.put((Set<V>)vertex, (Set<Set<V>>)connectedSet);
        }
        return connectedSet;
    }

    public List<Set<V>> connectedSets() {
        return this.lazyFindConnectedSets();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e2) {
        this.init();
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e2) {
        this.init();
    }

    public boolean pathExists(V sourceVertex, V targetVertex) {
        Set<V> sourceSet = this.connectedSetOf(sourceVertex);
        return sourceSet.contains(targetVertex);
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e2) {
        this.init();
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e2) {
        this.init();
    }

    private void init() {
        this.connectedSets = null;
        this.vertexToConnectedSet = new HashMap<V, Set<V>>();
    }

    private List<Set<V>> lazyFindConnectedSets() {
        if (this.connectedSets == null) {
            this.connectedSets = new ArrayList<Set<V>>();
            Set<V> vertexSet = this.graph.vertexSet();
            if (vertexSet.size() > 0) {
                BreadthFirstIterator<V, E> i = new BreadthFirstIterator<V, E>(this.graph);
                i.addTraversalListener(new MyTraversalListener());
                while (i.hasNext()) {
                    i.next();
                }
            }
        }
        return this.connectedSets;
    }

    private class MyTraversalListener
    extends TraversalListenerAdapter<V, E> {
        private Set<V> currentConnectedSet;

        private MyTraversalListener() {
        }

        @Override
        public void connectedComponentFinished(ConnectedComponentTraversalEvent e2) {
            ConnectivityInspector.this.connectedSets.add(this.currentConnectedSet);
        }

        @Override
        public void connectedComponentStarted(ConnectedComponentTraversalEvent e2) {
            this.currentConnectedSet = new HashSet();
        }

        @Override
        public void vertexTraversed(VertexTraversalEvent<V> e2) {
            Object v = e2.getVertex();
            this.currentConnectedSet.add(v);
            ConnectivityInspector.this.vertexToConnectedSet.put(v, this.currentConnectedSet);
        }
    }
}

