/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;

public class NaiveLcaFinder<V, E> {
    private Graph<V, E> graph;

    public NaiveLcaFinder(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    public V findLca(V a, V b) {
        return this.findLca(Collections.singleton(a), Collections.singleton(b), new LinkedHashSet(), new LinkedHashSet());
    }

    public Set<V> findLcas(V a, V b) {
        throw new UnsupportedOperationException("findLcas has not yet been implemented");
    }

    private V findLca(Set<V> aSet, Set<V> bSet, LinkedHashSet<V> aSeenSet, LinkedHashSet<V> bSeenSet) {
        if (aSet.size() == 0 && bSet.size() == 0) {
            return null;
        }
        if (!Collections.disjoint(aSet, bSeenSet)) {
            return this.overlappingMember(aSet, bSeenSet);
        }
        if (!Collections.disjoint(bSet, aSeenSet)) {
            return this.overlappingMember(bSet, aSeenSet);
        }
        if (!Collections.disjoint(aSet, bSet)) {
            return this.overlappingMember(aSet, bSet);
        }
        aSeenSet.addAll(aSet);
        bSeenSet.addAll(bSet);
        aSet = this.allParents(aSet);
        aSet.removeAll(aSeenSet);
        bSet = this.allParents(bSet);
        bSet.removeAll(bSeenSet);
        return this.findLca(aSet, bSet, aSeenSet, bSeenSet);
    }

    private Set<V> allParents(Set<V> vertexSet) {
        HashSet<V> result = new HashSet<V>();
        for (V e2 : vertexSet) {
            for (E edge : this.graph.incomingEdgesOf(e2)) {
                if (!this.graph.getEdgeTarget(edge).equals(e2)) continue;
                result.add(this.graph.getEdgeSource(edge));
            }
        }
        return result;
    }

    private V overlappingMember(Set<V> x, Set<V> y) {
        y.retainAll(x);
        return y.iterator().next();
    }
}

