/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.util.ModifiableInteger;

@Deprecated
public class NeighborIndex<V, E>
implements GraphListener<V, E> {
    private Map<V, Neighbors<V>> neighborMap = new HashMap<V, Neighbors<V>>();
    private Graph<V, E> graph;

    public NeighborIndex(Graph<V, E> g) {
        this.graph = g;
    }

    public Set<V> neighborsOf(V v) {
        return this.getNeighbors(v).getNeighbors();
    }

    public List<V> neighborListOf(V v) {
        return this.getNeighbors(v).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e2) {
        E edge = e2.getEdge();
        V source = this.graph.getEdgeSource(edge);
        V target = this.graph.getEdgeTarget(edge);
        if (this.neighborMap.containsKey(source)) {
            this.getNeighbors(source).addNeighbor(target);
        } else {
            this.getNeighbors(source);
        }
        if (this.neighborMap.containsKey(target)) {
            this.getNeighbors(target).addNeighbor(source);
        } else {
            this.getNeighbors(target);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e2) {
        V source = e2.getEdgeSource();
        V target = e2.getEdgeTarget();
        if (this.neighborMap.containsKey(source)) {
            this.neighborMap.get(source).removeNeighbor(target);
        }
        if (this.neighborMap.containsKey(target)) {
            this.neighborMap.get(target).removeNeighbor(source);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e2) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e2) {
        this.neighborMap.remove(e2.getVertex());
    }

    private Neighbors<V> getNeighbors(V v) {
        Neighbors<V> neighbors = this.neighborMap.get(v);
        if (neighbors == null) {
            neighbors = new Neighbors<V>(Graphs.neighborListOf(this.graph, v));
            this.neighborMap.put((Neighbors<V>)v, (Neighbors<Neighbors<V>>)neighbors);
        }
        return neighbors;
    }

    static class Neighbors<V> {
        private Map<V, ModifiableInteger> neighborCounts = new LinkedHashMap<V, ModifiableInteger>();
        private Set<V> neighborSet = Collections.unmodifiableSet(this.neighborCounts.keySet());

        public Neighbors(Collection<V> neighbors) {
            for (V neighbor : neighbors) {
                this.addNeighbor(neighbor);
            }
        }

        public void addNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                count = new ModifiableInteger(1);
                this.neighborCounts.put((ModifiableInteger)v, count);
            } else {
                count.increment();
            }
        }

        public void removeNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                throw new IllegalArgumentException("Attempting to remove a neighbor that wasn't present");
            }
            count.decrement();
            if (count.getValue() == 0) {
                this.neighborCounts.remove(v);
            }
        }

        public Set<V> getNeighbors() {
            return this.neighborSet;
        }

        public List<V> getNeighborList() {
            ArrayList<V> neighbors = new ArrayList<V>();
            for (Map.Entry<V, ModifiableInteger> entry : this.neighborCounts.entrySet()) {
                V v = entry.getKey();
                int count = entry.getValue().intValue();
                for (int i = 0; i < count; ++i) {
                    neighbors.add(v);
                }
            }
            return neighbors;
        }

        public String toString() {
            return this.neighborSet.toString();
        }
    }
}

