/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.cycle.DirectedSimpleCycles;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class JohnsonSimpleCycles<V, E>
implements DirectedSimpleCycles<V, E> {
    private Graph<V, E> graph;
    private List<List<V>> cycles = null;
    private V[] iToV = null;
    private Map<V, Integer> vToI = null;
    private Set<V> blocked = null;
    private Map<V, Set<V>> bSets = null;
    private ArrayDeque<V> stack = null;
    private List<Set<V>> SCCs = null;
    private int index = 0;
    private Map<V, Integer> vIndex = null;
    private Map<V, Integer> vLowlink = null;
    private ArrayDeque<V> path = null;
    private Set<V> pathSet = null;

    public JohnsonSimpleCycles() {
    }

    public JohnsonSimpleCycles(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    @Override
    public List<List<V>> findSimpleCycles() {
        Object[] minSCCGResult;
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState();
        int size = this.graph.vertexSet().size();
        for (int startIndex = 0; startIndex < size && (minSCCGResult = this.findMinSCSG(startIndex))[0] != null; ++startIndex) {
            startIndex = (Integer)minSCCGResult[1];
            Graph scg = (Graph)minSCCGResult[0];
            V startV = this.toV(startIndex);
            for (Object e2 : scg.outgoingEdgesOf(startV)) {
                V v = this.graph.getEdgeTarget(e2);
                this.blocked.remove(v);
                this.getBSet(v).clear();
            }
            this.findCyclesInSCG(startIndex, startIndex, scg);
        }
        List<List<V>> result = this.cycles;
        this.clearState();
        return result;
    }

    private Object[] findMinSCSG(int startIndex) {
        this.initMinSCGState();
        Object[] result = new Object[2];
        List<Set<V>> SCCs = this.findSCCS(startIndex);
        int minIndexFound = Integer.MAX_VALUE;
        Set<V> minSCC = null;
        for (Set<V> scc : SCCs) {
            for (V v : scc) {
                int t = this.toI(v);
                if (t >= minIndexFound) continue;
                minIndexFound = t;
                minSCC = scc;
            }
        }
        if (minSCC == null) {
            return result;
        }
        DefaultDirectedGraph resultGraph = new DefaultDirectedGraph(new ClassBasedEdgeFactory(DefaultEdge.class));
        for (Object v : minSCC) {
            resultGraph.addVertex(v);
        }
        for (Object v : minSCC) {
            for (V w : minSCC) {
                if (!this.graph.containsEdge(v, w)) continue;
                resultGraph.addEdge(v, w);
            }
        }
        result[0] = resultGraph;
        result[1] = minIndexFound;
        this.clearMinSCCState();
        return result;
    }

    private List<Set<V>> findSCCS(int startIndex) {
        for (V v : this.graph.vertexSet()) {
            int vI = this.toI(v);
            if (vI < startIndex || this.vIndex.containsKey(v)) continue;
            this.getSCCs(startIndex, vI);
        }
        List<Set<V>> result = this.SCCs;
        this.SCCs = null;
        return result;
    }

    private void getSCCs(int startIndex, int vertexIndex) {
        V vertex = this.toV(vertexIndex);
        this.vIndex.put((Integer)vertex, this.index);
        this.vLowlink.put((Integer)vertex, this.index);
        ++this.index;
        this.path.push(vertex);
        this.pathSet.add(vertex);
        Set<E> edges = this.graph.outgoingEdgesOf(vertex);
        for (E e2 : edges) {
            V successor = this.graph.getEdgeTarget(e2);
            int successorIndex = this.toI(successor);
            if (successorIndex < startIndex) continue;
            if (!this.vIndex.containsKey(successor)) {
                this.getSCCs(startIndex, successorIndex);
                this.vLowlink.put((Integer)vertex, Math.min(this.vLowlink.get(vertex), this.vLowlink.get(successor)));
                continue;
            }
            if (!this.pathSet.contains(successor)) continue;
            this.vLowlink.put((Integer)vertex, Math.min(this.vLowlink.get(vertex), this.vIndex.get(successor)));
        }
        if (this.vLowlink.get(vertex).equals(this.vIndex.get(vertex))) {
            V temp;
            HashSet<V> result = new HashSet<V>();
            do {
                temp = this.path.pop();
                this.pathSet.remove(temp);
                result.add(temp);
            } while (!vertex.equals(temp));
            if (result.size() == 1) {
                Object v = result.iterator().next();
                if (this.graph.containsEdge(vertex, v)) {
                    this.SCCs.add(result);
                }
            } else {
                this.SCCs.add(result);
            }
        }
    }

    private boolean findCyclesInSCG(int startIndex, int vertexIndex, Graph<V, E> scg) {
        boolean foundCycle = false;
        V vertex = this.toV(vertexIndex);
        this.stack.push(vertex);
        this.blocked.add(vertex);
        for (E e2 : scg.outgoingEdgesOf(vertex)) {
            V successor = scg.getEdgeTarget(e2);
            int successorIndex = this.toI(successor);
            if (successorIndex == startIndex) {
                ArrayList<V> cycle = new ArrayList<V>();
                cycle.addAll(this.stack);
                this.cycles.add(cycle);
                foundCycle = true;
                continue;
            }
            if (this.blocked.contains(successor)) continue;
            boolean gotCycle = this.findCyclesInSCG(startIndex, successorIndex, scg);
            foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            this.unblock(vertex);
        } else {
            for (E ew : scg.outgoingEdgesOf(vertex)) {
                V w = scg.getEdgeTarget(ew);
                Set<V> bSet = this.getBSet(w);
                bSet.add(vertex);
            }
        }
        this.stack.pop();
        return foundCycle;
    }

    private void unblock(V vertex) {
        this.blocked.remove(vertex);
        Set<V> bSet = this.getBSet(vertex);
        while (bSet.size() > 0) {
            V w = bSet.iterator().next();
            bSet.remove(w);
            if (!this.blocked.contains(w)) continue;
            this.unblock(w);
        }
    }

    private void initState() {
        this.cycles = new LinkedList<List<V>>();
        this.iToV = this.graph.vertexSet().toArray();
        this.vToI = new HashMap<V, Integer>();
        this.blocked = new HashSet<V>();
        this.bSets = new HashMap<V, Set<V>>();
        this.stack = new ArrayDeque();
        for (int i = 0; i < this.iToV.length; ++i) {
            this.vToI.put((Integer)this.iToV[i], i);
        }
    }

    private void clearState() {
        this.cycles = null;
        this.iToV = null;
        this.vToI = null;
        this.blocked = null;
        this.bSets = null;
        this.stack = null;
    }

    private void initMinSCGState() {
        this.index = 0;
        this.SCCs = new ArrayList<Set<V>>();
        this.vIndex = new HashMap<V, Integer>();
        this.vLowlink = new HashMap<V, Integer>();
        this.path = new ArrayDeque();
        this.pathSet = new HashSet<V>();
    }

    private void clearMinSCCState() {
        this.index = 0;
        this.SCCs = null;
        this.vIndex = null;
        this.vLowlink = null;
        this.path = null;
        this.pathSet = null;
    }

    private Integer toI(V vertex) {
        return this.vToI.get(vertex);
    }

    private V toV(Integer i) {
        return this.iToV[i];
    }

    private Set<V> getBSet(V v) {
        Set<V> result = this.bSets.get(v);
        if (result == null) {
            result = new HashSet<V>();
            this.bSets.put((Set<V>)v, (Set<Set<V>>)result);
        }
        return result;
    }
}

