/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.cycle.UndirectedCycleBase;

public class PatonCycleBase<V, E>
implements UndirectedCycleBase<V, E> {
    private Graph<V, E> graph;

    public PatonCycleBase() {
    }

    public PatonCycleBase(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph, "Graph must be undirected");
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph, "Graph must be undirected");
    }

    @Override
    public List<List<V>> findCycleBase() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        HashMap used = new HashMap();
        HashMap<V, Object> parent = new HashMap<V, Object>();
        ArrayDeque<V> stack = new ArrayDeque<V>();
        ArrayList<List<V>> cycles = new ArrayList<List<V>>();
        for (V root2 : this.graph.vertexSet()) {
            if (parent.containsKey(root2)) continue;
            used.clear();
            parent.put(root2, root2);
            used.put(root2, new HashSet());
            stack.push(root2);
            while (!stack.isEmpty()) {
                Object current = stack.pop();
                Set currentUsed = (Set)used.get(current);
                for (E e2 : this.graph.edgesOf(current)) {
                    Set neighbourUsed;
                    V neighbor = this.graph.getEdgeTarget(e2);
                    if (neighbor.equals(current)) {
                        neighbor = this.graph.getEdgeSource(e2);
                    }
                    if (!used.containsKey(neighbor)) {
                        parent.put(neighbor, current);
                        neighbourUsed = new HashSet();
                        neighbourUsed.add(current);
                        used.put(neighbor, neighbourUsed);
                        stack.push(neighbor);
                        continue;
                    }
                    if (neighbor.equals(current)) {
                        ArrayList cycle = new ArrayList();
                        cycle.add(current);
                        cycles.add(cycle);
                        continue;
                    }
                    if (currentUsed.contains(neighbor)) continue;
                    neighbourUsed = (Set)used.get(neighbor);
                    ArrayList<Object> cycle = new ArrayList<Object>();
                    cycle.add(neighbor);
                    cycle.add(current);
                    Object p = parent.get(current);
                    while (!neighbourUsed.contains(p)) {
                        cycle.add(p);
                        p = parent.get(p);
                    }
                    cycle.add(p);
                    cycles.add(cycle);
                    neighbourUsed.add(current);
                }
            }
        }
        return cycles;
    }
}

