/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.spanning;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.PriorityQueue;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;

public class PrimMinimumSpanningTree<V, E>
implements SpanningTreeAlgorithm<E> {
    private final Graph<V, E> g;

    public PrimMinimumSpanningTree(Graph<V, E> graph) {
        this.g = Objects.requireNonNull(graph, "Graph cannot be null");
    }

    @Override
    public SpanningTreeAlgorithm.SpanningTree<E> getSpanningTree() {
        HashSet minimumSpanningTreeEdgeSet = new HashSet(this.g.vertexSet().size());
        double spanningTreeWeight = 0.0;
        HashSet<V> unspanned = new HashSet<V>(this.g.vertexSet());
        while (!unspanned.isEmpty()) {
            Object next;
            Iterator ri = unspanned.iterator();
            Object root2 = ri.next();
            ri.remove();
            PriorityQueue<E> dangling = new PriorityQueue<E>(this.g.edgeSet().size(), (lop, rop) -> Double.valueOf(this.g.getEdgeWeight(lop)).compareTo(this.g.getEdgeWeight(rop)));
            dangling.addAll(this.g.edgesOf(root2));
            while ((next = dangling.poll()) != null) {
                V t;
                V s = this.g.getEdgeSource(next);
                V v = t = unspanned.contains(s) ? s : this.g.getEdgeTarget(next);
                if (!unspanned.contains(t)) continue;
                minimumSpanningTreeEdgeSet.add(next);
                spanningTreeWeight += this.g.getEdgeWeight(next);
                unspanned.remove(t);
                for (E e2 : this.g.edgesOf(t)) {
                    if (!unspanned.contains(this.g.getEdgeSource(e2).equals(t) ? this.g.getEdgeTarget(e2) : this.g.getEdgeSource(e2))) continue;
                    dangling.add(e2);
                }
            }
        }
        return new SpanningTreeAlgorithm.SpanningTreeImpl(minimumSpanningTreeEdgeSet, spanningTreeWeight);
    }
}

