/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedPseudograph;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.ExportException;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.GraphMLExporter;
import org.jgrapht.io.GraphMLImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.IntegerComponentNameProvider;
import org.jgrapht.io.VertexProvider;

public final class GraphMLDemo {
    private static final int SIZE = 6;
    private static Random generator = new Random(17L);

    private static GraphExporter<CustomVertex, DefaultWeightedEdge> createExporter() {
        GraphMLExporter<CustomVertex, DefaultWeightedEdge> exporter = new GraphMLExporter<CustomVertex, DefaultWeightedEdge>(v -> ((CustomVertex)v).id, null, new IntegerComponentNameProvider(), null);
        exporter.setExportEdgeWeights(true);
        exporter.registerAttribute("color", GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING);
        exporter.registerAttribute("name", GraphMLExporter.AttributeCategory.ALL, AttributeType.STRING);
        exporter.setVertexAttributeProvider(v -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            if (v.getColor() != null) {
                m.put("color", DefaultAttribute.createAttribute(v.getColor().toString()));
            }
            m.put("name", DefaultAttribute.createAttribute("node-" + ((CustomVertex)v).id));
            return m;
        });
        exporter.setEdgeAttributeProvider(e2 -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            m.put("name", DefaultAttribute.createAttribute(e2.toString()));
            return m;
        });
        return exporter;
    }

    private static GraphImporter<CustomVertex, DefaultWeightedEdge> createImporter() {
        VertexProvider<CustomVertex> vertexProvider = new VertexProvider<CustomVertex>(){

            @Override
            public CustomVertex buildVertex(String id, Map<String, Attribute> attributes) {
                CustomVertex cv = new CustomVertex(id);
                String color = attributes.get("color").getValue();
                if (color != null) {
                    switch (color) {
                        case "black": {
                            cv.setColor(Color.BLACK);
                            break;
                        }
                        case "white": {
                            cv.setColor(Color.WHITE);
                            break;
                        }
                    }
                }
                return cv;
            }
        };
        EdgeProvider<CustomVertex, DefaultWeightedEdge> edgeProvider = (from, to, label, attributes) -> new DefaultWeightedEdge();
        GraphMLImporter<CustomVertex, DefaultWeightedEdge> importer = new GraphMLImporter<CustomVertex, DefaultWeightedEdge>(vertexProvider, edgeProvider);
        return importer;
    }

    public static void main(String[] args) {
        DirectedWeightedPseudograph graph1 = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
        CompleteGraphGenerator<CustomVertex, DefaultWeightedEdge> completeGenerator = new CompleteGraphGenerator<CustomVertex, DefaultWeightedEdge>(6);
        VertexFactory<CustomVertex> vFactory = new VertexFactory<CustomVertex>(){
            private int id = 0;

            @Override
            public CustomVertex createVertex() {
                CustomVertex v = new CustomVertex(String.valueOf(this.id++));
                if (generator.nextBoolean()) {
                    v.setColor(Color.BLACK);
                } else {
                    v.setColor(Color.WHITE);
                }
                return v;
            }
        };
        System.out.println("-- Generating complete graph");
        completeGenerator.generateGraph((Graph<CustomVertex, DefaultWeightedEdge>)graph1, vFactory, (Map<String, CustomVertex>)null);
        for (DefaultWeightedEdge e2 : graph1.edgeSet()) {
            graph1.setEdgeWeight(e2, generator.nextInt(100));
        }
        try {
            System.out.println("-- Exporting graph as GraphML");
            GraphExporter<CustomVertex, DefaultWeightedEdge> exporter = GraphMLDemo.createExporter();
            StringWriter writer = new StringWriter();
            exporter.exportGraph(graph1, writer);
            String graph1AsGraphML = ((Object)writer).toString();
            System.out.println(graph1AsGraphML);
            System.out.println("-- Importing graph back from GraphML");
            DirectedWeightedPseudograph graph2 = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
            GraphImporter<CustomVertex, DefaultWeightedEdge> importer = GraphMLDemo.createImporter();
            importer.importGraph(graph2, new StringReader(graph1AsGraphML));
        }
        catch (ExportException | ImportException e3) {
            System.err.println("Error: " + e3.getMessage());
            System.exit(-1);
        }
    }

    static class CustomVertex {
        private String id;
        private Color color;

        public CustomVertex(String id) {
            this(id, null);
        }

        public CustomVertex(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomVertex other = (CustomVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.id);
            if (this.color != null) {
                sb.append(",").append((Object)this.color);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static enum Color {
        BLACK("black"),
        WHITE("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

