/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.net.MalformedURLException;
import java.net.URL;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public final class HelloJGraphT {
    private HelloJGraphT() {
    }

    public static void main(String[] args) {
        Graph<String, DefaultEdge> stringGraph = HelloJGraphT.createStringGraph();
        System.out.println(stringGraph.toString());
        Graph<URL, DefaultEdge> hrefGraph = HelloJGraphT.createHrefGraph();
        System.out.println(hrefGraph.toString());
    }

    private static Graph<URL, DefaultEdge> createHrefGraph() {
        DefaultDirectedGraph<URL, DefaultEdge> g = new DefaultDirectedGraph<URL, DefaultEdge>(DefaultEdge.class);
        try {
            URL amazon = new URL("http://www.amazon.com");
            URL yahoo = new URL("http://www.yahoo.com");
            URL ebay = new URL("http://www.ebay.com");
            g.addVertex(amazon);
            g.addVertex(yahoo);
            g.addVertex(ebay);
            g.addEdge(yahoo, amazon);
            g.addEdge(yahoo, ebay);
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        return g;
    }

    private static Graph<String, DefaultEdge> createStringGraph() {
        SimpleGraph<String, DefaultEdge> g = new SimpleGraph<String, DefaultEdge>(DefaultEdge.class);
        String v1 = "v1";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        g.addVertex(v1);
        g.addVertex(v2);
        g.addVertex(v3);
        g.addVertex(v4);
        g.addEdge(v1, v2);
        g.addEdge(v2, v3);
        g.addEdge(v3, v4);
        g.addEdge(v4, v1);
        return g;
    }
}

