/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.IOException;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.Pseudograph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public final class PerformanceDemo {
    public static void main(String[] args) {
        Object prev;
        long time = System.currentTimeMillis();
        PerformanceDemo.reportPerformanceFor("starting at", time);
        Pseudograph<Object, DefaultEdge> g = new Pseudograph<Object, DefaultEdge>(DefaultEdge.class);
        Object curr = prev = new Object();
        g.addVertex(prev);
        int numVertices = 10000;
        int numEdgesPerVertex = 200;
        int numElements = numVertices * (1 + numEdgesPerVertex);
        System.out.println("\nallocating graph with " + numElements + " elements (may take a few tens of seconds)...");
        for (int i = 0; i < numVertices; ++i) {
            curr = new Object();
            g.addVertex(curr);
            for (int j = 0; j < numEdgesPerVertex; ++j) {
                g.addEdge(prev, curr);
            }
            prev = curr;
        }
        PerformanceDemo.reportPerformanceFor("graph allocation", time);
        time = System.currentTimeMillis();
        CrossComponentIterator i = new BreadthFirstIterator(g);
        while (i.hasNext()) {
            i.next();
        }
        PerformanceDemo.reportPerformanceFor("breadth traversal", time);
        time = System.currentTimeMillis();
        i = new DepthFirstIterator(g);
        while (i.hasNext()) {
            i.next();
        }
        PerformanceDemo.reportPerformanceFor("depth traversal", time);
        System.out.println("\nPaused: graph is still in memory (to check mem consumption).");
        System.out.print("press enter to free memory and finish...");
        try {
            System.in.read();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        System.out.println("done.");
    }

    private static void reportPerformanceFor(String msg, long refTime) {
        double time = (double)(System.currentTimeMillis() - refTime) / 1000.0;
        double mem = (double)PerformanceDemo.usedMemory() / 1048576.0;
        mem = (double)Math.round(mem * 100.0) / 100.0;
        System.out.println(msg + " (" + time + " sec, " + mem + "MB)");
    }

    private static long usedMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }
}

