/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.VertexProvider;

@Deprecated
public class DIMACSImporter<V, E>
implements GraphImporter<V, E> {
    private VertexProvider<V> vertexProvider;
    private EdgeProvider<V, E> edgeProvider;
    private final double defaultWeight;

    public DIMACSImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, double defaultWeight) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
        this.defaultWeight = defaultWeight;
    }

    public DIMACSImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, 1.0);
    }

    public VertexProvider<V> getVertexProvider() {
        return this.vertexProvider;
    }

    public void setVertexProvider(VertexProvider<V> vertexProvider) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
    }

    public EdgeProvider<V, E> getEdgeProvider() {
        return this.edgeProvider;
    }

    public void setEdgeProvider(EdgeProvider<V, E> edgeProvider) {
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        BufferedReader in = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        int size = this.readNodeCount(in);
        HashMap<Integer, V> map = new HashMap<Integer, V>();
        for (int i = 0; i < size; ++i) {
            Integer id = i + 1;
            V vertex = this.vertexProvider.buildVertex(id.toString(), new HashMap<String, String>());
            map.put(id, vertex);
            graph.addVertex(vertex);
        }
        Object[] cols = this.skipComments(in);
        while (cols != null) {
            if (cols[0].equals("e") || cols[0].equals("a")) {
                Integer target;
                Integer source;
                if (cols.length < 3) {
                    throw new ImportException("Failed to parse edge:" + Arrays.toString(cols));
                }
                try {
                    source = Integer.parseInt(cols[1]);
                }
                catch (NumberFormatException e2) {
                    throw new ImportException("Failed to parse edge source node:" + e2.getMessage(), e2);
                }
                try {
                    target = Integer.parseInt((String)cols[2]);
                }
                catch (NumberFormatException e3) {
                    throw new ImportException("Failed to parse edge target node:" + e3.getMessage(), e3);
                }
                String label = "e_" + source + "_" + target;
                Object from = map.get(source);
                if (from == null) {
                    throw new ImportException("Node " + source + " does not exist");
                }
                Object to = map.get(target);
                if (to == null) {
                    throw new ImportException("Node " + target + " does not exist");
                }
                try {
                    E e4 = this.edgeProvider.buildEdge(from, to, label, new HashMap<String, String>());
                    graph.addEdge(from, to, e4);
                    if (graph instanceof WeightedGraph) {
                        double weight = this.defaultWeight;
                        if (cols.length > 3) {
                            weight = Double.parseDouble((String)cols[3]);
                        }
                        ((WeightedGraph)graph).setEdgeWeight(e4, weight);
                    }
                }
                catch (IllegalArgumentException e5) {
                    throw new ImportException("Failed to import DIMACS graph:" + e5.getMessage(), e5);
                }
            }
            cols = this.skipComments(in);
        }
    }

    private String[] split(String src) {
        if (src == null) {
            return null;
        }
        return src.split("\\s+");
    }

    private String[] skipComments(BufferedReader input) {
        String[] cols = null;
        try {
            cols = this.split(input.readLine());
            while (cols != null && (cols.length == 0 || cols[0].equals("c") || cols[0].startsWith("%"))) {
                cols = this.split(input.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cols;
    }

    private int readNodeCount(BufferedReader input) throws ImportException {
        String[] cols = this.skipComments(input);
        if (cols[0].equals("p")) {
            Integer nodes;
            if (cols.length < 3) {
                throw new ImportException("Failed to read number of vertices.");
            }
            try {
                nodes = Integer.parseInt(cols[2]);
            }
            catch (NumberFormatException e2) {
                throw new ImportException("Failed to read number of vertices.");
            }
            if (nodes < 0) {
                throw new ImportException("Negative number of vertices.");
            }
            return nodes;
        }
        throw new ImportException("Failed to read number of vertices.");
    }
}

