/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.GraphType;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;

public class AsSubgraph<V, E>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = -1471811754881775298L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    protected final Set<E> edgeSet = new LinkedHashSet();
    protected final Set<V> vertexSet = new LinkedHashSet<V>();
    protected final Graph<V, E> base;
    protected final GraphType baseType;
    protected final boolean isInduced;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;

    public AsSubgraph(Graph<V, E> base, Set<? extends V> vertexSubset, Set<? extends E> edgeSubset) {
        this.base = GraphTests.requireDirectedOrUndirected(base);
        this.baseType = base.getType();
        boolean bl = this.isInduced = edgeSubset == null;
        if (base instanceof ListenableGraph) {
            ((ListenableGraph)base).addGraphListener(new BaseGraphListener());
        }
        this.initialize(vertexSubset, edgeSubset);
    }

    public AsSubgraph(Graph<V, E> base, Set<? extends V> vertexSubset) {
        this(base, vertexSubset, null);
    }

    public AsSubgraph(Graph<V, E> base) {
        this(base, null, null);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.containsVertex(sourceVertex) && this.containsVertex(targetVertex)) {
            return this.base.getAllEdges(sourceVertex, targetVertex).stream().filter(e2 -> this.edgeSet.contains(e2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        Set<E> edges = this.getAllEdges(sourceVertex, targetVertex);
        if (edges == null) {
            return null;
        }
        return edges.stream().findAny().orElse(null);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.base.containsEdge(sourceVertex, targetVertex)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set<E> edges = this.base.getAllEdges(sourceVertex, targetVertex);
        for (E e2 : edges) {
            if (this.containsEdge(e2)) continue;
            this.edgeSet.add(e2);
            return e2;
        }
        return null;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        assert (this.base.getEdgeSource(e2) == sourceVertex);
        assert (this.base.getEdgeTarget(e2) == targetVertex);
        return this.edgeSet.add(e2);
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        return this.vertexSet.add(v);
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.edgeSet.contains(e2);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.vertexSet.contains(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.base.edgesOf(vertex).stream().filter(e2 -> this.edgeSet.contains(e2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Override
    public int degreeOf(V vertex) {
        this.assertVertexExist(vertex);
        if (this.baseType.isUndirected()) {
            int degree = 0;
            Iterator it = this.base.edgesOf(vertex).stream().filter(e2 -> this.edgeSet.contains(e2)).iterator();
            while (it.hasNext()) {
                Object e3 = it.next();
                ++degree;
                if (!this.getEdgeSource(e3).equals(this.getEdgeTarget(e3))) continue;
                ++degree;
            }
            return degree;
        }
        return this.inDegreeOf(vertex) + this.outDegreeOf(vertex);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.base.incomingEdgesOf(vertex).stream().filter(e2 -> this.edgeSet.contains(e2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Override
    public int inDegreeOf(V vertex) {
        if (this.baseType.isUndirected()) {
            return this.degreeOf(vertex);
        }
        return this.incomingEdgesOf(vertex).size();
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.base.outgoingEdgesOf(vertex).stream().filter(e2 -> this.edgeSet.contains(e2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Override
    public int outDegreeOf(V vertex) {
        if (this.baseType.isUndirected()) {
            return this.degreeOf(vertex);
        }
        return this.outgoingEdgesOf(vertex).size();
    }

    @Override
    public boolean removeEdge(E e2) {
        return this.edgeSet.remove(e2);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e2 = this.getEdge(sourceVertex, targetVertex);
        return (E)(this.edgeSet.remove(e2) ? e2 : null);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v) && this.base.containsVertex(v)) {
            this.removeAllEdges(this.edgesOf(v));
        }
        return this.vertexSet.remove(v);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e2) {
        return this.base.getEdgeSource(e2);
    }

    @Override
    public V getEdgeTarget(E e2) {
        return this.base.getEdgeTarget(e2);
    }

    @Override
    public GraphType getType() {
        return this.base.getType();
    }

    @Override
    public double getEdgeWeight(E e2) {
        return this.base.getEdgeWeight(e2);
    }

    @Override
    public void setEdgeWeight(E e2, double weight) {
        this.base.setEdgeWeight(e2, weight);
    }

    private void initialize(Set<? extends V> vertexFilter, Set<? extends E> edgeFilter) {
        if (vertexFilter == null && edgeFilter == null) {
            this.vertexSet.addAll(this.base.vertexSet());
            this.edgeSet.addAll(this.base.edgeSet());
            return;
        }
        if (vertexFilter == null) {
            this.vertexSet.addAll(this.base.vertexSet());
        } else if (vertexFilter.size() > this.base.vertexSet().size()) {
            this.base.vertexSet().stream().filter(v -> vertexFilter.contains(v)).forEach(v -> this.vertexSet.add(v));
        } else {
            vertexFilter.stream().filter(v -> v != null && this.base.containsVertex(v)).forEach(v -> this.vertexSet.add(v));
        }
        if (edgeFilter == null) {
            this.base.edgeSet().stream().filter(e2 -> this.vertexSet.contains(this.base.getEdgeSource(e2)) && this.vertexSet.contains(this.base.getEdgeTarget(e2))).forEach(e2 -> this.edgeSet.add(e2));
        } else if (edgeFilter.size() > this.base.edgeSet().size()) {
            this.base.edgeSet().stream().filter(e2 -> edgeFilter.contains(e2) && this.vertexSet.contains(this.base.getEdgeSource(e2)) && this.vertexSet.contains(this.base.getEdgeTarget(e2))).forEach(e2 -> this.edgeSet.add(e2));
        } else {
            edgeFilter.stream().filter(e2 -> e2 != null && this.base.containsEdge(e2) && this.vertexSet.contains(this.base.getEdgeSource(e2)) && this.vertexSet.contains(this.base.getEdgeTarget(e2))).forEach(e2 -> this.edgeSet.add(e2));
        }
    }

    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> e2) {
            if (AsSubgraph.this.isInduced) {
                Object edge = e2.getEdge();
                Object source = e2.getEdgeSource();
                Object target = e2.getEdgeTarget();
                if (AsSubgraph.this.containsVertex(source) && AsSubgraph.this.containsVertex(target)) {
                    AsSubgraph.this.addEdge(source, target, edge);
                }
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> e2) {
            Object edge = e2.getEdge();
            AsSubgraph.this.removeEdge(edge);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> e2) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> e2) {
            Object vertex = e2.getVertex();
            AsSubgraph.this.removeVertex(vertex);
        }
    }
}

