/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.GraphDelegator;

public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements WeightedGraph<V, E>,
Serializable {
    private static final long serialVersionUID = 6408608293216853184L;
    private final Map<E, Double> weightMap;

    public AsWeightedGraph(Graph<V, E> g, Map<E, Double> weightMap) {
        super(g);
        this.weightMap = Objects.requireNonNull(weightMap, "Weight map cannot be null");
    }

    @Override
    public void setEdgeWeight(E e2, double weight) {
        if (super.getType().isWeighted()) {
            super.setEdgeWeight(e2, weight);
        }
        this.weightMap.put(e2, weight);
    }

    @Override
    public double getEdgeWeight(E e2) {
        double weight = this.weightMap.containsKey(e2) ? this.weightMap.get(e2).doubleValue() : super.getEdgeWeight(e2);
        return weight;
    }

    @Override
    public GraphType getType() {
        return super.getType().asWeighted();
    }
}

