/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.util.WeightCombiner;

@Deprecated
public class GraphUnion<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = -740199233080172450L;
    private static final String READ_ONLY = "union of graphs is read-only";
    private G g1;
    private G g2;
    private WeightCombiner operator;

    public GraphUnion(G g1, G g2, WeightCombiner operator) {
        if (g1 == null) {
            throw new NullPointerException("g1 is null");
        }
        if (g2 == null) {
            throw new NullPointerException("g2 is null");
        }
        if (g1 == g2) {
            throw new IllegalArgumentException("g1 is equal to g2");
        }
        this.g1 = g1;
        this.g2 = g2;
        this.operator = operator;
    }

    public GraphUnion(G g1, G g2) {
        this(g1, g2, WeightCombiner.SUM);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        LinkedHashSet res = new LinkedHashSet();
        if (this.g1.containsVertex(sourceVertex) && this.g1.containsVertex(targetVertex)) {
            res.addAll(this.g1.getAllEdges(sourceVertex, targetVertex));
        }
        if (this.g2.containsVertex(sourceVertex) && this.g2.containsVertex(targetVertex)) {
            res.addAll(this.g2.getAllEdges(sourceVertex, targetVertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        E res = null;
        if (this.g1.containsVertex(sourceVertex) && this.g1.containsVertex(targetVertex)) {
            res = this.g1.getEdge(sourceVertex, targetVertex);
        }
        if (res == null && this.g2.containsVertex(sourceVertex) && this.g2.containsVertex(targetVertex)) {
            res = this.g2.getEdge(sourceVertex, targetVertex);
        }
        return res;
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean containsEdge(E e2) {
        return this.g1.containsEdge(e2) || this.g2.containsEdge(e2);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.g1.containsVertex(v) || this.g2.containsVertex(v);
    }

    @Override
    public Set<E> edgeSet() {
        LinkedHashSet res = new LinkedHashSet();
        res.addAll(this.g1.edgeSet());
        res.addAll(this.g2.edgeSet());
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        LinkedHashSet res = new LinkedHashSet();
        if (this.g1.containsVertex(vertex)) {
            res.addAll(this.g1.edgesOf(vertex));
        }
        if (this.g2.containsVertex(vertex)) {
            res.addAll(this.g2.edgesOf(vertex));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeEdge(E e2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Set<V> vertexSet() {
        HashSet res = new HashSet();
        res.addAll(this.g1.vertexSet());
        res.addAll(this.g2.vertexSet());
        return Collections.unmodifiableSet(res);
    }

    @Override
    public V getEdgeSource(E e2) {
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeSource(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeSource(e2);
        }
        return null;
    }

    @Override
    public V getEdgeTarget(E e2) {
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeTarget(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeTarget(e2);
        }
        return null;
    }

    @Override
    public double getEdgeWeight(E e2) {
        if (this.g1.containsEdge(e2) && this.g2.containsEdge(e2)) {
            return this.operator.combine(this.g1.getEdgeWeight(e2), this.g2.getEdgeWeight(e2));
        }
        if (this.g1.containsEdge(e2)) {
            return this.g1.getEdgeWeight(e2);
        }
        if (this.g2.containsEdge(e2)) {
            return this.g2.getEdgeWeight(e2);
        }
        throw new IllegalArgumentException("no such edge in the union");
    }

    @Override
    public GraphType getType() {
        GraphType type1 = this.g1.getType();
        GraphType type2 = this.g2.getType();
        GraphType t = DefaultGraphType.mixed();
        if (type1.isDirected() && type2.isDirected()) {
            t = t.asDirected();
        }
        if (type1.isUndirected() && type2.isUndirected()) {
            t = t.asUndirected();
        }
        return t.asWeighted().asUnmodifiable();
    }

    public G getG1() {
        return this.g1;
    }

    public G getG2() {
        return this.g2;
    }

    @Override
    public int degreeOf(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inDegreeOf(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int outDegreeOf(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEdgeWeight(E e2, double weight) {
        throw new UnsupportedOperationException(READ_ONLY);
    }
}

