/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.io.AbstractBaseExporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.DOTUtils;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.IntegerComponentNameProvider;

public class DOTExporter<V, E>
extends AbstractBaseExporter<V, E>
implements GraphExporter<V, E> {
    public static final String DEFAULT_GRAPH_ID = "G";
    private ComponentNameProvider<Graph<V, E>> graphIDProvider;
    private ComponentNameProvider<V> vertexLabelProvider;
    private ComponentNameProvider<E> edgeLabelProvider;
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;
    private Map<String, String> graphAttributes;

    public DOTExporter() {
        this(new IntegerComponentNameProvider(), null, null, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, vertexAttributeProvider, edgeAttributeProvider, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider, ComponentNameProvider<Graph<V, E>> graphIDProvider) {
        super(vertexIDProvider);
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
        this.graphIDProvider = graphIDProvider == null ? any -> DEFAULT_GRAPH_ID : graphIDProvider;
        this.graphAttributes = new LinkedHashMap<String, String>();
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        String connector;
        PrintWriter out = new PrintWriter(writer);
        String indent = "  ";
        String header = g instanceof AbstractBaseGraph && !((AbstractBaseGraph)g).isAllowingMultipleEdges() ? "strict " : "";
        String graphId = this.graphIDProvider.getName(g);
        if (graphId == null || graphId.trim().isEmpty()) {
            graphId = DEFAULT_GRAPH_ID;
        }
        if (!DOTUtils.isValidID(graphId)) {
            throw new RuntimeException("Generated graph ID '" + graphId + "' is not valid with respect to the .dot language");
        }
        if (g.getType().isDirected()) {
            header = header + "digraph";
            connector = " -> ";
        } else {
            header = header + "graph";
            connector = " -- ";
        }
        header = header + " " + graphId + " {";
        out.println(header);
        for (Map.Entry<String, String> attr : this.graphAttributes.entrySet()) {
            out.print(indent);
            out.print(attr.getKey());
            out.print('=');
            out.print(attr.getValue());
            out.println(";");
        }
        for (Map.Entry<String, String> v : g.vertexSet()) {
            out.print(indent + this.getVertexID(v));
            String labelName = null;
            if (this.vertexLabelProvider != null) {
                labelName = this.vertexLabelProvider.getName(v);
            }
            Map<String, Attribute> attributes = null;
            if (this.vertexAttributeProvider != null) {
                attributes = this.vertexAttributeProvider.getComponentAttributes(v);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        for (Map.Entry<String, String> e2 : g.edgeSet()) {
            String source = this.getVertexID(g.getEdgeSource(e2));
            String target = this.getVertexID(g.getEdgeTarget(e2));
            out.print(indent + source + connector + target);
            String labelName = null;
            if (this.edgeLabelProvider != null) {
                labelName = this.edgeLabelProvider.getName(e2);
            }
            Map<String, Attribute> attributes = null;
            if (this.edgeAttributeProvider != null) {
                attributes = this.edgeAttributeProvider.getComponentAttributes(e2);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        out.println("}");
        out.flush();
    }

    public void removeGraphAttribute(String key) {
        Objects.requireNonNull(key, "Graph attribute key cannot be null");
        this.graphAttributes.remove(key);
    }

    public void putGraphAttribute(String key, String value) {
        Objects.requireNonNull(key, "Graph attribute key cannot be null");
        Objects.requireNonNull(value, "Graph attribute value cannot be null");
        this.graphAttributes.put(key, value);
    }

    private void renderAttributes(PrintWriter out, String labelName, Map<String, Attribute> attributes) {
        Attribute labelAttribute;
        if (labelName == null && attributes == null) {
            return;
        }
        out.print(" [ ");
        if (labelName == null && (labelAttribute = attributes.get("label")) != null) {
            labelName = labelAttribute.getValue();
        }
        if (labelName != null) {
            out.print("label=\"" + labelName + "\" ");
        }
        if (attributes != null) {
            for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
                String name = entry.getKey();
                if (name.equals("label")) continue;
                out.print(name + "=\"" + entry.getValue().getValue() + "\" ");
            }
        }
        out.print("]");
    }

    private String getVertexID(V v) {
        String idCandidate = this.vertexIDProvider.getName(v);
        if (DOTUtils.isValidID(idCandidate)) {
            return idCandidate;
        }
        throw new RuntimeException("Generated id '" + idCandidate + "'for vertex '" + v + "' is not valid with respect to the .dot language");
    }
}

