/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.io;

import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.jgrapht.Graph;
import org.jgrapht.io.AbstractBaseImporter;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.ComponentUpdater;
import org.jgrapht.io.DOTBaseListener;
import org.jgrapht.io.DOTLexer;
import org.jgrapht.io.DOTParser;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

public class DOTImporter<V, E>
extends AbstractBaseImporter<V, E>
implements GraphImporter<V, E> {
    public static final String DEFAULT_GRAPH_ID_KEY = "ID";
    private static final CharSequenceTranslator UNESCAPE_ID = new AggregateTranslator(new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}));

    public DOTImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, null);
    }

    public DOTImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, ComponentUpdater<V> vertexUpdater) {
        this(vertexProvider, edgeProvider, vertexUpdater, null);
    }

    public DOTImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, ComponentUpdater<V> vertexUpdater, ComponentUpdater<Graph<V, E>> graphUpdater) {
        super(vertexProvider, edgeProvider, vertexUpdater != null ? vertexUpdater : (c, a) -> {}, graphUpdater != null ? graphUpdater : (c, a) -> {});
    }

    @Override
    public void importGraph(Graph<V, E> g, Reader in) throws ImportException {
        try {
            DOTLexer lexer = new DOTLexer(new UnbufferedCharStream(in));
            lexer.setTokenFactory(new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            lexer.addErrorListener(errorListener);
            DOTParser parser = new DOTParser(new UnbufferedTokenStream(lexer));
            parser.removeErrorListeners();
            parser.addErrorListener(errorListener);
            parser.setBuildParseTree(false);
            parser.addParseListener(new CreateGraphDOTListener(g));
            parser.graph();
        }
        catch (IllegalArgumentException | ParseCancellationException e2) {
            throw new ImportException("Failed to import DOT graph: " + e2.getMessage(), e2);
        }
    }

    private static String unescapeId(String input) {
        int QUOTE = 34;
        if (input.charAt(0) != '\"' || input.charAt(input.length() - 1) != '\"') {
            return input;
        }
        String noQuotes = input.subSequence(1, input.length() - 1).toString();
        String unescaped = UNESCAPE_ID.translate(noQuotes);
        return unescaped;
    }

    private static String unescapeHtmlString(String input) {
        if (input.charAt(0) != '<' || input.charAt(input.length() - 1) != '>') {
            return input;
        }
        String noQuotes = input.subSequence(1, input.length() - 1).toString();
        String unescaped = StringEscapeUtils.unescapeXml(noQuotes);
        return unescaped;
    }

    private class SubgraphScope {
        Map<String, Attribute> graphAttrs = new HashMap<String, Attribute>();
        Map<String, Attribute> nodeAttrs = new HashMap<String, Attribute>();
        Map<String, Attribute> edgeAttrs = new HashMap<String, Attribute>();
        List<V> vertices = null;

        public void addVertex(V v) {
            if (this.vertices == null) {
                this.vertices = new ArrayList();
            }
            this.vertices.add(v);
        }

        public void addVertices(List<V> v) {
            if (this.vertices == null) {
                this.vertices = new ArrayList();
            }
            this.vertices.addAll(v);
        }
    }

    private class State {
        LinkedList<State> children = new LinkedList();
        List<String> ids = null;
        Map<String, Attribute> attrs = null;
        List<V> vertices = null;
        SubgraphScope subgraph = null;

        public String getId() {
            if (this.ids.isEmpty()) {
                return "";
            }
            return this.ids.get(0);
        }

        public void addId(String id) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(id);
        }

        public void put(String key, Attribute value) {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Attribute>();
            }
            this.attrs.put(key, value);
        }

        public void putAll(Map<String, Attribute> attrs) {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Attribute>();
            }
            this.attrs.putAll(attrs);
        }

        public void addVertex(V v) {
            if (this.vertices == null) {
                this.vertices = new ArrayList();
            }
            this.vertices.add(v);
        }

        public List<V> getVertices() {
            if (this.vertices != null) {
                return this.vertices;
            }
            if (this.subgraph != null && this.subgraph.vertices != null) {
                return this.subgraph.vertices;
            }
            return Collections.emptyList();
        }
    }

    private class CreateGraphDOTListener
    extends DOTBaseListener {
        private Graph<V, E> graph;
        private Map<String, V> vertices;
        private Deque<SubgraphScope> subgraphScopes;
        private Deque<State> stack;

        public CreateGraphDOTListener(Graph<V, E> graph) {
            this.graph = graph;
            this.vertices = new HashMap();
            this.stack = new ArrayDeque<State>();
            this.subgraphScopes = new ArrayDeque<SubgraphScope>();
        }

        @Override
        public void enterGraph(DOTParser.GraphContext ctx) {
            this.stack.push(new State());
            this.subgraphScopes.push(new SubgraphScope());
        }

        @Override
        public void exitGraph(DOTParser.GraphContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            this.subgraphScopes.pop();
            this.stack.pop();
        }

        @Override
        public void enterGraphHeader(DOTParser.GraphHeaderContext ctx) {
        }

        @Override
        public void exitGraphHeader(DOTParser.GraphHeaderContext ctx) {
            if (ctx.DIGRAPH() != null && !this.graph.getType().isDirected()) {
                throw new IllegalArgumentException("Provided graph is not directed");
            }
            if (ctx.GRAPH() != null && !this.graph.getType().isUndirected()) {
                throw new IllegalArgumentException("Provided graph is not undirected");
            }
        }

        @Override
        public void enterGraphIdentifier(DOTParser.GraphIdentifierContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitGraphIdentifier(DOTParser.GraphIdentifierContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            State idPartial = s.children.peekFirst();
            if (idPartial != null) {
                try {
                    DOTImporter.this.graphUpdater.update(this.graph, Collections.singletonMap(DOTImporter.DEFAULT_GRAPH_ID_KEY, DefaultAttribute.createAttribute(idPartial.getId())));
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Graph update failed: " + e2.getMessage(), e2);
                }
            }
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterAttributeStatement(DOTParser.AttributeStatementContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitAttributeStatement(DOTParser.AttributeStatementContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            State child = s.children.peekFirst();
            if (child != null && child.attrs != null) {
                Map<String, Attribute> attrs = child.attrs;
                SubgraphScope scope = this.subgraphScopes.element();
                if (ctx.NODE() != null) {
                    scope.nodeAttrs.putAll(attrs);
                } else if (ctx.EDGE() != null) {
                    scope.edgeAttrs.putAll(attrs);
                } else if (ctx.GRAPH() != null) {
                    scope.graphAttrs.putAll(attrs);
                }
            }
        }

        @Override
        public void enterAttributesList(DOTParser.AttributesListContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitAttributesList(DOTParser.AttributesListContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            for (State child : s.children) {
                if (child.attrs == null) continue;
                s.putAll(child.attrs);
            }
            s.children.clear();
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterAList(DOTParser.AListContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitAList(DOTParser.AListContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            Iterator it = s.children.iterator();
            while (it.hasNext()) {
                State child = (State)it.next();
                if (child.ids != null && child.ids.size() == 1) {
                    s.put(child.ids.get(0), null);
                } else if (child.ids != null && child.ids.size() >= 2) {
                    s.put(child.ids.get(0), DefaultAttribute.createAttribute(child.ids.get(1)));
                }
                it.remove();
            }
            s.children.clear();
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterEdgeStatement(DOTParser.EdgeStatementContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitEdgeStatement(DOTParser.EdgeStatementContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            Map<String, Attribute> attrs = null;
            State last = s.children.peekLast();
            if (last != null && last.attrs != null) {
                attrs = last.attrs;
            }
            Iterator it = s.children.iterator();
            State prev = null;
            while (it.hasNext()) {
                State cur = (State)it.next();
                if (cur.attrs != null) break;
                if (prev != null) {
                    for (Object sourceVertex : prev.getVertices()) {
                        for (Object targetVertex : cur.getVertices()) {
                            HashMap<String, Attribute> edgeAttrs = new HashMap<String, Attribute>(this.subgraphScopes.element().edgeAttrs);
                            if (attrs != null) {
                                edgeAttrs.putAll(attrs);
                            }
                            try {
                                String edgeLabel = null;
                                if (edgeAttrs.containsKey("label")) {
                                    edgeLabel = ((Attribute)edgeAttrs.get("label")).toString();
                                }
                                Object e2 = DOTImporter.this.edgeProvider.buildEdge(sourceVertex, targetVertex, edgeLabel, edgeAttrs);
                                this.graph.addEdge(sourceVertex, targetVertex, e2);
                            }
                            catch (Exception e3) {
                                throw new IllegalArgumentException("Edge creation failed: " + e3.getMessage(), e3);
                            }
                        }
                    }
                }
                prev = cur;
            }
        }

        @Override
        public void enterIdentifierPairStatement(DOTParser.IdentifierPairStatementContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitIdentifierPairStatement(DOTParser.IdentifierPairStatementContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            State idPairChild = s.children.peekFirst();
            if (idPairChild == null) {
                return;
            }
            String key = idPairChild.ids.get(0);
            String value = idPairChild.ids.get(1);
            SubgraphScope scope = this.subgraphScopes.element();
            scope.graphAttrs.put(key, DefaultAttribute.createAttribute(value));
            if (this.subgraphScopes.size() == 1) {
                try {
                    DOTImporter.this.graphUpdater.update(this.graph, Collections.singletonMap(key, DefaultAttribute.createAttribute(value)));
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Graph update failed: " + e2.getMessage(), e2);
                }
            }
        }

        @Override
        public void enterNodeStatement(DOTParser.NodeStatementContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitNodeStatement(DOTParser.NodeStatementContext ctx) {
            Object v;
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            Iterator it = s.children.iterator();
            if (!it.hasNext()) {
                return;
            }
            State nodeIdPartialState = (State)it.next();
            String nodeId = nodeIdPartialState.getId();
            Map<String, Attribute> attrs = Collections.emptyMap();
            if (it.hasNext()) {
                attrs = ((State)it.next()).attrs;
            }
            if ((v = this.vertices.get(nodeId)) == null) {
                SubgraphScope scope = this.subgraphScopes.element();
                HashMap<String, Attribute> defaultAttrs = new HashMap<String, Attribute>(scope.nodeAttrs);
                defaultAttrs.putAll(attrs);
                try {
                    v = DOTImporter.this.vertexProvider.buildVertex(nodeId, defaultAttrs);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Vertex creation failed: " + e2.getMessage(), e2);
                }
                this.graph.addVertex(v);
                this.vertices.put(nodeId, v);
                scope.addVertex(v);
            } else {
                DOTImporter.this.vertexUpdater.update(v, attrs);
            }
            s.addVertex(v);
            s.children.clear();
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterNodeStatementNoAttributes(DOTParser.NodeStatementNoAttributesContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitNodeStatementNoAttributes(DOTParser.NodeStatementNoAttributesContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            Iterator it = s.children.iterator();
            if (!it.hasNext()) {
                return;
            }
            State nodeIdPartial = (State)it.next();
            String nodeId = nodeIdPartial.getId();
            Object v = this.vertices.get(nodeId);
            if (v == null) {
                SubgraphScope scope = this.subgraphScopes.element();
                HashMap<String, Attribute> defaultAttrs = new HashMap<String, Attribute>(scope.nodeAttrs);
                try {
                    v = DOTImporter.this.vertexProvider.buildVertex(nodeId, defaultAttrs);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Vertex creation failed: " + e2.getMessage(), e2);
                }
                this.graph.addVertex(v);
                this.vertices.put(nodeId, v);
                scope.addVertex(v);
            }
            s.addVertex(v);
            s.children.clear();
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterNodeIdentifier(DOTParser.NodeIdentifierContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitNodeIdentifier(DOTParser.NodeIdentifierContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            if (!s.children.isEmpty()) {
                s.addId(s.children.getFirst().getId());
                s.children.clear();
                if (!this.stack.isEmpty()) {
                    this.stack.element().children.addLast(s);
                }
            }
        }

        @Override
        public void enterSubgraphStatement(DOTParser.SubgraphStatementContext ctx) {
            Map<String, Attribute> defaultGraphAttrs = this.subgraphScopes.element().graphAttrs;
            Map<String, Attribute> defaultNodeAttrs = this.subgraphScopes.element().nodeAttrs;
            Map<String, Attribute> defaultEdgeAttrs = this.subgraphScopes.element().edgeAttrs;
            SubgraphScope newState = new SubgraphScope();
            newState.graphAttrs.putAll(defaultGraphAttrs);
            newState.nodeAttrs.putAll(defaultNodeAttrs);
            newState.edgeAttrs.putAll(defaultEdgeAttrs);
            this.subgraphScopes.push(newState);
            State s = new State();
            s.subgraph = newState;
            this.stack.push(s);
        }

        @Override
        public void exitSubgraphStatement(DOTParser.SubgraphStatementContext ctx) {
            if (this.stack.isEmpty() || this.subgraphScopes.isEmpty()) {
                return;
            }
            SubgraphScope scope = this.subgraphScopes.pop();
            State s = this.stack.pop();
            if (scope.vertices != null && this.subgraphScopes.size() > 1) {
                this.subgraphScopes.element().addVertices(scope.vertices);
            }
            s.children.clear();
            if (!this.stack.isEmpty()) {
                this.stack.element().children.addLast(s);
            }
        }

        @Override
        public void enterIdentifierPair(DOTParser.IdentifierPairContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitIdentifierPair(DOTParser.IdentifierPairContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            Iterator it = s.children.iterator();
            if (it.hasNext()) {
                s.addId(((State)it.next()).getId());
            }
            if (it.hasNext()) {
                s.addId(((State)it.next()).getId());
            }
            if (s.ids != null) {
                s.children.clear();
                if (!this.stack.isEmpty()) {
                    this.stack.element().children.addLast(s);
                }
            }
        }

        @Override
        public void enterIdentifier(DOTParser.IdentifierContext ctx) {
            this.stack.push(new State());
        }

        @Override
        public void exitIdentifier(DOTParser.IdentifierContext ctx) {
            if (this.stack.isEmpty()) {
                return;
            }
            State s = this.stack.pop();
            String id = null;
            if (ctx.Id() != null) {
                id = ctx.Id().toString();
            } else if (ctx.String() != null) {
                id = DOTImporter.unescapeId(ctx.String().toString());
            } else if (ctx.HtmlString() != null) {
                id = DOTImporter.unescapeHtmlString(ctx.HtmlString().toString());
            } else if (ctx.Numeral() != null) {
                id = ctx.Numeral().toString();
            }
            if (id != null) {
                s.addId(id);
                if (!this.stack.isEmpty()) {
                    this.stack.element().children.addLast(s);
                }
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

