/*
 * Decompiled with CFR 0.152.
 */
package org.semwebtech.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openllet.core.KnowledgeBase;
import openllet.jena.PelletInfGraph;
import openllet.jena.PelletReasonerFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.describe.DescribeHandler;
import org.apache.jena.sparql.core.describe.DescribeHandlerRegistry;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;
import org.semwebtech.util.ParseRDF;

public class JenaModelWrapper {
    private static final boolean DEBUG = true;
    private Vector<String> inputFiles = null;
    public long timer = 0L;
    String outputFile = null;
    String ruleFile = "<none>";
    private String filesDirectory = "";
    boolean asWebService = false;
    String modifiedDataFilename = null;
    String modifiedDataContents = null;
    ParseRDF.Reasoner reasoning;
    Model model;
    static String commentString = "#";
    static boolean classtree = false;
    static String from_regex = "\\sFROM\\s*<.*?>";
    static String not_commented_out_from_regex = "\\n[^#]*FROM\\s*";
    static String not_commented_out_from_named_regex = "\\n[^#]*FROM NAMED\\s*<.*?>";
    static String useemptyprefix_regex = "\\n[^#]* :";
    static String defineemptyprefix_regex = "(\\n|^)[^#\\n]*prefix \\s*:";
    static String usemonprefix_regex = "\\n[^#]* mon:";
    static String definemonprefix_regex = "(\\n|^)[^#\\n]*prefix \\s*mon\\s*:";
    static String from_mondial_regex = "(\\\\n|^)[^#\\\\n]*FROM\\s*<.*mondial.*>";
    static final String[] knownInputLanguages = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N3", "TURTLE"};
    static final String[] knownOutputLanguages = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N3-PLAIN", "N3-PP", "N3-TRIPLE", "N3", "TURTLE"};
    static final String[] allowedOutputFormatters = new String[]{"PLAIN", "XML", "RDF"};

    public JenaModelWrapper(Vector<String> inputfiles, ParseRDF.Reasoner reasoning, String ruleFile, String outputfile, boolean asWebService) {
        this.reasoning = reasoning;
        this.inputFiles = inputfiles;
        this.ruleFile = ruleFile;
        this.outputFile = outputfile;
        this.asWebService = asWebService;
        this.prepareModel();
    }

    public void setFilesDirectory(String filesdir) {
        this.filesDirectory = filesdir;
    }

    public void setModifiedN3File(String filename) {
        this.modifiedDataFilename = filename;
    }

    public void setModifiedN3Contents(String text) {
        this.modifiedDataContents = text;
    }

    private void prepareModel() {
        System.out.println("JMW: prepareModel with " + (this.inputFiles != null ? this.inputFiles.size() : 0) + " input files");
        this.model = ModelFactory.createDefaultModel();
        if (this.inputFiles != null && !this.inputFiles.isEmpty()) {
            int i = 0;
            while (i < this.inputFiles.size()) {
                String filename = this.inputFiles.get(i);
                if (this.modifiedDataFilename == null || !this.modifiedDataFilename.equals(filename.substring(filename.indexOf(58) + 1)) && !this.modifiedDataFilename.equals(filename)) {
                    if (this.asWebService && filename.contains("file:")) {
                        filename = "file:" + this.filesDirectory + filename.substring(filename.indexOf(58) + 1);
                    }
                    System.out.println("ModelWrapper.prepareModel: load file " + filename);
                    this.model.add(this.readFileIntoModel(filename));
                }
                ++i;
            }
        }
        if (this.modifiedDataContents != null && !"".equals(this.modifiedDataContents)) {
            System.out.println("ModelWrapper.prepareModel: load modified DataContents ");
            this.readStringIntoModel(this.modifiedDataFilename, this.modifiedDataContents);
        }
        System.out.println("reasoning: " + (Object)((Object)this.reasoning));
        if (this.reasoning != ParseRDF.Reasoner.NONE) {
            System.out.println("### Inference support");
            System.out.print("Building Model with inference support. ");
            if (this.reasoning == ParseRDF.Reasoner.JENA) {
                System.out.println("Using built-in reasoner.");
                Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
                InfModel infmodel = ModelFactory.createInfModel(reasoner, this.model);
                this.model = infmodel;
            } else if (this.reasoning == ParseRDF.Reasoner.PELLET) {
                this.addPelletToModel();
            } else if (this.reasoning == ParseRDF.Reasoner.BW || this.reasoning == ParseRDF.Reasoner.FW || this.reasoning == ParseRDF.Reasoner.BWFW) {
                InfModel infmodel = this.createRuleReasoner(this.ruleFile, this.reasoning, this.model);
                if (infmodel == null) {
                    System.out.println("Couldn't Build the model with internal rule engine support. Exit.");
                    System.out.println("Couldn't build model with rule engine support.");
                    System.exit(1);
                }
                this.model = infmodel;
            } else {
                this.model = null;
            }
        }
    }

    public void addPelletToModel() {
        System.out.println(" Using Pellet-Plugin.");
        this.reasoning = ParseRDF.Reasoner.PELLET;
        OntModel pelletmodel = ModelFactory.createOntologyModel(PelletReasonerFactory.THE_SPEC, this.model);
        pelletmodel.prepare();
        this.model = pelletmodel;
    }

    public InfModel createRuleReasoner(String rulesFileName, ParseRDF.Reasoner reasoning, Model model) {
        try {
            List<Rule> rules = Rule.rulesFromURL(rulesFileName);
            System.out.println("Rules loaded:");
            System.out.println("Rules loaded:");
            for (Rule a : rules) {
                System.out.println("Rule  : " + ((Object)a).toString());
                System.out.println("Rule  : " + ((Object)a).toString());
            }
            GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
            if (reasoning == ParseRDF.Reasoner.BW) {
                reasoner.setMode(GenericRuleReasoner.BACKWARD);
            } else if (reasoning == ParseRDF.Reasoner.FW) {
                reasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
            } else if (reasoning == ParseRDF.Reasoner.BWFW) {
                reasoner.setMode(GenericRuleReasoner.HYBRID);
            }
            InfModel infmodel = ModelFactory.createInfModel(reasoner, model);
            return infmodel;
        }
        catch (Exception e2) {
            System.out.println("... some error occured: " + e2.toString());
            System.out.println("Error building inference Model with rulereasoner: " + e2.toString());
            return null;
        }
    }

    public void outputModel(String outputLanguage) {
        if (this.outputFile.equals("STDOUT")) {
            this.model.write(System.out, outputLanguage);
        } else {
            try {
                FileWriter writer = new FileWriter(this.outputFile);
                System.out.println("Writing Model in " + outputLanguage + " ...\n");
                this.model.write(writer, outputLanguage);
            }
            catch (Exception e2) {
                System.out.println("Error writing model to " + this.outputFile + ":");
                System.out.println(e2.toString());
            }
        }
        System.out.println("Finished output of Model.");
    }

    public void printClassTree() {
        if (this.reasoning == ParseRDF.Reasoner.NONE) {
            System.out.println("No reasoner specified, using pellet as default for ClassTree ...");
            this.addPelletToModel();
        }
        System.out.println("\n------------- Class Tree ---------------");
        KnowledgeBase kb = ((PelletInfGraph)this.model.getGraph()).getKB();
        kb.realize();
        kb.printClassTree();
        System.out.println("----------------------------------------\n");
    }

    public void validateModel() {
        ValidityReport report;
        if (this.reasoning == ParseRDF.Reasoner.NONE) {
            System.out.println("No reasoner specified, using pellet as default for ClassTree ...");
            this.addPelletToModel();
        }
        if (!(report = ((InfModel)this.model).validate()).isValid()) {
            System.out.println("Model is not valid: ");
            Iterator<ValidityReport.Report> it = report.getReports();
            while (it.hasNext()) {
                ValidityReport.Report it_report = it.next();
                System.out.println(it_report.getDescription());
            }
        } else {
            System.out.println("Model is valid.");
        }
    }

    public static boolean checkInputLanguage(String givenLanguage) {
        return JenaModelWrapper.checkLanguage(givenLanguage, knownInputLanguages);
    }

    public static boolean checkOutputLanguage(String givenLanguage) {
        return JenaModelWrapper.checkLanguage(givenLanguage, knownOutputLanguages);
    }

    public static boolean checkOutputFormatter(String givenLanguage) {
        return JenaModelWrapper.checkLanguage(givenLanguage, allowedOutputFormatters);
    }

    private static boolean checkLanguage(String givenLanguage, String[] knownLanguages) {
        givenLanguage = givenLanguage.toUpperCase();
        boolean formatKnown = false;
        int i = 0;
        while (i < knownLanguages.length) {
            if (givenLanguage.equals(knownLanguages[i].toUpperCase())) {
                formatKnown = true;
            }
            ++i;
        }
        return formatKnown;
    }

    private Model readFileIntoModel(String inputFileName) {
        String language = null;
        if (inputFileName.equals("<none>")) {
            return this.model;
        }
        System.out.println("### Read Model from File");
        try {
            BufferedReader br;
            if (inputFileName.startsWith("file:")) {
                br = new BufferedReader(new FileReader(inputFileName.substring("file:".length())));
                language = JenaModelWrapper.guessLanguage(br);
                br.close();
            } else if (!inputFileName.startsWith("http")) {
                System.out.println("Protocol not supported. Cannot guess language.");
            } else {
                br = JenaModelWrapper.getHTTPReaderWithNegotiation(inputFileName);
                language = JenaModelWrapper.guessLanguage(br);
                br.close();
            }
            language = language.toUpperCase();
            if (!JenaModelWrapper.checkLanguage(language, knownInputLanguages)) {
                System.out.println("Unknown Input-Language " + language + ". Known are:\n" + ParseRDF.arrayToString(knownInputLanguages, " "));
                System.exit(1);
            }
            System.out.println("ModelWrapper.ReadFileIntoModel from File/URL " + inputFileName);
            if (inputFileName.startsWith("file:")) {
                this.model.read(inputFileName, language);
            } else if (inputFileName.startsWith("http")) {
                br = JenaModelWrapper.getHTTPReaderWithNegotiation(inputFileName);
                this.model.read(br, inputFileName, language);
            }
        }
        catch (Exception e2) {
            System.out.println("Error accessing file: " + inputFileName + "\n" + e2.toString());
            e2.printStackTrace();
            return null;
        }
        return this.model;
    }

    private static BufferedReader getHTTPReaderWithNegotiation(String inputFileName) {
        try {
            BufferedReader in = null;
            URL inputURL = new URL(inputFileName);
            HttpURLConnection con = (HttpURLConnection)inputURL.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Accept", "application/rdf+xml, text/rdf;q=0.6, text/n3;q=0.3, text/rdf+n3;q=0.3, application/rdf+n3;q=0.3");
            con.connect();
            in = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            return in;
        }
        catch (Exception e2) {
            System.out.println("Error accessing file: " + inputFileName + "\n" + e2.toString());
            e2.printStackTrace();
            return null;
        }
    }

    private Model readStringIntoModel(String filename, String inputString) {
        String language = "";
        if (inputString.equals("")) {
            return this.model;
        }
        System.out.println("### Read Model from String");
        System.out.println("Reading Model from String ...");
        try {
            BufferedReader br = new BufferedReader(new StringReader(inputString));
            language = JenaModelWrapper.guessLanguage(br);
            br.close();
            language = language.toUpperCase();
            if (!JenaModelWrapper.checkLanguage(language, knownInputLanguages)) {
                System.out.println("Unknown Input-Language " + language + ". Known are:\n" + ParseRDF.arrayToString(knownInputLanguages, " "));
                System.exit(1);
            }
            String urlbase = "";
            if (filename.startsWith("http:")) {
                urlbase = filename;
            }
            this.model.read(new ByteArrayInputStream(inputString.getBytes(StandardCharsets.UTF_8)), urlbase, language);
        }
        catch (Exception e2) {
            System.out.println("Error reading model from string.\n" + e2.toString() + "\n input was: " + inputString);
            e2.printStackTrace();
            return null;
        }
        return this.model;
    }

    public static String readFileIntoString(String filename) {
        StringBuffer s = new StringBuffer();
        try {
            String buffer;
            BufferedReader br;
            if (!filename.startsWith("http")) {
                FileReader fr = new FileReader(new File(filename));
                br = new BufferedReader(fr);
            } else {
                br = JenaModelWrapper.getHTTPReaderWithNegotiation(filename);
            }
            while ((buffer = br.readLine()) != null) {
                s.append(String.valueOf(buffer) + "\n");
            }
            br.close();
        }
        catch (Exception e2) {
            System.out.println("Error accessing file: " + filename + "\n" + e2.toString());
            e2.printStackTrace();
            return null;
        }
        return s.toString();
    }

    public Object executeSPARQLQuery(String querystring) {
        System.out.println("----------------------------------------");
        if (this.reasoning != ParseRDF.Reasoner.NONE || this.asWebService) {
            querystring = this.readInputFilesIntoModel(querystring);
        }
        Query qu = QueryFactory.create(querystring, Syntax.syntaxARQ);
        QueryExecution qexec = null;
        String regExpression = not_commented_out_from_regex;
        Pattern regexPattern = Pattern.compile(regExpression, 2);
        Matcher regexMatcher = regexPattern.matcher(querystring);
        Boolean queryContainsFROM = regexMatcher.find();
        if (!(this.model == null || this.model.isEmpty() && queryContainsFROM.booleanValue())) {
            System.out.println("creating qexec with model");
            qexec = QueryExecutionFactory.create(qu, this.model);
        } else {
            System.out.println("creating qexec without model");
            qexec = QueryExecutionFactory.create(qu);
        }
        if (qu.isAskType()) {
            System.out.println("### Executing ASK-query");
            System.out.println("JMW: Executing SPARQL-ASK-query \n" + querystring.replaceAll("\n\\s*\n", "\n"));
            try {
                if (qexec.execAsk()) {
                    System.out.println("Answer: True.");
                    this.timer = System.currentTimeMillis();
                    return "Answer: True.";
                }
                System.out.println("Answer: False.");
                this.timer = System.currentTimeMillis();
                return "Answer: False.";
            }
            catch (QueryException qe) {
                System.out.println("Error.");
                qe.printStackTrace();
            }
            finally {
                qexec.close();
            }
        } else if (qu.isConstructType()) {
            System.out.println("### Executing CONSTRUCT-query");
            System.out.println("JMW: Executing SPARQL-CONSTRUCT-query \n" + querystring.replaceAll("\n\\s*\n", "\n"));
            try {
                Model constrModel = qexec.execConstruct();
                this.timer = System.currentTimeMillis();
                Model model = constrModel;
                return model;
            }
            catch (QueryException qe) {
                System.out.println("Error: " + qe.toString());
                qe.printStackTrace();
            }
            finally {
                qexec.close();
            }
        } else if (qu.isDescribeType()) {
            try {
                ArrayList<RDFNode> alldescnodes = new ArrayList<RDFNode>();
                for (Node n : qu.getResultURIs()) {
                    String uri = n.toString();
                    if (!uri.endsWith("/")) {
                        uri = String.valueOf(uri) + "/";
                    }
                    Resource r = this.model.getResource(uri);
                    alldescnodes.add(r);
                }
                qu.getResultURIs().retainAll(new ArrayList());
                QueryExecution qexec2 = null;
                if (!qu.getResultVars().isEmpty()) {
                    Query qu2 = QueryFactory.create(qu.toString().replaceFirst("(?i)describe", "select"), Syntax.syntaxARQ);
                    qexec2 = QueryExecutionFactory.create(qu2, this.model);
                    ResultSet res = qexec2.execSelect();
                    ResultSetRewindable results = ResultSetFactory.copyResults(res);
                    long numResults = ResultSetFormatter.consume(results);
                    if (qu.getDatasetDescription() != null) {
                        System.out.println("#QuDataset: " + qu.getDatasetDescription().getDefaultGraphURIs());
                    }
                    System.out.println("#Results: " + numResults);
                    results.reset();
                    while (results.hasNext()) {
                        QuerySolution sol = results.nextSolution();
                        for (String var : results.getResultVars()) {
                            RDFNode n = sol.get(var);
                            if (!n.isURIResource() && !n.isAnon() || alldescnodes.contains(n)) continue;
                            alldescnodes.add(n);
                        }
                    }
                }
                Model describeModel = this.getDescribeModel(alldescnodes, qexec2);
                this.timer = System.currentTimeMillis();
                Model model = describeModel;
                return model;
            }
            catch (QueryException qe) {
                System.out.println("Error: " + qe.toString());
                qe.printStackTrace();
            }
            finally {
                qexec.close();
            }
        } else if (!"sparql query".equals(querystring) && !"".equals(querystring)) {
            System.out.println("### Executing SELECT-query");
            try {
                System.out.println("JMW: Executing SPARQL-query \n" + querystring.replaceAll("\n\\s*\n", "\n"));
                ResultSetRewindable copyOfResultSet = null;
                System.out.println(String.valueOf(this.getClass().getName()) + "." + new Exception().getStackTrace()[0].getMethodName() + " Line " + new Exception().getStackTrace()[0].getLineNumber() + ":\n" + "Op " + Algebra.compile(qu).toString());
                ResultSet results = qexec.execSelect();
                copyOfResultSet = ResultSetFactory.copyResults(results);
                long numResults = ResultSetFormatter.consume(copyOfResultSet);
                if (qu.getDatasetDescription() != null) {
                    System.out.println("#QuDataset: " + qu.getDatasetDescription().getDefaultGraphURIs());
                }
                System.out.println("#Results: " + numResults);
                this.timer = System.currentTimeMillis();
                copyOfResultSet.reset();
                return copyOfResultSet;
            }
            catch (Exception e2) {
                System.out.println("Query failure: " + e2.toString());
                e2.printStackTrace();
            }
        }
        return null;
    }

    public Model getDescribeModel(String uri) {
        Resource node = this.model.getResource(uri);
        System.out.println(node);
        ArrayList<RDFNode> nodes = new ArrayList<RDFNode>();
        nodes.add(node);
        return this.getDescribeModel(nodes, null);
    }

    private Model getDescribeModel(Collection<RDFNode> alldescnodes, QueryExecution qexec) {
        if (qexec == null) {
            Query q = QueryFactory.create("DESCRIBE <ISBN:1234>", Syntax.syntaxARQ);
            qexec = QueryExecutionFactory.create(q, this.model);
        }
        Model describeModel = ModelFactory.createDefaultModel();
        ArrayList<RDFNode> thisround = new ArrayList<RDFNode>(alldescnodes);
        this.collectDescribeUpwards(alldescnodes, thisround, describeModel);
        describeModel.add(this.fillDescribeModelDownwards(qexec, alldescnodes));
        return describeModel;
    }

    private void collectDescribeUpwards(Collection<RDFNode> alldescnodes, Collection<RDFNode> thisround, Model descmodel) {
        ArrayList<RDFNode> newones = new ArrayList<RDFNode>();
        for (RDFNode n : thisround) {
            StmtIterator stmts = this.model.listStatements(null, null, n);
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                Resource subj = stmt.getSubject();
                if (subj.isAnon() && !newones.contains(subj) && !alldescnodes.contains(subj)) {
                    newones.add(subj);
                    continue;
                }
                if (!subj.isResource()) continue;
                descmodel.add(stmt);
                System.out.println("add Resource upwards: " + subj);
            }
        }
        alldescnodes.addAll(newones);
        if (!newones.isEmpty()) {
            this.collectDescribeUpwards(alldescnodes, newones, descmodel);
        }
    }

    private Model fillDescribeModelDownwards(QueryExecution qexec, Collection<RDFNode> set) {
        Model d = GraphFactory.makeJenaDefaultModel();
        List<DescribeHandler> dhList = DescribeHandlerRegistry.get().newHandlerList();
        Context context = qexec.getContext();
        context.put(ARQConstants.sysCurrentDataset, qexec.getDataset());
        for (DescribeHandler dh : dhList) {
            dh.start(d, context);
        }
        for (RDFNode n : set) {
            if (!(n instanceof Resource)) continue;
            for (DescribeHandler dh : dhList) {
                dh.describe((Resource)n);
            }
        }
        for (DescribeHandler dh : dhList) {
            dh.finish();
        }
        return d;
    }

    private String readInputFilesIntoModel(String queryString) {
        if (queryString == null) {
            return null;
        }
        String regExpression = not_commented_out_from_named_regex;
        Pattern regexPattern = Pattern.compile(regExpression, 2);
        Matcher regexMatcher = regexPattern.matcher(queryString);
        if (regexMatcher.find()) {
            if (this.inputFiles != null && !this.inputFiles.isEmpty()) {
                System.out.println("WARNING: If you use FROM NAMED in the query, do not\n         add any other ontology files by use of the\n         -if command line switch. Rather, use the\n         FROM-clause in the query to load additional data.");
            }
            return queryString;
        }
        if (this.inputFiles == null) {
            this.inputFiles = new Vector();
        }
        queryString = JenaModelWrapper.normalize(queryString);
        regExpression = from_regex;
        regexPattern = Pattern.compile(regExpression, 2);
        regexMatcher = regexPattern.matcher(queryString);
        boolean found = false;
        while (regexMatcher.find()) {
            found = true;
            String filename = JenaModelWrapper.getFileName(regexMatcher);
            this.inputFiles.addElement(filename);
        }
        if (found) {
            queryString = regexMatcher.replaceAll("");
            this.prepareModel();
        }
        System.out.println("JenaModelWrapper.parsedQuery without FROMs: " + queryString);
        return queryString;
    }

    private String readInputFilesIntoModelNEW(String queryString) {
        if (queryString == null) {
            return null;
        }
        Query q1 = QueryFactory.create(queryString);
        if (!q1.hasDatasetDescription()) {
            return queryString;
        }
        DatasetDescription dsd = q1.getDatasetDescription();
        if (this.inputFiles == null) {
            this.inputFiles = new Vector();
        }
        boolean found = false;
        List<String> uristrings = dsd.getDefaultGraphURIs();
        Iterator<String> uris = uristrings.iterator();
        while (uris.hasNext()) {
            found = true;
            String tmp = uris.next();
            tmp = "file:" + tmp.substring(tmp.lastIndexOf("/") + 1);
            this.inputFiles.addElement(tmp);
        }
        int i = q1.getGraphURIs().size() - 1;
        while (i >= 0) {
            q1.getGraphURIs().remove(i);
            --i;
        }
        return q1.serialize();
    }

    public static String normalize(String queryString) {
        Query query2 = QueryFactory.create(queryString, Syntax.syntaxARQ);
        return query2.serialize();
    }

    public static String getFirstInputFile(String queryString) {
        String filename = null;
        String regExpression = from_regex;
        Pattern regexPattern = Pattern.compile(regExpression, 2);
        Matcher regexMatcher = regexPattern.matcher(JenaModelWrapper.normalize(queryString));
        if (regexMatcher.find()) {
            filename = JenaModelWrapper.getFileName(regexMatcher);
        }
        return filename;
    }

    private static String getFileName(Matcher regexMatcher) {
        String match = regexMatcher.group();
        System.out.println("### parseQuery: Found match: " + match);
        int startpos = match.indexOf("<");
        int endpos = match.lastIndexOf(">");
        String fileName = match.substring(startpos + 1, endpos);
        if (!(fileName.startsWith("file:") || fileName.startsWith("http:") || fileName.startsWith("https:"))) {
            fileName = "file:" + fileName;
        }
        return fileName;
    }

    public static String addMondialPrefix(String querystring) {
        boolean useemptyprefix = false;
        boolean usemonprefix = false;
        boolean defineemptyprefix = false;
        boolean definemonprefix = false;
        String regExpression = useemptyprefix_regex;
        Pattern regexPattern = Pattern.compile(regExpression, 2);
        Matcher regexMatcher = regexPattern.matcher(querystring);
        if (regexMatcher.find()) {
            useemptyprefix = true;
        }
        if ((regexMatcher = (regexPattern = Pattern.compile(regExpression = usemonprefix_regex, 2)).matcher(querystring)).find()) {
            usemonprefix = true;
        }
        if ((regexMatcher = (regexPattern = Pattern.compile(regExpression = defineemptyprefix_regex, 2)).matcher(querystring)).find()) {
            defineemptyprefix = true;
        }
        if ((regexMatcher = (regexPattern = Pattern.compile(regExpression = definemonprefix_regex, 2)).matcher(querystring)).find()) {
            definemonprefix = true;
        }
        if (usemonprefix && !definemonprefix) {
            querystring = "prefix mon: <http://www.semwebtech.org/mondial/10/meta#>\n" + querystring;
        }
        if (useemptyprefix && !defineemptyprefix) {
            querystring = "prefix : <http://www.semwebtech.org/mondial/10/meta#>\n" + querystring;
        }
        return querystring;
    }

    public static String guessLanguage(String modelString) {
        int offset = 0;
        String language = null;
        while (offset < modelString.length() && Character.isWhitespace(modelString.charAt(offset))) {
            ++offset;
        }
        if (offset >= modelString.length()) {
            return null;
        }
        if (modelString.startsWith("#")) {
            return null;
        }
        language = modelString.charAt(offset) == '<' && modelString.length() >= 4 ? (modelString.substring(offset + 1, offset + 4).toUpperCase().equals("!--") ? "RDF/XML" : (modelString.substring(offset + 1, offset + 5).toUpperCase().equals("?XML") ? "RDF/XML" : (modelString.substring(offset + 1, offset + 8).toUpperCase().equals("RDF:RDF") ? "RDF/XML" : (modelString.substring(offset + 1, offset + 9).toUpperCase().equals("!DOCTYPE") ? "RDF/XML" : "N3")))) : "N3";
        return language;
    }

    public static String guessLanguage(BufferedReader br) {
        try {
            String line = "";
            while ((line = br.readLine()) != null) {
                String language = JenaModelWrapper.guessLanguage(line);
                if (language == null) continue;
                System.out.println("Assuming Language: " + language);
                return language;
            }
        }
        catch (Exception e2) {
            System.out.println("Couldn't read from address");
        }
        return null;
    }
}

