/*
 * Decompiled with CFR 0.152.
 */
package org.semwebtech.util;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.semwebtech.util.JenaModelWrapper;
import org.semwebtech.util.jena.sparql.function.library.XPathMathFunctions;

public class ParseRDF {
    static final String defaultNS = "http://semwebtech.org/default-ont#";
    static String outputLanguage = "N3";
    static String inputFileDefault = "<none>";
    static String outputFile = "STDOUT";
    static String ruleFile = "<none>";
    static String queryFile = "test.sparql";
    static Reasoner reasoning = Reasoner.NONE;
    static Vector<String> inputFiles = new Vector();
    static String prettyPrint = "PLAIN";
    static String packageFormat = "JAR";
    public static Boolean federatedOptomizer = true;
    static String commentString = "#";
    static boolean classtree = false;

    public static void main(String[] args) {
        ParseRDF.init();
        System.out.println("### Processing CommandLine Arguments ");
        if (args.length == 0) {
            ParseRDF.printHelp();
            System.exit(1);
        }
        String modus = ParseRDF.processCLParameters(args);
        JenaModelWrapper model = new JenaModelWrapper(inputFiles, reasoning, ruleFile, outputFile, false);
        if (modus.equals("unknown")) {
            System.out.println("Use -t or -q to tell me what to do.");
            ParseRDF.printHelp();
        } else {
            System.out.println("### Modus :<" + modus + ">");
            if (modus.equals("t")) {
                System.out.println("### Translate Data File");
                model.outputModel(outputLanguage);
            } else if (modus.equals("q")) {
                String querystring = JenaModelWrapper.readFileIntoString(queryFile);
                Object result = model.executeSPARQLQuery(querystring);
                ParseRDF.printResult(result);
            } else if (modus.equals("ct")) {
                System.out.println("... print class tree:");
                model.printClassTree();
            } else if (modus.equals("v")) {
                model.validateModel();
            }
        }
        System.out.println("Finished.");
    }

    private static void init() {
        System.out.println("### Registering XPathMathFunctions");
        XPathMathFunctions.register();
    }

    private static String processCLParameters(String[] args) {
        String modus = "unknown";
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-h")) {
                    ParseRDF.printHelp();
                    System.exit(0);
                }
                if (args[i].equals("-if")) {
                    while (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                        inputFiles.addElement(ParseRDF.parseAddress(ParseRDF.getParameterValue(args, ++i)));
                    }
                } else if (args[i].equals("-of")) {
                    outputFile = ParseRDF.getParameterValue(args, ++i);
                } else if (!args[i].equals("-il")) {
                    if (args[i].equals("-ol")) {
                        if (!JenaModelWrapper.checkOutputLanguage(outputLanguage = ParseRDF.getParameterValue(args, ++i).toUpperCase())) {
                            System.out.println("Unknown Output-Language " + outputLanguage + ". Known are:\n" + ParseRDF.arrayToString(JenaModelWrapper.knownOutputLanguages, " "));
                        }
                    } else if (args[i].equals("-qf")) {
                        modus = "q";
                        queryFile = ParseRDF.getParameterValue(args, ++i);
                    } else if (args[i].equals("-rf")) {
                        ruleFile = ParseRDF.getParameterValue(args, ++i);
                    } else if (args[i].equals("-t")) {
                        modus = "t";
                    } else if (args[i].equals("-q")) {
                        modus = "q";
                    } else if (args[i].equals("-inf")) {
                        reasoning = Reasoner.JENA;
                    } else if (args[i].equals("-bw")) {
                        reasoning = Reasoner.BW;
                    } else if (args[i].equals("-fw")) {
                        reasoning = Reasoner.FW;
                    } else if (args[i].equals("-bwfw") || args[i].equals("-hybrid")) {
                        reasoning = Reasoner.BWFW;
                    } else if (args[i].equals("-pp")) {
                        if (!JenaModelWrapper.checkOutputFormatter(prettyPrint = ParseRDF.getParameterValue(args, ++i).toUpperCase())) {
                            System.out.println("Unknown Output Formatter " + prettyPrint + ". Known are:\n" + ParseRDF.arrayToString(JenaModelWrapper.allowedOutputFormatters, " "));
                        }
                    } else if (args[i].equals("-pellet")) {
                        reasoning = Reasoner.PELLET;
                    } else if (args[i].equals("-e")) {
                        modus = "ct";
                        classtree = true;
                    } else if (args[i].equals("-validate") || args[i].equals("-v")) {
                        modus = "v";
                    } else if (args[i].equals("-optimizeFederatedOff") || args[i].equals("-ofo")) {
                        federatedOptomizer = false;
                    } else {
                        System.out.println("Unknown commandline-switch '" + args[i] + "' .");
                        ParseRDF.printHelp();
                        System.exit(1);
                    }
                }
            } else {
                System.out.println("You didn't specify what to do with this parameter:\n" + args[i] + "\nIf it is a filename, you have to give one of: [-qf | -if | -of | -rf ] ");
                System.exit(1);
            }
            ++i;
        }
        return modus;
    }

    private static String getParameterValue(String[] args, int pos) {
        if (pos == args.length || args[pos].startsWith("-")) {
            System.out.println("Failure, no value provided with commandline parameter!");
            ParseRDF.printHelp();
            System.exit(1);
        }
        return args[pos];
    }

    private static void printResult(Object result) {
        if (result instanceof String) {
            System.out.println(result);
        } else if (result instanceof ResultSet || result instanceof ResultSetRewindable) {
            ResultSetRewindable copyOfResultSet = ResultSetFactory.copyResults((ResultSet)result);
            int numberOfResults = ResultSetFormatter.toList(copyOfResultSet).size();
            if (ParseRDF.formattedResultsOutput(copyOfResultSet)) {
                System.out.println("Successfully printed " + numberOfResults + " query results.");
            }
        } else if (result instanceof Model) {
            Model constrModel = (Model)result;
            if (outputFile == null || outputFile.equals("STDOUT")) {
                constrModel.write(System.out, outputLanguage);
                System.out.println("\n\nSuccessfully wrote constructed rdf-graph.");
            } else if (outputFile != null) {
                try {
                    FileWriter writer = new FileWriter(outputFile);
                    System.out.println("Writing constructed Model in " + outputLanguage + " ...\n");
                    constrModel.write(writer, outputLanguage);
                }
                catch (Exception e2) {
                    System.out.println("Error writing model to " + outputFile + ":");
                    System.out.println(e2.toString());
                }
            }
        }
    }

    private static boolean formattedResultsOutput(ResultSet results) {
        ResultSetRewindable copyOfResults = ResultSetFactory.copyResults(results);
        System.out.print("Query result as ");
        if (prettyPrint.toUpperCase().equals("PLAIN")) {
            System.out.println(" plain text:");
            ResultSetFormatter.out((OutputStream)System.out, copyOfResults);
        } else if (prettyPrint.toUpperCase().equals("RDF")) {
            System.out.println(" RDF data, Outputlanguage <" + outputLanguage + ">. ");
        } else if (prettyPrint.toUpperCase().equals("XML")) {
            System.out.println(" XML:");
            ResultSetFormatter.outputAsXML((OutputStream)System.out, copyOfResults);
        }
        return true;
    }

    public static String arrayToString(String[] stringarray, String delimiter) {
        String returnstring = "";
        int i = 0;
        while (i < stringarray.length - 1) {
            returnstring = String.valueOf(returnstring) + stringarray[i] + delimiter;
            ++i;
        }
        returnstring = String.valueOf(returnstring) + stringarray[stringarray.length - 1] + " ";
        return returnstring;
    }

    private static String parseAddress(String address) {
        if (address.contains(":")) {
            return address;
        }
        return "file:" + address;
    }

    public static Properties loadConfiguration() {
        Properties prop = new Properties();
        try {
            InputStream is = ParseRDF.class.getResourceAsStream("log4j.properties");
            prop.load(is);
            is.close();
        }
        catch (Exception e2) {
            System.out.println(e2.toString());
        }
        return prop;
    }

    private static void printHelp() {
        System.out.println("Usage: java -jar org.semwebtech.util.jar -command\n\nOperating Modes:\n-h   print this helpmessage\n-t   translate data\n-q   sparql-query\n-e   print the class tree (using pellet per default)\n-v   validate the given model (using pellet per default)\n-ofo turn off the optimizer for federated queries\n\nAdditional parameters:\n-if  inputfile(s) [" + inputFileDefault + "]\n" + "     Examples: /path/to/test.n3\n" + "               file:///path/to/test.n3\n" + "               http://example.com/test.n3\n" + "-of  outputfile [" + outputFile + "]\n" + "-qf  file containing the SPARQL-Query [" + queryFile + "]\n" + "     (if -qf is used -q can be ommitted)\n" + "-rf  file containing the rules for the ruleengine [" + ruleFile + "]\n" + "-ol  outputlanguage [" + outputLanguage + "]" + "  { " + ParseRDF.arrayToString(JenaModelWrapper.knownOutputLanguages, " | ") + "}\n" + "-inf turn on Jena's inference support (restricted OWL) \n " + "-pellet turn on Openllet/Pellet OWL inference  \n " + "-bw/-fw/-bwfw/-hybrid turn on backward/forward/bw+fw=hybrid rule reasoner \n" + "-pp  pretty print query results [" + prettyPrint + "]" + "  { " + ParseRDF.arrayToString(JenaModelWrapper.allowedOutputFormatters, " | ") + "}");
    }

    public static enum Reasoner {
        NONE,
        JENA,
        PELLET,
        BW,
        FW,
        BWFW;

    }
}

