/*
 * Decompiled with CFR 0.152.
 */
package org.semwebtech.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.semwebtech.util.JenaModelWrapper;
import org.semwebtech.util.ParseRDF;
import org.semwebtech.util.RDFServlet;

public class RDFFrontend {
    private static final boolean DEBUG = true;
    private static String optimizeselection = " />";
    private static boolean optimizeQuery = false;
    private static double htmlTimer = 0.0;
    public static long start = 0L;
    private static String previousn3id = null;
    private static boolean mondialIsHere;
    private static boolean usingmondial;
    private static JenaModelWrapper wrapper;
    private static String semWebURI;
    static String mondialURL;
    static String mondialDirPath;
    static String mondialFileURL;
    static Vector<String> mondialinputfiles;
    static JenaModelWrapper mondialwrapper;

    static {
        usingmondial = false;
        semWebURI = "http://www.semwebtech.org/mondial/10/";
        mondialURL = "http://www.dbis.informatik.uni-goettingen.de/Mondial/Mondial-RDF/";
        mondialinputfiles = null;
        mondialwrapper = null;
        mondialDirPath = RDFServlet.mondialrdfdir;
        mondialFileURL = "file:" + mondialDirPath;
        mondialIsHere = new File(mondialDirPath).exists();
        if (mondialIsHere) {
            mondialURL = mondialFileURL;
        }
        System.out.println("mondialishere: " + mondialIsHere + " " + mondialURL);
        mondialinputfiles = new Vector();
        mondialinputfiles.add(String.valueOf(mondialURL) + "mondial.n3");
        mondialinputfiles.add(String.valueOf(mondialURL) + "mondial-meta.n3");
        mondialinputfiles.add(String.valueOf(mondialURL) + "mondial-sameas.n3");
        mondialwrapper = new JenaModelWrapper(mondialinputfiles, ParseRDF.Reasoner.NONE, null, null, true);
        System.out.println("RDFF static: mondialwrapper initialized");
    }

    public static void getAllURIs(PrintWriter out, boolean html, String baseURI) {
        usingmondial = true;
        if (html) {
            String query2 = "SELECT DISTINCT ?S ?P ?O WHERE {?S <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?O.     Bind (?P as <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>) FILTER(!isBlank(?S)) }";
            ResultSet result = (ResultSet)mondialwrapper.executeSPARQLQuery(query2);
            StringBuffer htmlcontent = new StringBuffer(RDFServlet.createDocumentHeader("Mondial RDF data"));
            if (result != null) {
                htmlcontent.append(RDFFrontend.printResult(result, baseURI));
            } else {
                htmlcontent.append("This was not a valid query.");
            }
            htmlcontent.append(RDFServlet.createDocumentFooter());
            out.println(htmlcontent);
        } else {
            String query3 = "CONSTRUCT { ?S <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?O } WHERE {?S <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?O; FILTER(!isBlank(?S)).}";
            Model model = (Model)mondialwrapper.executeSPARQLQuery(query3);
            model.write(out, "RDF/XML");
        }
    }

    public static void sendmondialSPARQLQuery(String query2, PrintWriter out, boolean html, String baseURI) {
        wrapper = null;
        usingmondial = true;
        ResultSet resultSet = null;
        if (query2.toLowerCase().contains("from")) {
            int i = query2.toLowerCase().indexOf("where");
            query2 = String.valueOf(query2.substring(0, i - 1)) + "\nFROM <" + mondialURL + "mondial.n3>" + "\nFROM <" + mondialURL + "mondial-meta.n3>" + "\nFROM  <" + mondialURL + "mondial-sameas.n3>\n" + query2.substring(i);
            wrapper = new JenaModelWrapper(null, ParseRDF.Reasoner.NONE, null, null, true);
        } else {
            wrapper = mondialwrapper;
            System.out.println("RDFF:sendmondialquery: using Mondial");
        }
        Object answer = wrapper.executeSPARQLQuery(query2);
        if (answer instanceof ResultSet) {
            resultSet = (ResultSet)wrapper.executeSPARQLQuery(query2);
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(resultSet);
            if (html) {
                StringBuffer htmlcontent = new StringBuffer(RDFServlet.createDocumentHeader("Mondial RDF data"));
                htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                htmlcontent.append(RDFFrontend.printResult(resultSetRewindable, baseURI));
                htmlcontent.append(RDFServlet.createDocumentFooter());
                out.println(htmlcontent);
            } else {
                resultSetRewindable.reset();
                System.out.println(ResultSetFormatter.asXMLString(resultSetRewindable));
                resultSetRewindable.reset();
                out.println(ResultSetFormatter.asXMLString(resultSetRewindable));
            }
        } else if (answer instanceof Model) {
            if (html) {
                StringBuffer htmlcontent = new StringBuffer(RDFServlet.createDocumentHeader("Mondial RDF data"));
                htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((Model)answer).write(baos, "N3");
                    htmlcontent.append("<pre>");
                    String res = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                    res = res.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                    htmlcontent.append(res);
                    htmlcontent.append("</pre>");
                }
                catch (Exception e2) {
                    System.out.println("Error writing model");
                }
                htmlcontent.append(RDFServlet.createDocumentFooter());
                out.println(htmlcontent);
            } else {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((Model)answer).write(baos, "RDF/XML");
                    String res = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                    System.out.println(res);
                    out.println(res);
                }
                catch (Exception e3) {
                    System.out.println("Error writing model");
                }
            }
        }
    }

    public static void getRDFData(PrintWriter out, String uri, boolean html, String baseURI) {
        usingmondial = true;
        if (html) {
            ResultSetRewindable copyOfResultSet;
            String query2 = "";
            String query22 = "";
            String query3 = "";
            Object result = null;
            Object result2 = null;
            Object result3 = null;
            if (uri.contains("__")) {
                uri = uri.replace(String.valueOf(semWebURI) + "/", "");
                System.out.println("URI: " + uri);
                String[] uriArray = uri.split("__");
                String blankNodeType = uriArray[0].split("/")[uriArray[0].split("/").length - 1];
                if (uri.contains("PopulationCount")) {
                    String[] populationCountArray = uriArray[1].split("_");
                    if (populationCountArray.length == 4) {
                        query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :Country ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?province a :Province ." + "      ?province :name \"" + populationCountArray[2].replace("+", " ").replace("$", "/") + "\" ." + "      ?country :hasProvince ?province." + "      ?city a :" + populationCountArray[0] + " ." + "      ?city :name \"" + populationCountArray[3].replace("+", " ").replace("$", "/") + "\" ." + "      ?province :hasCity ?city." + "      ?S a :" + blankNodeType + "." + "      ?S :year " + uriArray[2] + "." + "      ?city :hadPopulation ?S." + "      ?S ?P ?O}";
                        query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :Country ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?province a :Province ." + "      ?province :name \"" + populationCountArray[2].replace("+", " ").replace("$", "/") + "\" ." + "      ?country :hasProvince ?province." + "      ?city a :" + populationCountArray[0] + " ." + "      ?city :name \"" + populationCountArray[3].replace("+", " ").replace("$", "/") + "\" ." + "      ?province :hasCity ?city." + "      ?O a :" + blankNodeType + "." + "      ?O :year " + uriArray[2] + "." + "      ?city :hadPopulation ?O." + "      ?S ?P ?O}";
                    } else if (populationCountArray.length == 3) {
                        query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :Country ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?province a :" + populationCountArray[0] + " ." + "      ?province :name \"" + populationCountArray[2].replace("+", " ").replace("$", "/") + "\" ." + "      ?country :hasProvince ?province." + "      ?S a :" + blankNodeType + "." + "      ?S :year " + uriArray[2] + "." + "      ?province :hadPopulation ?S." + "      ?S ?P ?O}";
                        query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :Country ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?province a :" + populationCountArray[0] + " ." + "      ?province :name \"" + populationCountArray[2].replace("+", " ").replace("$", "/") + "\" ." + "      ?country :hasProvince ?province." + "      ?O a :" + blankNodeType + "." + "      ?O :year " + uriArray[2] + "." + "      ?province :hadPopulation ?O." + "      ?S ?P ?O}";
                    } else {
                        query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :" + populationCountArray[0] + " ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?S a :" + blankNodeType + "." + "      ?S :year " + uriArray[2] + "." + "      ?country :hadPopulation ?S." + "      ?S ?P ?O}";
                        query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {" + "      ?country a :" + populationCountArray[0] + " ." + "      ?country :carCode \"" + populationCountArray[1] + "\" ." + "      ?O a :" + blankNodeType + "." + "      ?O :year " + uriArray[2] + "." + "      ?country :hadPopulation ?O." + "      ?S ?P ?O}";
                    }
                } else if (uri.contains("Membership")) {
                    String[] country = uriArray[1].split("_");
                    String[] organization = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?country a :" + country[0] + "." + "\t\t?country :carCode \"" + country[1] + "\" ." + "       ?S :ofMember ?country." + "\t\t?organization a :" + organization[0] + " ." + "\t\t?organization :abbrev \"" + organization[1] + "\" ." + "       ?S :inOrganization ?organization ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?country a :" + country[0] + "." + "\t\t?country :carCode \"" + country[1] + "\" ." + "       ?O :ofMember ?country." + "\t\t?organization a :" + organization[0] + " ." + "\t\t?organization :abbrev \"" + organization[1] + "\" ." + "       ?O :inOrganization ?organization ." + "       ?S ?P ?O}";
                } else if (uri.contains("Border")) {
                    String[] countryOne = uriArray[1].split("_");
                    String[] countryTwo = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?countryOne a :" + countryOne[0] + "." + "\t\t?countryOne :carCode \"" + countryOne[1] + "\" ." + "       ?S :isBorderOf ?countryOne." + "\t\t?countryTwo a :" + countryTwo[0] + " ." + "\t\t?countryTwo :carCode \"" + countryTwo[1] + "\" ." + "       ?S :isBorderOf ?countryTwo ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?countryOne a :" + countryOne[0] + "." + "\t\t?countryOne :carCode \"" + countryOne[1] + "\" ." + "       ?O :isBorderOf ?countryOne." + "\t\t?countryTwo a :" + countryTwo[0] + " ." + "\t\t?countryTwo :carCode \"" + countryTwo[1] + "\" ." + "       ?O :isBorderOf ?countryTwo ." + "       ?S ?P ?O}";
                } else if (uri.contains("Encompassed")) {
                    String[] encompassedBy = uriArray[1].split("_");
                    String[] encompassedArea = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?encompassedBy a :" + encompassedBy[0] + "." + "\t\t?encompassedBy :name \"" + encompassedBy[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?S :encompassedBy ?encompassedBy." + "\t\t?encompassedArea a :" + encompassedArea[0] + " ." + "\t\t?encompassedArea :carCode \"" + encompassedArea[1] + "\" ." + "       ?S :encompassedArea ?encompassedArea ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?encompassedBy a :" + encompassedBy[0] + "." + "\t\t?encompassedBy :name \"" + encompassedBy[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?O :encompassedBy ?encompassedBy." + "\t\t?encompassedArea a :" + encompassedArea[0] + " ." + "\t\t?encompassedArea :carCode \"" + encompassedArea[1] + "\" ." + "       ?O :encompassedArea ?encompassedArea ." + "       ?S ?P ?O}";
                } else if (uri.contains("EthnicProportion")) {
                    String[] onEthnicGroup = uriArray[1].split("_");
                    String[] ethnicInfoMinus = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?onEthnicGroup a :" + onEthnicGroup[0] + "." + "\t\t?onEthnicGroup :name \"" + onEthnicGroup[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?S :onEthnicGroup ?onEthnicGroup." + "\t\t?ethnicInfoMinus a :" + ethnicInfoMinus[0] + " ." + "\t\t?ethnicInfoMinus :carCode \"" + ethnicInfoMinus[1] + "\" ." + "       ?S :ethnicInfo- ?ethnicInfoMinus ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?onEthnicGroup a :" + onEthnicGroup[0] + "." + "\t\t?onEthnicGroup :name \"" + onEthnicGroup[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?O :onEthnicGroup ?onEthnicGroup." + "\t\t?ethnicInfoMinus a :" + ethnicInfoMinus[0] + " ." + "\t\t?ethnicInfoMinus :carCode \"" + ethnicInfoMinus[1] + "\" ." + "       ?O :ethnicInfo- ?ethnicInfoMinus ." + "       ?S ?P ?O}";
                } else if (uri.contains("BelievedBy")) {
                    String[] onReligion = uriArray[1].split("_");
                    String[] religionInfoMinus = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?onReligion a :" + onReligion[0] + "." + "\t\t?onReligion :name \"" + onReligion[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?S :onReligion ?onReligion." + "\t\t?religionInfoMinus a :" + religionInfoMinus[0] + " ." + "\t\t?religionInfoMinus :carCode \"" + religionInfoMinus[1] + "\" ." + "       ?S :religionInfo- ?religionInfoMinus ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?onReligion a :" + onReligion[0] + "." + "\t\t?onReligion :name \"" + onReligion[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?O :onReligion ?onReligion." + "\t\t?religionInfoMinus a :" + religionInfoMinus[0] + " ." + "\t\t?religionInfoMinus :carCode \"" + religionInfoMinus[1] + "\" ." + "       ?O :religionInfo- ?religionInfoMinus ." + "       ?S ?P ?O}";
                } else if (uri.contains("SpokenBy")) {
                    String[] onLanguage = uriArray[1].split("_");
                    String[] languageInfoMinus = uriArray[2].split("_");
                    query2 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?S a :" + blankNodeType + "." + "\t\t?onLanguage a :" + onLanguage[0] + "." + "\t\t?onLanguage :name \"" + onLanguage[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?S :onLanguage ?onLanguage." + "\t\t?languageInfoMinus a :" + languageInfoMinus[0] + " ." + "\t\t?languageInfoMinus :carCode \"" + languageInfoMinus[1] + "\" ." + "       ?S :languageInfo- ?languageInfoMinus ." + "       ?S ?P ?O}";
                    query22 = "PREFIX : <" + semWebURI + "meta#> \n" + "SELECT DISTINCT ?S ?P ?O " + "WHERE {?O a :" + blankNodeType + "." + "\t\t?onLanguage a :" + onLanguage[0] + "." + "\t\t?onLanguage :name \"" + onLanguage[1].replace("+", " ").replace("$", "/") + "\" ." + "       ?O :onLanguage ?onLanguage." + "\t\t?languageInfoMinus a :" + languageInfoMinus[0] + " ." + "\t\t?languageInfoMinus :carCode \"" + languageInfoMinus[1] + "\" ." + "       ?O :languageInfo- ?languageInfoMinus ." + "       ?S ?P ?O}";
                }
                result = mondialwrapper.executeSPARQLQuery(query2);
                result2 = mondialwrapper.executeSPARQLQuery(query22);
            } else {
                uri = "<" + uri + ">";
                System.out.println("URI: " + uri);
                System.out.println("URI contains #:" + uri.contains("#"));
                query2 = "SELECT DISTINCT ?S ?P ?O WHERE {" + uri + " ?P ?O. " + "?S ?P ?O FILTER( ?S = " + uri + ")" + "}";
                result = mondialwrapper.executeSPARQLQuery(query2);
                query22 = "SELECT DISTINCT ?S ?P ?O WHERE { ?S ?P " + uri + ", ?O FILTER(?O=" + uri + ")" + "}";
                result2 = mondialwrapper.executeSPARQLQuery(query22);
                if (uri.contains("meta#")) {
                    query3 = "SELECT DISTINCT ?S ?P ?O WHERE { ?S " + uri + " ?O. ?S ?P ?O FILTER( ?P = " + uri + ")}";
                    result3 = mondialwrapper.executeSPARQLQuery(query3);
                }
            }
            StringBuffer htmlcontent = new StringBuffer(RDFServlet.createDocumentHeader("Mondial RDF data"));
            if (result != null) {
                copyOfResultSet = ResultSetFactory.copyResults((ResultSet)result);
                int numberOfResults = ResultSetFormatter.toList(copyOfResultSet).size();
                copyOfResultSet.reset();
                if (numberOfResults > 0) {
                    if (!uri.contains("<")) {
                        htmlcontent.append("<h3>&lt;" + uri + "&gt; is subject in " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    } else {
                        htmlcontent.append("<h3>&lt;" + uri.substring(1, uri.length() - 1) + "&gt; is subject in " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    }
                    htmlcontent.append(RDFFrontend.createHTMLTriplesTable(copyOfResultSet, uri, baseURI));
                }
            } else {
                htmlcontent.append("Subjectquery was not valid.");
            }
            if (result2 != null) {
                copyOfResultSet = ResultSetFactory.copyResults((ResultSet)result2);
                int numberOfResults = ResultSetFormatter.toList(copyOfResultSet).size();
                copyOfResultSet.reset();
                if (numberOfResults > 0) {
                    if (!uri.contains("<")) {
                        htmlcontent.append("<h3>&lt;" + uri + "&gt; is object in " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    } else {
                        htmlcontent.append("<h3>&lt;" + uri.substring(1, uri.length() - 1) + "&gt; is object in " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    }
                    htmlcontent.append(RDFFrontend.createHTMLTriplesTable(copyOfResultSet, uri, baseURI));
                }
            } else if (!uri.contains("__")) {
                htmlcontent.append("Objectquery was not valid.");
            }
            if (result3 != null) {
                copyOfResultSet = ResultSetFactory.copyResults((ResultSet)result3);
                int numberOfResults = ResultSetFormatter.toList(copyOfResultSet).size();
                copyOfResultSet.reset();
                if (numberOfResults > 0) {
                    if (!uri.contains("<")) {
                        htmlcontent.append("<h3>&lt;" + uri + "&gt; is predicate " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    } else {
                        htmlcontent.append("<h3>&lt;" + uri.substring(1, uri.length() - 1) + "&gt; is predicate in " + numberOfResults + " entries.</h3>");
                        htmlcontent.append("URLs enclosed in &lt;...&gt; are true resource identifiers, while those in [...] are actually blank nodes that get fake URLs just for HTML browsing and for accessing this single URL via HTTP GET.");
                    }
                    htmlcontent.append(RDFFrontend.createHTMLTriplesTable(copyOfResultSet, uri, baseURI));
                }
            }
            htmlcontent.append(RDFServlet.createDocumentFooter());
            out.println(htmlcontent);
        } else if (uri.contains("__")) {
            System.out.println("Blank node URIs like " + uri + " are not used vs. RDF clients.");
        } else {
            Model descmodel = mondialwrapper.getDescribeModel(uri);
            descmodel.write(out, "RDF/XML");
        }
    }

    public static void sparqlquery(PrintWriter out, Boolean showN3, String n3id, String n3text, String queryid, String previousqueryid, String querytext, Boolean show, Boolean eval2, ParseRDF.Reasoner reasoning, String baseURI, Boolean optimizeQuery, long timerStart) {
        String sparqlquerystring = null;
        RDFFrontend.optimizeQuery = optimizeQuery;
        optimizeselection = optimizeQuery != false ? " checked=\"true\"/>" : "/>";
        System.out.println("RdfFrontend.sparqlquery - querytext: " + querytext);
        System.out.println("RdfFrontend.sparqlquery - previousqueryid: " + previousqueryid);
        System.out.println("RdfFrontend.sparqlquery - queryid: " + queryid);
        System.out.println("RdfFrontend.sparqlquery - n3id: " + n3id);
        System.out.println("RdfFrontend.sparqlquery - optimize:" + optimizeQuery);
        if (querytext != null && !"".equals(querytext)) {
            String regExpression = JenaModelWrapper.not_commented_out_from_regex;
            Pattern regexPattern = Pattern.compile(regExpression, 2);
            Matcher regexMatcher = regexPattern.matcher(querytext);
            if (!regexMatcher.find()) {
                usingmondial = true;
                wrapper = mondialwrapper;
            } else {
                usingmondial = false;
                wrapper = new JenaModelWrapper(null, reasoning, null, null, true);
                wrapper.setFilesDirectory(RDFServlet.examplesdir);
            }
        } else {
            usingmondial = false;
            wrapper = new JenaModelWrapper(null, reasoning, null, null, true);
            wrapper.setFilesDirectory(RDFServlet.examplesdir);
        }
        if (querytext != null && !querytext.equals("sparql query")) {
            sparqlquerystring = querytext;
        }
        if (!(!show.booleanValue() && !eval2.booleanValue() || queryid.equals("None") || queryid.equals(previousqueryid) && querytext != null)) {
            previousqueryid = queryid;
            System.out.println("RDFFrontend.sparqlquery: load query with id " + queryid);
            sparqlquerystring = JenaModelWrapper.readFileIntoString(String.valueOf(RDFServlet.examplesdir) + queryid);
        }
        if (!showN3.booleanValue()) {
            previousn3id = null;
        }
        if (showN3.booleanValue()) {
            if ((n3id == null || "None-null".equals(n3id)) && sparqlquerystring != null) {
                n3id = JenaModelWrapper.getFirstInputFile(sparqlquerystring);
                if (n3id != null && n3id.contains("file:")) {
                    n3id = n3id.substring(n3id.indexOf(58) + 1);
                }
                System.out.println("RDFFrontend.sparqlquery set n3id to " + n3id);
            }
            if (!(n3id == null || "None-null".equals(n3id) || n3id.equals(previousn3id) && n3text != null)) {
                previousn3id = n3id;
                System.out.println("RDFFrontend: read n3 file from " + n3id);
                String filename = n3id;
                if (!n3id.startsWith("http:")) {
                    filename = String.valueOf(RDFServlet.examplesdir) + filename;
                }
                System.out.println("RDFFrontend.loadsparqlquery: " + filename);
                n3text = JenaModelWrapper.readFileIntoString(filename);
                System.out.println("RDFFrontend.sparqlquery loaded n3text: " + n3id + "\n" + n3text);
            }
            if (n3id == null && (sparqlquerystring == null || "reset".equals(sparqlquerystring))) {
                n3text = "@prefix : <foo://bla/names#>. \n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix owl: <http://www.w3.org/2002/07/owl#> . \n:x a owl:Thing .";
                System.out.println("RDFFrontend.sparqlquery init basic n3pattern");
            }
        }
        if (n3id != null && !"None-null".equals(n3id)) {
            wrapper.setModifiedN3File(n3id);
        }
        wrapper.setModifiedN3Contents(n3text);
        String datachoicesmenu = null;
        if (showN3.booleanValue()) {
            datachoicesmenu = "<div align='left'>\nExample Inputs:\n<select name='n3exampleid'>\n<option value='None-" + n3id + "'>Select Example Input</option>";
            File f = new File(RDFServlet.examplesdir);
            String[] c = f.list();
            LinkedList<String> l = new LinkedList<String>();
            int i = 0;
            while (i < c.length) {
                if (c[i].endsWith(".n3") || c[i].endsWith(".rdf")) {
                    l.add(c[i]);
                }
                ++i;
            }
            Collections.sort(l);
            for (String st : l) {
                datachoicesmenu = String.valueOf(datachoicesmenu) + "\n<option value='" + st + "'";
                if (n3id != null && n3id.equals(st)) {
                    datachoicesmenu = String.valueOf(datachoicesmenu) + " selected='selected'";
                }
                datachoicesmenu = String.valueOf(datachoicesmenu) + ">" + st + "</option>";
            }
            datachoicesmenu = String.valueOf(datachoicesmenu) + "\n<input type='submit' name='action' value='Get Data Example'/></select>" + "<input type=\"submit\" name=\"action\" value=\"close data input field\"/>";
        }
        String n3part = null;
        String n3contents = "";
        if (n3text != null) {
            n3contents = n3text;
        }
        n3part = showN3 == false ? "<input type=\"submit\" name=\"action\" value=\"expand data input field\"/>" : String.valueOf(datachoicesmenu) + "<TABLE width=\"80%\" border=\"0\"> <TR>" + "<TD><textarea name=\"n3text\" rows=\"18\" cols=\"110\">" + n3contents + "</textarea></TD></TR></TABLE>";
        String sparqlchoicesmenu = "<input type='hidden' name='previousqueryid' value='" + previousqueryid + "'/>" + "<div align='left'>\nExample Queries:\n<select name='sparqlexampleid'>\n<option value='None'>Select Example Query</option>";
        File f = new File(RDFServlet.examplesdir);
        String[] c = f.list();
        LinkedList<String> l = new LinkedList<String>();
        if (c != null) {
            int i = 0;
            while (i < c.length) {
                if (c[i].endsWith(".sparql")) {
                    l.add(c[i]);
                }
                ++i;
            }
            Collections.sort(l);
            for (String st : l) {
                sparqlchoicesmenu = String.valueOf(sparqlchoicesmenu) + "\n<option value='" + st + "'";
                if (queryid != null && queryid.equals(st)) {
                    sparqlchoicesmenu = String.valueOf(sparqlchoicesmenu) + " selected='selected'";
                }
                sparqlchoicesmenu = String.valueOf(sparqlchoicesmenu) + ">" + st.replace(".sparql", "") + "</option>";
            }
            sparqlchoicesmenu = String.valueOf(sparqlchoicesmenu) + "\n&nbsp;&nbsp;<input type='submit' name='action' value='Get Query'/>" + "\n<input type='submit' name='action' value='Get Query and Data'/></select>";
        }
        if (sparqlquerystring != null) {
            Pattern p = null;
            Matcher m = null;
            p = Pattern.compile("prefix \\s*rdf:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" rdf:") && !m.find()) {
                sparqlquerystring = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n" + sparqlquerystring;
            }
            p = Pattern.compile("prefix \\s*rdfs:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" rdfs:") && !m.find()) {
                sparqlquerystring = "prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n" + sparqlquerystring;
            }
            p = Pattern.compile("prefix \\s*owl:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" owl:") && !m.find()) {
                sparqlquerystring = "prefix owl: <http://www.w3.org/2002/07/owl#>\n" + sparqlquerystring;
            }
            p = Pattern.compile("prefix \\s*xs:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" xs:") && !m.find()) {
                sparqlquerystring = "prefix xs: <http://www.w3.org/2001/XMLSchema#>\n" + sparqlquerystring;
            }
            p = Pattern.compile("prefix \\s*xsd:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" xsd:") && !m.find()) {
                sparqlquerystring = "prefix xsd: <http://www.w3.org/2001/XMLSchema#>\n" + sparqlquerystring;
            }
            p = Pattern.compile("prefix \\s*swrl:", 2);
            m = p.matcher(sparqlquerystring);
            if (sparqlquerystring.contains(" swrl:") && !m.find()) {
                sparqlquerystring = "prefix swrl: <http://www.w3.org/2003/11/swrl#>\n" + sparqlquerystring;
            }
        }
        StringBuffer htmlcontent = new StringBuffer(RDFServlet.createDocumentHeader("SPARQL Query"));
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        replacements.add(new String[]{RDFServlet.N3SelectionTag, n3part});
        replacements.add(new String[]{RDFServlet.ExampleSelectionTag, sparqlchoicesmenu});
        switch (reasoning) {
            case NONE: {
                replacements.add(new String[]{"checkedNone=\"true\"", "checked=\"checked\""});
                break;
            }
            case JENA: {
                replacements.add(new String[]{"checkedJena=\"true\"", "checked=\"checked\""});
                break;
            }
            case PELLET: {
                replacements.add(new String[]{"checkedPellet=\"true\"", "checked=\"checked\""});
                break;
            }
            case BW: {
                replacements.add(new String[]{"checkedBW=\"true\"", "checked=\"checked\""});
                break;
            }
            case FW: {
                replacements.add(new String[]{"checkedFW=\"true\"", "checked=\"checked\""});
                break;
            }
            case BWFW: {
                replacements.add(new String[]{"checkedHybrid=\"true\"", "checked=\"checked\""});
            }
        }
        replacements.add(new String[]{RDFServlet.ValuesSelectionTag, optimizeselection});
        if (show.booleanValue()) {
            replacements.add(new String[]{"sparql query", sparqlquerystring});
        } else if (sparqlquerystring == null || "reset".equals(sparqlquerystring)) {
            replacements.add(new String[]{"sparql query", ""});
        }
        htmlcontent.append(RDFServlet.createHtml(RDFServlet.sparqlformfilename, replacements));
        if (eval2.booleanValue()) {
            System.out.println("RDFFrontend.sparqlquery: Reasoner " + reasoning.toString());
            Object result = null;
            result = wrapper.executeSPARQLQuery(sparqlquerystring);
            if (result != null) {
                htmlTimer = (double)(RDFFrontend.wrapper.timer - timerStart) / 1000.0;
                htmlcontent.append(RDFFrontend.printResult(result, baseURI));
                htmlcontent.replace(htmlcontent.indexOf(RDFServlet.TimerTag), htmlcontent.indexOf(RDFServlet.TimerTag) + RDFServlet.TimerTag.length(), "" + htmlTimer);
            } else {
                htmlcontent.append("This was not a valid query.");
            }
        } else {
            htmlcontent.replace(htmlcontent.indexOf(RDFServlet.TimerTag), htmlcontent.indexOf(RDFServlet.TimerTag) + RDFServlet.TimerTag.length(), "0");
        }
        htmlcontent.append(RDFServlet.createDocumentFooter());
        out.println(htmlcontent);
    }

    public static String resolveBlankNode(Resource blankNode2, Resource identifyingNode) {
        String blankURI = "";
        String blankType = "";
        String blankYear = "";
        String blankHadPopulation_Inv = "";
        RDFNode blankOfMember = null;
        RDFNode blankInOrganization = null;
        RDFNode blankEncompassedArea = null;
        RDFNode blankEncompassedBy = null;
        RDFNode blankOnEthnicGroup = null;
        RDFNode blankEthnicInfoMinus = null;
        RDFNode blankReligionInfoMinus = null;
        RDFNode blankOnReligion = null;
        RDFNode blankLanguageInfoMinus = null;
        RDFNode blankOnLanguage = null;
        RDFNode blankIsBorderOfOne = null;
        RDFNode blankIsBorderOfTwo = null;
        boolean borderOneSet = false;
        StmtIterator iterator = blankNode2.listProperties();
        while (iterator.hasNext()) {
            Statement blankSolution = iterator.nextStatement();
            Property prop = blankSolution.getPredicate();
            RDFNode obj = blankSolution.getObject();
            if (prop.toString().contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                blankType = obj.toString();
                continue;
            }
            if (prop.toString().contains("ofMember")) {
                blankOfMember = obj;
                continue;
            }
            if (prop.toString().contains("inOrganization")) {
                blankInOrganization = obj;
                continue;
            }
            if (prop.toString().contains("year")) {
                blankYear = obj.toString();
                continue;
            }
            if (prop.toString().contains("encompassedArea")) {
                blankEncompassedArea = obj;
                continue;
            }
            if (prop.toString().contains("encompassedBy")) {
                blankEncompassedBy = obj;
                continue;
            }
            if (prop.toString().contains("onEthnicGroup")) {
                blankOnEthnicGroup = obj;
                continue;
            }
            if (prop.toString().contains("ethnicInfo")) {
                blankEthnicInfoMinus = obj;
                continue;
            }
            if (prop.toString().contains("religionInfo")) {
                blankReligionInfoMinus = obj;
                continue;
            }
            if (prop.toString().contains("onReligion")) {
                blankOnReligion = obj;
                continue;
            }
            if (prop.toString().contains("languageInfo")) {
                blankLanguageInfoMinus = obj;
                continue;
            }
            if (prop.toString().contains("onLanguage")) {
                blankOnLanguage = obj;
                continue;
            }
            if (!prop.toString().contains("isBorderOf")) continue;
            if (!borderOneSet) {
                borderOneSet = true;
                blankIsBorderOfOne = obj;
                continue;
            }
            blankIsBorderOfTwo = obj;
        }
        if (blankType.contains("Membership")) {
            String ofMemberType = RDFFrontend.getType(blankOfMember);
            String member = RDFFrontend.getKey(blankOfMember);
            String organizationType = RDFFrontend.getType(blankInOrganization);
            String organization = RDFFrontend.getKey(blankInOrganization);
            blankURI = String.valueOf(blankURI) + "Membership__" + ofMemberType + "_" + member + "__" + organizationType + "_" + organization;
        } else if (blankType.contains("PopulationCount")) {
            blankHadPopulation_Inv = identifyingNode.toString();
            String[] hadPopulation_invArray = blankHadPopulation_Inv.split("/");
            String hadPopulation_inv = "";
            String otherNodeType = RDFFrontend.getType(identifyingNode);
            if (hadPopulation_invArray.length == 11) {
                hadPopulation_inv = String.valueOf(otherNodeType) + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 5] + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 3] + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 1];
            } else if (hadPopulation_invArray.length == 9) {
                hadPopulation_inv = String.valueOf(otherNodeType) + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 3] + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 1];
            } else if (hadPopulation_invArray.length == 7) {
                hadPopulation_inv = String.valueOf(otherNodeType) + "_" + hadPopulation_invArray[hadPopulation_invArray.length - 1];
            }
            blankURI = String.valueOf(blankURI) + "PopulationCount__" + hadPopulation_inv + "__" + blankYear.substring(0, blankYear.indexOf("^"));
        } else if (blankType.contains("Encompassed")) {
            String encompassedAreaType = RDFFrontend.getType(blankEncompassedArea);
            String encompassedArea = RDFFrontend.getKey(blankEncompassedArea);
            String encompassedByType = RDFFrontend.getType(blankEncompassedBy);
            String encompassedBy = RDFFrontend.getKey(blankEncompassedBy);
            blankURI = String.valueOf(blankURI) + "Encompassed__" + encompassedByType + "_" + encompassedBy + "__" + encompassedAreaType + "_" + encompassedArea;
        } else if (blankType.contains("EthnicProportion")) {
            String onEthnicGroup = RDFFrontend.getKey(blankOnEthnicGroup);
            String onEthnicGroupType = RDFFrontend.getType(blankOnEthnicGroup);
            String ethnicInfoMinus = RDFFrontend.getKey(blankEthnicInfoMinus);
            String ethnicInfoMinusType = RDFFrontend.getType(blankEthnicInfoMinus);
            blankURI = String.valueOf(blankURI) + "EthnicProportion__" + onEthnicGroupType + "_" + onEthnicGroup + "__" + ethnicInfoMinusType + "_" + ethnicInfoMinus;
        } else if (blankType.contains("BelievedBy")) {
            String onReligion = RDFFrontend.getKey(blankOnReligion);
            String onReligionType = RDFFrontend.getType(blankOnReligion);
            String religionInfoMinus = RDFFrontend.getKey(blankReligionInfoMinus);
            String religionInfoMinusType = RDFFrontend.getType(blankReligionInfoMinus);
            blankURI = String.valueOf(blankURI) + "BelievedBy__" + onReligionType + "_" + onReligion + "__" + religionInfoMinusType + "_" + religionInfoMinus;
        } else if (blankType.contains("SpokenBy")) {
            String onLanguage = RDFFrontend.getKey(blankOnLanguage);
            String onLanguageType = RDFFrontend.getType(blankOnLanguage);
            String languageInfoMinus = RDFFrontend.getKey(blankLanguageInfoMinus);
            String languageInfoMinusType = RDFFrontend.getType(blankLanguageInfoMinus);
            blankURI = String.valueOf(blankURI) + "SpokenBy__" + onLanguageType + "_" + onLanguage + "__" + languageInfoMinusType + "_" + languageInfoMinus;
        } else if (blankType.contains("Border")) {
            String isBorderOfOne = RDFFrontend.getKey(blankIsBorderOfOne);
            String isBorderOfOneType = RDFFrontend.getType(blankIsBorderOfOne);
            String isBorderOfTwo = RDFFrontend.getKey(blankIsBorderOfTwo);
            String isBorderOfTwoType = RDFFrontend.getType(blankIsBorderOfTwo);
            blankURI = isBorderOfOne.compareTo(isBorderOfTwo) < 0 ? String.valueOf(blankURI) + "Border__" + isBorderOfOneType + "_" + isBorderOfOne + "__" + isBorderOfTwoType + "_" + isBorderOfTwo : String.valueOf(blankURI) + "Border__" + isBorderOfTwoType + "_" + isBorderOfTwo + "__" + isBorderOfOneType + "_" + isBorderOfOne;
        }
        if (blankURI.contains(" ")) {
            blankURI = blankURI.replace(" ", "+");
        }
        if (!"".equals(blankURI)) {
            return blankURI;
        }
        return null;
    }

    public static String getType(RDFNode node) {
        String type = "";
        StmtIterator iterator = RDFFrontend.mondialwrapper.model.listStatements(node.asResource(), (Property)null, (RDFNode)null);
        while (iterator.hasNext()) {
            Statement blankSolution = iterator.nextStatement();
            Property prop = blankSolution.getPredicate();
            RDFNode obj = blankSolution.getObject();
            if (!prop.toString().contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
            type = obj.toString();
            type = type.substring(type.indexOf(35) + 1, type.length());
        }
        return type;
    }

    public static String getKey(RDFNode node) {
        String type = "";
        StmtIterator iterator = RDFFrontend.mondialwrapper.model.listStatements(node.asResource(), (Property)null, (RDFNode)null);
        while (iterator.hasNext()) {
            Statement blankSolution = iterator.nextStatement();
            Property prop = blankSolution.getPredicate();
            RDFNode obj = blankSolution.getObject();
            if (prop.toString().contains("carCode")) {
                if (obj.toString().contains(" ")) {
                    return obj.toString().replace(" ", "+");
                }
                return obj.toString();
            }
            if (prop.toString().contains("abbrev")) {
                if (obj.toString().contains(" ")) {
                    return obj.toString().replace(" ", "+");
                }
                return obj.toString();
            }
            if (prop.toString().contains("iatacode")) {
                if (obj.toString().contains(" ")) {
                    return obj.toString().replace(" ", "+");
                }
                return obj.toString();
            }
            if (!prop.toString().contains("name")) continue;
            type = obj.asLiteral().getString().contains(" ") ? obj.toString().replace(" ", "+") : obj.toString();
        }
        return type;
    }

    public static String createHTMLTriplesTable(Object rslt, String uri, String baseURI) {
        ResultSetRewindable result = ResultSetFactory.copyResults((ResultSet)rslt);
        StringBuffer s = new StringBuffer();
        s.append("<table border=\"1\"><tr>");
        for (String var : result.getResultVars()) {
            s.append("<th>" + var + "</th>");
        }
        s.append("</tr>");
        if (!result.hasNext()) {
            System.out.println("leer");
        }
        while (result.hasNext()) {
            QuerySolution sol = result.nextSolution();
            List<String> varNames = result.getResultVars();
            if (varNames.size() != 3) continue;
            StringBuffer x = new StringBuffer();
            Boolean deadBlank = false;
            Resource subject = sol.get(varNames.get(0)).asResource();
            Resource predicate = sol.get(varNames.get(1)).asResource();
            RDFNode object = sol.get(varNames.get(2));
            x.append("<tr>");
            if (subject.isAnon() || object.isAnon()) {
                String blankURI = "";
                if (subject.isAnon()) {
                    if (!uri.contains("__") && !object.isLiteral()) {
                        blankURI = RDFFrontend.resolveBlankNode(subject, object.asResource());
                        if (blankURI == null) {
                            deadBlank = true;
                        }
                        x.append("<td>[<a href=\"" + baseURI + blankURI + "\">" + semWebURI + blankURI + "</a>]</td>");
                    } else {
                        x.append("<td>[<a href=\"" + baseURI + uri + "\">" + semWebURI + uri + "</a>]</td>");
                    }
                    x.append(RDFFrontend.createURICellEntry(predicate, baseURI));
                    if (object.isURIResource()) {
                        x.append(RDFFrontend.createURICellEntry(object, baseURI));
                    } else if (object.isLiteral()) {
                        x.append("<td>" + RDFFrontend.formatLiteral(object.asLiteral()) + "</td>");
                    }
                } else {
                    x.append(RDFFrontend.createURICellEntry(subject, baseURI));
                    x.append(RDFFrontend.createURICellEntry(predicate, baseURI));
                    blankURI = RDFFrontend.resolveBlankNode(object.asResource(), subject);
                    if (blankURI == null) {
                        deadBlank = true;
                    }
                    x.append("<td>[<a href=\"" + baseURI + blankURI + "\">" + semWebURI + blankURI + "</a>]</td>");
                }
            } else {
                x.append(RDFFrontend.createURICellEntry(subject, baseURI));
                x.append(RDFFrontend.createURICellEntry(predicate, baseURI));
                if (object.isURIResource()) {
                    x.append(RDFFrontend.createURICellEntry(object, baseURI));
                } else {
                    x.append("<td>");
                    if (object.isLiteral()) {
                        x.append(RDFFrontend.formatLiteral(object.asLiteral()));
                    } else {
                        x.append(object);
                    }
                    x.append("</td>");
                }
            }
            x.append("</tr>");
            if (deadBlank.booleanValue()) continue;
            s.append(x);
        }
        s.append("</table>");
        return s.toString();
    }

    public static String formatLiteral(Literal lit) {
        Object o = lit.getValue();
        if (o instanceof Integer) {
            return o.toString();
        }
        try {
            double fl = lit.getDouble();
            return "" + fl;
        }
        catch (Exception exc2) {
            String x = lit.toString();
            if (x.contains("^^")) {
                int pos = x.indexOf("^^");
                x = String.valueOf('\"') + x.substring(0, pos) + '\"' + "^^&lt;" + x.substring(pos + 2, x.length()) + "&gt;";
            }
            return x;
        }
    }

    public static String createURICellEntry(RDFNode node, String baseURI) {
        StringBuffer s = new StringBuffer();
        s.append("<td>&lt;");
        String link = node.toString();
        if (link.contains("http://www.wikidata.org/")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if (link.contains("http://www.w3.org/2002/07/owl#sameAs")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if (link.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if (link.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if (link.contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if (link.contains("http://www.w3.org/2001/XMLSchema#date")) {
            s.append("<a href=\"" + link + "\">" + link + "</a>&gt;</td>");
            return s.toString();
        }
        if ((link = link.replace(semWebURI, "")).contains("#")) {
            link = link.replace("#", "%23");
        }
        s.append("<a href=\"" + baseURI);
        s.append(link);
        s.append("\">");
        s.append(node);
        s.append("</a>");
        s.append("&gt;</td>");
        return s.toString();
    }

    public static String printResult(Object result, String baseURI) {
        boolean error = false;
        int resultcount = 0;
        String errMsg = null;
        StringBuffer s = new StringBuffer();
        if (result instanceof String) {
            s.append(result);
        } else if (result instanceof ResultSet) {
            ResultSetRewindable copyOfResultSet = ResultSetFactory.copyResults((ResultSet)result);
            copyOfResultSet.reset();
            int numberOfResults = ResultSetFormatter.toList(copyOfResultSet).size();
            s.append("<h3>Results:  " + numberOfResults + "</h3>");
            copyOfResultSet.reset();
            copyOfResultSet.reset();
            s.append("<table border=\"1\"><tr>");
            for (String var : copyOfResultSet.getResultVars()) {
                s.append("<th>" + var + "</th>");
            }
            s.append("</tr>");
            if (!copyOfResultSet.hasNext()) {
                System.out.println("leer");
            }
            HashMap<RDFNode, Integer> blanknodes = new HashMap<RDFNode, Integer>();
            int blanknodecount = 0;
            String height = "";
            while (copyOfResultSet.hasNext()) {
                QuerySolution sol = copyOfResultSet.nextSolution();
                s.append("<tr>");
                height = !sol.varNames().hasNext() ? " height='16'" : "";
                for (String var : copyOfResultSet.getResultVars()) {
                    s.append("<td" + height + ">");
                    RDFNode n = sol.get(var);
                    if (n != null) {
                        if (n.isLiteral()) {
                            s.append(RDFFrontend.formatLiteral(n.asLiteral()));
                        } else if (n.isURIResource()) {
                            s.append("&lt;");
                            String link = n.toString();
                            link = link.replace(semWebURI, baseURI);
                            if (link.contains("#")) {
                                link = link.replace("#", "%23");
                            }
                            s.append("<a href=\"");
                            s.append(link);
                            s.append("\">");
                            s.append(n);
                            s.append("</a>");
                            s.append("&gt;");
                        } else if (n.isAnon()) {
                            if (usingmondial) {
                                StmtIterator iterator = RDFFrontend.wrapper.model.listStatements(null, null, n.asResource());
                                if (iterator.hasNext()) {
                                    while (iterator.hasNext()) {
                                        Statement statement = iterator.nextStatement();
                                        String uri = RDFFrontend.resolveBlankNode(n.asResource(), statement.getSubject().asResource());
                                        s.append("[<a href=\"" + baseURI + uri + "\">" + semWebURI + uri + "</a>]");
                                    }
                                } else {
                                    String uri = RDFFrontend.resolveBlankNode(n.asResource(), null);
                                    s.append("[<a href=\"" + baseURI + uri + "\">" + semWebURI + uri + "</a>]");
                                }
                            } else if (blanknodes.get(n) != null) {
                                s.append("_:b" + ((Integer)blanknodes.get(n)).toString());
                            } else {
                                blanknodes.put(n, new Integer(blanknodecount));
                                s.append("_:b" + blanknodecount++);
                            }
                        }
                    }
                    s.append("</td>");
                }
                s.append("</tr>");
            }
            s.append("</table>");
        } else if (result instanceof Model) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((Model)result).write(baos, "N3");
                s.append("<pre>");
                String res = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                res = res.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                s.append(res);
                s.append("</pre>");
            }
            catch (Exception e2) {
                System.out.println("Error writing model");
            }
        } else {
            s.append("no output routine for result type ...");
        }
        if (error) {
            s.append("<br/><br/>");
            s.append("<font color=\"red\">A database error occured: " + errMsg + "</font>");
            s.append("<br/><br/>");
        }
        String s2 = s.toString();
        s2 = s2.replace("$results-QQQ", Integer.toString(resultcount));
        return s2;
    }

    public static boolean getOptimize() {
        return optimizeQuery;
    }

    public static void setOptimizeQuery(Boolean optimizeQuery) {
        RDFFrontend.optimizeQuery = optimizeQuery;
    }

    public static Boolean getOptimizeQuery() {
        return optimizeQuery;
    }
}

