/*
 * Decompiled with CFR 0.152.
 */
package org.semwebtech.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.semwebtech.util.JenaModelWrapper;
import org.semwebtech.util.ParseRDF;
import org.semwebtech.util.RDFFrontend;
import org.semwebtech.util.jena.sparql.function.library.XPathMathFunctions;

public class RDFServlet
extends HttpServlet {
    private static final boolean DEBUG = true;
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String HTMLHEADER = "text/html";
    private static final String RDFXMLHEADER = "application/rdf+xml";
    private static final String SPARQLHEADER = "application/sparql-results+xml";
    private static String indexhtmlfile = "index.html";
    private static String indexhtmlfilename;
    private static String startpagelocalpath;
    private static String sparqlformfile;
    public static String sparqlformfilename;
    public static String examplesdir;
    public static String mondialrdfdir;
    public static String myURL;
    public static String localURL;
    public static String globalURL;
    public static String N3SelectionTag;
    public static String ExampleSelectionTag;
    public static String ReasonerSelectionTag;
    public static String ValuesSelectionTag;
    public static String TimerTag;
    public static String MessageTag;
    public static String semWebURI;
    private static final long serialVersionUID = 1L;

    static {
        startpagelocalpath = "/home/may/mondial-lod.html";
        sparqlformfile = "sparqlformbody.html";
        N3SelectionTag = "<-- AutoReplace with N3 handling -->";
        ExampleSelectionTag = "<-- AutoReplace with Example Table -->";
        ReasonerSelectionTag = "/> <-- AutoReplace with ReasonerChoice -->";
        ValuesSelectionTag = "/> <-- AutoReplace with ValuesChoice -->";
        TimerTag = "<-- AutoReplace with Timer -->";
        MessageTag = "<-- AutoReplace with Message -->";
        semWebURI = "http://www.semwebtech.org/mondial/10";
    }

    public RDFServlet() {
        XPathMathFunctions.register();
    }

    public void init(ServletConfig cfg) throws ServletException {
        System.out.println("RDF Servlet Initialisation ... ");
        examplesdir = cfg.getInitParameter("examplesDir");
        mondialrdfdir = cfg.getInitParameter("mondialrdfDir");
        indexhtmlfilename = String.valueOf(cfg.getServletContext().getRealPath("/")) + indexhtmlfile;
        sparqlformfilename = String.valueOf(cfg.getServletContext().getRealPath("/")) + sparqlformfile;
        localURL = cfg.getInitParameter("localURL");
        globalURL = cfg.getInitParameter("globalURL");
        String hostname = "";
        try {
            InetAddress ip = InetAddress.getLocalHost();
            hostname = ip.getHostName();
            System.out.println("Your current IP address : " + ip);
            System.out.println("Your current Hostname : " + hostname);
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        myURL = "ap34".equals(hostname) ? globalURL : localURL;
        System.out.println("RDF Servlet Initialisation finished ... ");
    }

    protected void doSomething(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block75: {
            try {
                req.setCharacterEncoding("UTF-8");
                resp.setCharacterEncoding("UTF-8");
                String action = req.getParameter("action");
                String accept = req.getHeader("Accept");
                String pathInfo = req.getPathInfo();
                String querytext = req.getParameter("query-text");
                String reasoningStr = req.getParameter("reasoning");
                String n3id = req.getParameter("n3exampleid");
                String n3text = req.getParameter("n3text");
                Boolean showN3 = false;
                if (n3id != null && !"".equals(n3id) && !n3id.startsWith("None-") || n3text != null && !"".equals(n3text)) {
                    showN3 = true;
                }
                String q = req.getParameter("q");
                String query2 = req.getParameter("query");
                String sparqlexampleid = req.getParameter("sparqlexampleid");
                String previousqueryid = req.getParameter("previousqueryid");
                String uri_parameter = req.getParameter("uri");
                if (uri_parameter == null) {
                    uri_parameter = "";
                }
                String requestURL = req.getRequestURL().toString();
                if (reasoningStr == null) {
                    reasoningStr = "NONE";
                }
                ParseRDF.Reasoner reasoning = ParseRDF.Reasoner.valueOf(reasoningStr);
                PrintWriter out = resp.getWriter();
                String method = req.getMethod();
                String uri = "";
                Boolean optimizeQuery = false;
                optimizeQuery = req.getParameterValues("optimize") != null || querytext == null && accept.contains("text/html,application/xhtml+xml") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                if (querytext != null && !"".equals(querytext)) {
                    querytext = JenaModelWrapper.addMondialPrefix(querytext);
                }
                System.out.println("RDFServlet.doSomething - method: " + method);
                System.out.println("RDFServlet.doSomething - Servlet Path: " + req.getServletPath());
                Enumeration parameterNames = req.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    System.out.println("RDFServlet.doSomething - Parameter names: " + parameterNames.nextElement().toString());
                }
                System.out.println("RDFServlet.doSomething - action: " + action);
                System.out.println("RDFServlet.doSomething - Context Path: " + req.getContextPath());
                System.out.println("RDFServlet.doSomething - n3id: " + n3id);
                System.out.println("RDFServlet.doSomething - Querytext: " + querytext);
                System.out.println("RDFServlet.doSomething - Optimize Query: " + req.getParameterValues("values"));
                System.out.println("RDFServlet.doSomething - q: " + q);
                System.out.println("RDFServlet.doSomething - query: " + query2);
                System.out.println("RDFServlet.doSomething - reasoning: " + reasoningStr);
                System.out.println("RDFServlet.doSomething - Accept Header: " + req.getHeader("Accept"));
                System.out.println("RDFServlet.doSomething - Content-Type Header: " + req.getHeader("Content-Type"));
                System.out.println("RDFServlet.doSomething - uri_parameter: " + uri_parameter);
                System.out.println("Optimize Query: " + optimizeQuery);
                long start = System.currentTimeMillis();
                if (action == null) {
                    if (accept.contains(HTMLHEADER)) {
                        resp.setContentType(HTMLHEADER);
                        if (pathInfo == null || pathInfo.equals("/")) {
                            InputStream in = null;
                            in = new File(startpagelocalpath).exists() ? new FileInputStream(new File(startpagelocalpath)) : new URL("https://www.dbis.informatik.uni-goettingen.de/Mondial/mondial-lod.html").openStream();
                            StringBuilder builder = new StringBuilder();
                            Throwable throwable = null;
                            Object var27_34 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "iso-8859-1"));){
                                int c = 0;
                                while ((c = ((Reader)reader).read()) != -1) {
                                    builder.append((char)c);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            in.close();
                            out.println(builder.toString());
                            break block75;
                        }
                        if (query2 == null && (pathInfo.endsWith("/sparql") || pathInfo.endsWith("/sparql/"))) {
                            action = "default";
                            RDFFrontend.sparqlquery(out, false, null, null, null, null, null, false, false, reasoning, myURL, optimizeQuery, start);
                        } else if (pathInfo.contains("/sparql") && query2 != null) {
                            RDFFrontend.sendmondialSPARQLQuery(query2, out, true, myURL);
                        } else {
                            if (uri_parameter.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns%23type")) {
                                uri = uri_parameter;
                            } else if (uri_parameter.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns%23Property")) {
                                uri = uri_parameter;
                            } else if (uri_parameter.equals("http://www.w3.org/2001/XMLSchema#date")) {
                                uri = uri_parameter;
                            } else if (pathInfo.contains("#") || pathInfo.contains("%23")) {
                                pathInfo = pathInfo.replace("%23", "#");
                                uri = String.valueOf(semWebURI) + pathInfo;
                                if (uri.endsWith("/")) {
                                    uri = uri.substring(0, uri.length() - 1);
                                }
                            } else if (pathInfo.contains("__")) {
                                uri = String.valueOf(semWebURI) + "/" + pathInfo;
                                if (uri.endsWith("/")) {
                                    uri = uri.substring(0, uri.length() - 1);
                                }
                            } else {
                                uri = String.valueOf(semWebURI) + pathInfo;
                                if (!uri.endsWith("/")) {
                                    uri = String.valueOf(uri) + "/";
                                }
                            }
                            System.out.println("RDFServlet.doSomething - uri: " + uri);
                            RDFFrontend.getRDFData(out, uri, true, myURL);
                        }
                        break block75;
                    }
                    if (accept.contains(RDFXMLHEADER)) {
                        resp.setContentType(RDFXMLHEADER);
                        if (pathInfo == null || pathInfo.equals("/")) {
                            RDFFrontend.getAllURIs(out, false, "");
                            break block75;
                        }
                        if (pathInfo.contains("/sparql")) {
                            RDFFrontend.sendmondialSPARQLQuery(query2, out, false, myURL);
                            break block75;
                        }
                        if (requestURL.contains("meta%23") || requestURL.contains("meta#")) {
                            System.out.println("RDFServlet.doSomething MondialURL:" + RDFFrontend.mondialURL);
                            InputStream in = new URL(String.valueOf(RDFFrontend.mondialURL) + "mondial-meta.rdf").openStream();
                            StringBuilder builder = new StringBuilder();
                            Throwable throwable = null;
                            Object var27_36 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                                int c = 0;
                                while ((c = ((Reader)reader).read()) != -1) {
                                    builder.append((char)c);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            in.close();
                            out.println(builder.toString());
                            break block75;
                        }
                        uri = String.valueOf(semWebURI) + pathInfo;
                        if (pathInfo.contains("#") || pathInfo.contains("%23")) {
                            if ((uri = uri.replace("%23", "#")).endsWith("/")) {
                                uri = uri.substring(0, uri.length() - 1);
                            }
                        } else if (!uri.endsWith("/")) {
                            uri = String.valueOf(uri) + "/";
                        }
                        System.out.println("RDFServlet.doSomething - uri: " + uri);
                        if (method.equals(POST) && uri_parameter != null || method.equals(GET)) {
                            RDFFrontend.getRDFData(out, uri, false, myURL);
                        }
                        break block75;
                    }
                    if (accept.contains(SPARQLHEADER)) {
                        resp.setContentType(SPARQLHEADER);
                        RDFFrontend.sendmondialSPARQLQuery(query2, out, false, myURL);
                    }
                    break block75;
                }
                resp.setContentType(HTMLHEADER);
                if (action.equals("Get Data Example")) {
                    action = "default";
                    if (n3id != null && n3id.startsWith("None-") && querytext != null) {
                        n3id = JenaModelWrapper.getFirstInputFile(querytext);
                    }
                    RDFFrontend.sparqlquery(out, true, n3id, null, sparqlexampleid, previousqueryid, querytext, true, false, reasoning, myURL, optimizeQuery, start);
                }
                if (n3id != null && n3id.startsWith("None-")) {
                    n3id = n3id.substring(5);
                }
                if (action.equals("SPARQL query")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, false, null, null, null, null, null, false, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("reset SPARQL query")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, showN3, n3id, n3text, null, null, "reset", false, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("expand data input field")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, true, null, null, sparqlexampleid, previousqueryid, querytext, true, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("close data input field")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, false, null, null, sparqlexampleid, previousqueryid, querytext, true, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("Get Query")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, showN3, n3id, n3text, sparqlexampleid, previousqueryid, null, true, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("Get Query and Data")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, true, null, null, sparqlexampleid, previousqueryid, null, true, false, reasoning, myURL, optimizeQuery, start);
                } else if (action.equals("send SPARQL query")) {
                    action = "default";
                    RDFFrontend.sparqlquery(out, showN3, n3id, n3text, sparqlexampleid, previousqueryid, querytext, true, true, reasoning, myURL, optimizeQuery, start);
                }
            }
            catch (IOException ie) {
                System.out.println("An IOException occured: " + ie);
                ie.printStackTrace();
            }
            catch (Throwable t) {
                System.out.println(String.valueOf(t.getMessage()) + t);
                t.printStackTrace();
                throw new ServletException(t);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doSomething(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doSomething(req, resp);
    }

    private String createIndexHtml() {
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        replacements.add(new String[]{MessageTag, "foo"});
        return RDFServlet.createHtml(indexhtmlfilename, replacements).toString();
    }

    public static StringBuffer createHtml(String htmlfilename, List<String[]> replacements) {
        StringBuffer html = new StringBuffer();
        try {
            String buffer;
            File inputfile = new File(htmlfilename);
            FileReader fr = new FileReader(inputfile);
            BufferedReader br = new BufferedReader(fr);
            while ((buffer = br.readLine()) != null) {
                if (replacements == null) continue;
                for (String[] x : replacements) {
                    if (!buffer.contains(x[0]) || x[1] == null) continue;
                    buffer = buffer.replace(x[0], x[1]);
                }
                html.append(buffer);
            }
            br.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            html.append(String.valueOf(RDFServlet.createDocumentHeader("Error")) + "<p>" + e2.toString() + "</p>" + RDFServlet.createDocumentFooter());
        }
        return html;
    }

    public static String createDocumentHeader(String title) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\"Transitional//EN\">\n<HTML>\n<HEAD>\n<TITLE>" + title + "</TITLE>\n" + "</HEAD>\n" + "<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" " + " LINK=\"#0000EE\" VLINK=\"#551A8B\" ALINK=\"#FF0000\" BACKGROUND=\"\">\n";
    }

    public static String createDocumentFooter() {
        return "<P><a href=" + myURL + " target='_blank'>Quick Manual</a></P></BODY></HTML>\n";
    }
}

