/*
 * Decompiled with CFR 0.152.
 */
package org.semwebtech.util.jena.sparql.function.library;

import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.semwebtech.util.jena.sparql.function.library.MATH_acos;
import org.semwebtech.util.jena.sparql.function.library.MATH_asin;
import org.semwebtech.util.jena.sparql.function.library.MATH_atan;
import org.semwebtech.util.jena.sparql.function.library.MATH_atan2;
import org.semwebtech.util.jena.sparql.function.library.MATH_cos;
import org.semwebtech.util.jena.sparql.function.library.MATH_exp;
import org.semwebtech.util.jena.sparql.function.library.MATH_exp10;
import org.semwebtech.util.jena.sparql.function.library.MATH_log;
import org.semwebtech.util.jena.sparql.function.library.MATH_log10;
import org.semwebtech.util.jena.sparql.function.library.MATH_pi;
import org.semwebtech.util.jena.sparql.function.library.MATH_pow;
import org.semwebtech.util.jena.sparql.function.library.MATH_sin;
import org.semwebtech.util.jena.sparql.function.library.MATH_sqrt;
import org.semwebtech.util.jena.sparql.function.library.MATH_tan;

public class XPathMathFunctions {
    private static final String XPATH_MATH_FUNCTIONS_NS = "http://www.w3.org/2005/xpath-functions/math#";

    public static void register() {
        XPathMathFunctions.register("acos", MATH_acos.class);
        XPathMathFunctions.register("asin", MATH_asin.class);
        XPathMathFunctions.register("atan", MATH_atan.class);
        XPathMathFunctions.register("atan2", MATH_atan2.class);
        XPathMathFunctions.register("cos", MATH_cos.class);
        XPathMathFunctions.register("exp", MATH_exp.class);
        XPathMathFunctions.register("exp10", MATH_exp10.class);
        XPathMathFunctions.register("log", MATH_log.class);
        XPathMathFunctions.register("log10", MATH_log10.class);
        XPathMathFunctions.register("pi", MATH_pi.class);
        XPathMathFunctions.register("pow", MATH_pow.class);
        XPathMathFunctions.register("sin", MATH_sin.class);
        XPathMathFunctions.register("sqrt", MATH_sqrt.class);
        XPathMathFunctions.register("tan", MATH_tan.class);
    }

    private static final void register(String functionName, Class<? extends FunctionBase> functionClass) {
        String functionQName = XPATH_MATH_FUNCTIONS_NS + functionName;
        FunctionRegistry.get().put(functionQName, functionClass);
    }
}

