/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmdline.ModContext;
import arq.cmdline.ModLangOutput;
import arq.cmdline.ModLangParse;
import arq.cmdline.ModTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import org.apache.jena.Jena;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sys.JenaSystem;

public abstract class CmdLangParse
extends CmdGeneral {
    protected ModTime modTime = new ModTime();
    protected ModLangParse modLangParse = new ModLangParse();
    protected ModLangOutput modLangOutput = new ModLangOutput();
    protected InferenceSetupRDFS setup = null;
    protected ModContext modContext = new ModContext();
    protected ArgDecl strictDecl = new ArgDecl(false, "strict");
    protected boolean cmdStrictMode = false;
    protected List<ParseRecord> outcomes = new ArrayList<ParseRecord>();
    OutputStream outputWrite = System.out;
    StreamRDF outputStream = null;

    protected CmdLangParse(String[] argv) {
        super(argv);
        this.addModule(this.modContext);
        this.addModule(this.modTime);
        this.addModule(this.modLangOutput);
        this.addModule(this.modLangParse);
        this.modVersion.addClass(Jena.class);
        String x1 = ARQ.VERSION;
        String x2 = ARQ.BUILD_DATE;
        this.modVersion.addClass(RIOT.class);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--time] [--check|--noCheck] [--sink] [--base=IRI] [--out=FORMAT] [--compress] file ...";
    }

    @Override
    protected void processModulesAndArgs() {
        this.cmdStrictMode = super.contains(this.strictDecl);
    }

    @Override
    protected void exec() {
        if (this.modLangParse.skipOnBadTerm()) {
            throw new CmdException("Not supported : skip on bad term");
        }
        boolean oldStrictValue = SysRIOT.isStrictMode();
        if (this.modLangParse.strictMode()) {
            SysRIOT.setStrictMode(true);
        }
        try {
            this.exec$();
        }
        finally {
            SysRIOT.setStrictMode(oldStrictValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec$() {
        if (this.modLangParse.getRDFSVocab() != null) {
            this.setup = new InferenceSetupRDFS(this.modLangParse.getRDFSVocab());
        }
        if (this.modLangOutput.compressedOutput()) {
            try {
                this.outputWrite = new GZIPOutputStream(this.outputWrite, true);
            }
            catch (IOException e2) {
                IO.exception(e2);
            }
        }
        this.outputStream = null;
        PostParseHandler postParse = null;
        this.outputStream = this.createStreamSink();
        if (this.outputStream == null) {
            Pair<StreamRDF, PostParseHandler> p = this.createAccumulateSink();
            this.outputStream = p.getLeft();
            postParse = p.getRight();
        }
        try {
            if (super.getPositional().isEmpty()) {
                ParseRecord parseRec = this.parseFile("-");
                this.outcome(parseRec);
            } else {
                boolean b = super.getPositional().size() > 1;
                for (String fn : super.getPositional()) {
                    if (b && !super.isQuiet()) {
                        SysRIOT.getLogger().info("File: " + fn);
                    }
                    ParseRecord parseRec = this.parseFile(fn);
                    this.outcome(parseRec);
                }
            }
            if (postParse != null) {
                postParse.postParse();
            }
            if (super.getPositional().size() > 1 && this.modTime.timingEnabled()) {
                long totalMillis = 0L;
                long totalTriples = 0L;
                long totalQuads = 0L;
                long totalTuples = 0L;
                long totalErrors = 0L;
                long totalWarnings = 0L;
                boolean allSuccessful = true;
                for (ParseRecord pRec : this.outcomes) {
                    if (pRec.timeMillis >= 0L) {
                        totalMillis += pRec.timeMillis;
                    }
                    totalTriples += pRec.triples;
                    totalQuads += pRec.quads;
                    totalTuples += pRec.tuples;
                    totalErrors += pRec.errHandler.getErrorCount();
                    totalWarnings += pRec.errHandler.getWarningCount();
                    allSuccessful &= pRec.success;
                }
                this.output("Total", true, totalTriples, totalQuads, totalTuples, totalMillis, totalErrors, totalWarnings);
            }
        }
        finally {
            if (this.outputWrite != System.out) {
                IO.close(this.outputWrite);
            } else {
                IO.flush(this.outputWrite);
            }
            System.err.flush();
        }
        for (ParseRecord pr : this.outcomes) {
            if (pr.success && !pr.errHandler.hadIssues()) continue;
            throw new CmdException();
        }
    }

    public void outcome(ParseRecord rtn) {
        this.outcomes.add(rtn);
        if (this.modTime.timingEnabled()) {
            this.output(rtn);
        }
    }

    public ParseRecord parseFile(String filename) {
        String baseURI = this.modLangParse.getBaseIRI();
        RDFParserBuilder builder = RDFParser.create();
        if (baseURI != null) {
            builder.base(baseURI);
        }
        if (this.modLangParse.getLang() != null) {
            builder.forceLang(this.modLangParse.getLang());
        } else {
            Lang lang = this.dftLang();
            if (lang == null) {
                lang = Lang.NQUADS;
            }
            builder.lang(lang);
        }
        if (filename.equals("-")) {
            if (baseURI == null) {
                baseURI = "http://base/";
                builder.base(baseURI);
            }
            builder.source(System.in);
        } else {
            builder.source(filename);
        }
        return this.parseRIOT(builder, filename);
    }

    protected abstract Lang dftLang();

    protected ParseRecord parseRIOT(RDFParserBuilder builder, String filename) {
        boolean checking = true;
        if (this.modLangParse.explicitChecking()) {
            checking = true;
        }
        if (this.modLangParse.explicitNoChecking()) {
            checking = false;
        }
        builder.checking(checking);
        ErrorHandlerFactory.ErrorHandlerTracking errHandler = ErrorHandlerFactory.errorHandlerTracking(ErrorHandlerFactory.stdLogger, this.modLangParse.stopOnBadTerm(), this.modLangParse.stopOnWarnings());
        if (this.modLangParse.skipOnBadTerm()) {
            // empty if block
        }
        boolean labelsAsGiven = false;
        StreamRDF s = this.outputStream;
        if (this.setup != null) {
            s = InfFactory.inf(s, this.setup);
        }
        StreamRDFCounting sink = StreamRDFLib.count(s);
        s = null;
        boolean successful = true;
        if (checking) {
            SysRIOT.setStrictMode(true);
        }
        builder.errorHandler(errHandler);
        this.modTime.startTimer();
        sink.start();
        RDFParser parser = builder.build();
        try {
            parser.parse(sink);
            successful = true;
        }
        catch (RiotException ex) {
            successful = false;
        }
        sink.finish();
        long x = this.modTime.endTimer();
        ParseRecord outcome = new ParseRecord(filename, successful, x, sink.countTriples(), sink.countQuads(), errHandler);
        return outcome;
    }

    protected StreamRDF createStreamSink() {
        if (this.modLangParse.toBitBucket()) {
            return StreamRDFLib.sinkNull();
        }
        RDFFormat fmt = this.modLangOutput.getOutputStreamFormat();
        if (fmt == null) {
            return null;
        }
        return StreamRDFWriter.getWriterStream(this.outputWrite, fmt);
    }

    protected Pair<StreamRDF, PostParseHandler> createAccumulateSink() {
        final DatasetGraph dsg = DatasetGraphFactory.create();
        StreamRDF sink = StreamRDFLib.dataset(dsg);
        final RDFFormat fmt = this.modLangOutput.getOutputFormatted();
        PostParseHandler handler = new PostParseHandler(){

            @Override
            public void postParse() {
                WriterDatasetRIOTFactory w = RDFWriterRegistry.getWriterDatasetFactory(fmt);
                if (w != null) {
                    RDFDataMgr.write(CmdLangParse.this.outputWrite, dsg, fmt);
                    return;
                }
                WriterGraphRIOTFactory wg = RDFWriterRegistry.getWriterGraphFactory(fmt);
                if (wg != null) {
                    RDFDataMgr.write((OutputStream)System.out, dsg.getDefaultGraph(), fmt);
                    return;
                }
                throw new InternalErrorException("failed to find the writer: " + fmt);
            }
        };
        return Pair.create(sink, handler);
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(in);
        return tokenizer;
    }

    protected void output(ParseRecord rtn) {
        this.output(rtn.filename, rtn.success, rtn.triples, rtn.quads, rtn.tuples, rtn.timeMillis, rtn.errHandler.getErrorCount(), rtn.errHandler.getWarningCount());
    }

    protected void output(String label, boolean success, long numberTriples, long numberQuads, long numberTuples, long timeMillis, long errorCount, long warningCount) {
        double timeSec = (double)timeMillis / 1000.0;
        long total = numberTriples + numberQuads + numberTuples;
        StringBuilder sb = new StringBuilder();
        if (total > 0L) {
            sb.append(label);
            if (success) {
                this.appendFmt(sb, " : %,5.2f sec", timeSec);
            }
            this.appendCount(sb, numberTriples, "Triple", "Triples", "TPS");
            this.appendCount(sb, numberQuads, "Quad", "Quads", "QPS");
            this.appendCount(sb, numberTuples, "Tuple", "Tuples", "TPS");
            if (success && timeMillis > 0L) {
                this.appendFmt(sb, " : %,.2f %s", (double)numberTriples / timeSec, "per second");
            }
        } else {
            this.appendFmt(sb, "%s :  (No Output)", label);
        }
        if (errorCount > 0L || warningCount > 0L) {
            this.appendFmt(sb, " : %,d %s", errorCount, "errors");
            this.appendFmt(sb, " : %,d %s", warningCount, "warnings");
        }
        System.err.println(sb.toString());
    }

    private void appendFmt(StringBuilder sb, String fmt, Object ... args) {
        sb.append(String.format(fmt, args));
    }

    private void appendCount(StringBuilder sb, long number, String itemName, String itemsName, String rateName) {
        if (number > 0L) {
            String str2 = itemName;
            if (number > 1L) {
                str2 = itemsName;
            }
            sb.append(String.format(" : %,d %s", number, str2));
        }
    }

    protected void output(String label) {
        System.err.printf("%s : \n", label);
    }

    static {
        JenaSystem.init();
    }

    static class ParseRecord {
        final String filename;
        final boolean success;
        final long timeMillis;
        final long triples;
        final long quads;
        final long tuples = 0L;
        final ErrorHandlerFactory.ErrorHandlerTracking errHandler;

        public ParseRecord(String filename, boolean successful, long timeMillis, long countTriples, long countQuads, ErrorHandlerFactory.ErrorHandlerTracking errHandler) {
            this.filename = filename;
            this.success = successful;
            this.timeMillis = timeMillis;
            this.triples = countTriples;
            this.quads = countQuads;
            this.errHandler = errHandler;
        }
    }

    protected static interface PostParseHandler {
        public void postParse();
    }
}

