/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.ConceptCache;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;

public abstract class AbstractConceptCache
implements ConceptCache {
    private int maxSize;

    public AbstractConceptCache(int maxSize) {
        this.maxSize = maxSize;
    }

    protected boolean isFull() {
        return this.size() == this.maxSize;
    }

    public Bool getSat(ATermAppl c) {
        CachedNode cached = (CachedNode)this.get(c);
        return cached == null ? Bool.UNKNOWN : Bool.create(!cached.isBottom());
    }

    public boolean putSat(ATermAppl c, boolean isSatisfiable) {
        CachedNode cached = (CachedNode)this.get(c);
        if (cached != null) {
            if (isSatisfiable != !cached.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + c);
            }
            return false;
        }
        if (isSatisfiable) {
            this.put(c, CachedNode.createSatisfiableNode());
        } else {
            ATermAppl notC = ATermUtils.negate(c);
            this.put(c, CachedNode.createBottomNode());
            this.put(notC, CachedNode.createTopNode());
        }
        return true;
    }

    public CachedNode remove(ATermAppl c, boolean removeComplete) {
        CachedNode cached = (CachedNode)this.get(c);
        if (cached != null && (removeComplete || cached.isIncomplete())) {
            this.remove(c);
        }
        return cached;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

