/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OptimizedDoubleBlocking;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RuleBranch;
import org.mindswap.pellet.SROIQStrategy;
import org.mindswap.pellet.rete.Compiler;
import org.mindswap.pellet.rete.Constant;
import org.mindswap.pellet.rete.Fact;
import org.mindswap.pellet.rete.Interpreter;
import org.mindswap.pellet.rules.BindingGeneratorStrategy;
import org.mindswap.pellet.rules.BindingGeneratorStrategyImpl;
import org.mindswap.pellet.rules.RulesToReteTranslator;
import org.mindswap.pellet.rules.VariableBinding;
import org.mindswap.pellet.rules.model.AtomDObject;
import org.mindswap.pellet.rules.model.AtomIObject;
import org.mindswap.pellet.rules.model.BuiltInAtom;
import org.mindswap.pellet.rules.model.ClassAtom;
import org.mindswap.pellet.rules.model.DataRangeAtom;
import org.mindswap.pellet.rules.model.DatavaluedPropertyAtom;
import org.mindswap.pellet.rules.model.DefaultRuleAtomVisitor;
import org.mindswap.pellet.rules.model.DifferentIndividualsAtom;
import org.mindswap.pellet.rules.model.IndividualPropertyAtom;
import org.mindswap.pellet.rules.model.Rule;
import org.mindswap.pellet.rules.model.RuleAtom;
import org.mindswap.pellet.rules.model.RuleAtomVisitor;
import org.mindswap.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class RuleStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;

    public RuleStrategy(ABox abox) {
        super(abox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(abox);
        if (!abox.getKB().getExpressivity().hasComplexSubRoles()) {
            this.blocking = new OptimizedDoubleBlocking();
        }
    }

    public void applyRULERule() {
        for (Rule rule : this.abox.getKB().getRules()) {
            int total = 0;
            for (VariableBinding binding : this.bindingStrategy.createGenerator(rule)) {
                ++total;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding: " + binding));
                    log.debug((Object)("total:" + total));
                }
                if (this.abox.isClosed()) continue;
                this.createDisjunctionsFromBinding(binding, rule);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("total bindings:" + total));
            log.debug((Object)("branches:" + this.abox.getBranch()));
        }
    }

    ABox complete() {
        this.completionTimer.start();
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        if (!this.abox.ranRete && this.abox.rulesNotApplied) {
            Interpreter interp = new Interpreter(this.abox);
            RulesToReteTranslator translator = new RulesToReteTranslator(this.abox);
            interp.rete.compile(translator.translateRules(this.abox.getKB().getRules()));
            Set<Fact> facts = interp.rete.compileFacts(this.abox);
            interp.addFacts(facts, true);
            interp.run();
            if (log.isDebugEnabled()) {
                log.debug((Object)(interp.inferredFacts.size() + " inferred fact(s)"));
            }
            DependencySet ds = DependencySet.INDEPENDENT;
            for (Fact f : interp.inferredFacts) {
                Node to;
                Individual ind2;
                Individual ind1;
                Constant pred = (Constant)f.getElements().get(0);
                ATermAppl subj = ((Constant)f.getElements().get(1)).getValue();
                ATermAppl obj = ((Constant)f.getElements().get(2)).getValue();
                if (pred.equals(Compiler.TYPE)) {
                    Individual ind = this.abox.getIndividual((ATerm)subj);
                    ATermAppl type = obj;
                    ind.addType(type, ds);
                    continue;
                }
                if (pred.equals(Compiler.SAME_AS)) {
                    ind1 = this.abox.getIndividual((ATerm)subj);
                    ind2 = this.abox.getIndividual((ATerm)obj);
                    ind1.setSame(ind2, DependencySet.INDEPENDENT);
                    continue;
                }
                if (pred.equals(Compiler.DIFF_FROM)) {
                    ind1 = this.abox.getIndividual((ATerm)subj);
                    ind2 = this.abox.getIndividual((ATerm)obj);
                    ind1.setDifferent(ind2, DependencySet.INDEPENDENT);
                    continue;
                }
                Role r = this.abox.getRole((ATerm)pred.getValue());
                Individual from = this.abox.getIndividual((ATerm)subj);
                if (r != null && r.isObjectRole()) {
                    to = this.abox.getIndividual((ATerm)obj);
                } else if (r != null && r.isDatatypeRole()) {
                    to = this.abox.getLiteral((ATerm)obj);
                    if (to == null) {
                        to = this.abox.addLiteral(obj);
                    }
                } else {
                    log.warn((Object)("Ignoring non object or datatype role " + pred));
                    continue;
                }
                this.addEdge(from, r, to, ds);
            }
            this.abox.ranRete = true;
        }
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                Timer t;
                this.completionTimer.check();
                this.abox.changed = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb"));
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    t = this.timers.startTimer("rule-nominal");
                    this.applyNominalRule(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-guess");
                this.applyGuessingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-max");
                this.applyMaxRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    t = this.timers.startTimer("check-dt-count");
                    this.checkDatatypeCount(i);
                    t.stop();
                    if (this.abox.isClosed()) break;
                    t = this.timers.startTimer("rule-lit");
                    this.applyLiteralRule();
                    t.stop();
                    if (this.abox.isClosed()) break;
                }
                t = this.timers.startTimer("rule-unfold");
                this.applyUnfoldingRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-disj");
                this.applyDisjunctionRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-some");
                this.applySomeValuesRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-min");
                this.applyMinRule(i);
                t.stop();
                if (this.abox.isClosed()) break;
                t = this.timers.startTimer("rule-rule");
                if (this.abox.rulesNotApplied) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Applying RULE rule at branch:" + this.abox.getBranch()));
                    }
                    this.abox.rulesNotApplied = false;
                    this.applyRULERule();
                }
                t.stop();
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash()));
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this.abox.getBranches().get(i);
                    ++unexploredBranch.tryNext;
                    if (unexploredBranch.tryNext < unexploredBranch.tryCount) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.branch + " tryNext = " + unexploredBranch.tryNext + " tryCount = " + unexploredBranch.tryCount);
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.branch);
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }

    private void createDisjunctionsFromBinding(VariableBinding binding, Rule rule) {
        DisjunctionCounter counter = new DisjunctionCounter();
        for (RuleAtom atom : rule.getBody()) {
            atom.accept(counter);
        }
        for (RuleAtom atom : rule.getHead()) {
            atom.accept(counter);
        }
        ATermAppl[] disj = new ATermAppl[counter.getCount()];
        ATermAppl[] inds = new ATermAppl[counter.getCount()];
        int index = 0;
        DisjunctionVisitor visitor = new DisjunctionVisitor(binding);
        for (RuleAtom atom : rule.getHead()) {
            atom.accept(visitor);
            if (visitor.getDisjunct() == null) continue;
            disj[index] = visitor.getDisjunct();
            inds[index] = visitor.getIndividual();
            ++index;
        }
        for (RuleAtom atom : rule.getBody()) {
            atom.accept(visitor);
            if (visitor.getDisjunct() == null) continue;
            disj[index] = ATermUtils.normalize(ATermUtils.negate(visitor.getDisjunct()));
            inds[index] = visitor.getIndividual();
            ++index;
        }
        ATermAppl disjunction = ATermUtils.makeOr(ATermUtils.makeList((ATerm[])disj));
        if (!this.abox.isClosed()) {
            RuleBranch r = new RuleBranch(this.abox, this, this.abox.getIndividual((ATerm)inds[0]), inds, disjunction, new DependencySet(this.abox.getBranch()), disj);
            this.addBranch(r);
            r.tryBranch();
        }
    }

    private class DisjunctionVisitor
    implements RuleAtomVisitor {
        private VariableBinding binding;
        private ATermAppl disjunct;
        private ATermAppl individual;

        public DisjunctionVisitor(VariableBinding binding) {
            this.binding = binding;
        }

        public ATermAppl getDisjunct() {
            return this.disjunct;
        }

        public ATermAppl getIndividual() {
            return this.individual;
        }

        public void visit(BuiltInAtom atom) {
            this.disjunct = null;
            this.individual = null;
        }

        public void visit(ClassAtom atom) {
            this.disjunct = (ATermAppl)atom.getPredicate();
            this.individual = this.binding.get((AtomIObject)atom.getArgument()).getName();
        }

        public void visit(DataRangeAtom atom) {
            this.disjunct = null;
            this.individual = null;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue((ATerm)this.binding.get((AtomDObject)atom.getArgument2()).getName()));
            this.disjunct = ATermUtils.negate(ATermUtils.makeAllValues((ATerm)atom.getPredicate(), (ATerm)notO));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(DifferentIndividualsAtom atom) {
            this.disjunct = ATermUtils.negate(ATermUtils.makeValue((ATerm)this.binding.get((AtomIObject)atom.getArgument2()).getName()));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(IndividualPropertyAtom atom) {
            ATermAppl notO = ATermUtils.negate(ATermUtils.makeValue((ATerm)this.binding.get((AtomIObject)atom.getArgument2()).getName()));
            this.disjunct = ATermUtils.negate(ATermUtils.makeAllValues((ATerm)atom.getPredicate(), (ATerm)notO));
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }

        public void visit(SameIndividualAtom atom) {
            this.disjunct = ATermUtils.makeValue((ATerm)this.binding.get((AtomIObject)atom.getArgument2()).getName());
            this.individual = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        }
    }

    private class DisjunctionCounter
    extends DefaultRuleAtomVisitor {
        int count = 0;

        private DisjunctionCounter() {
        }

        public int getCount() {
            return this.count;
        }

        public void visit(ClassAtom atom) {
            ++this.count;
        }

        public void visit(DatavaluedPropertyAtom atom) {
            ++this.count;
        }

        public void visit(DifferentIndividualsAtom atom) {
            ++this.count;
        }

        public void visit(IndividualPropertyAtom atom) {
            ++this.count;
        }

        public void visit(SameIndividualAtom atom) {
            ++this.count;
        }
    }
}

