/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.jena.ATermToNodeMapper;
import org.mindswap.pellet.jena.CollectionsIterator;
import org.mindswap.pellet.jena.DisjointMultiUnion;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.MultiIterator;
import org.mindswap.pellet.jena.OWLLoader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.TripleFiller;
import org.mindswap.pellet.jena.vocabulary.OWL_1_1;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class PelletInfGraph
extends BaseInfGraph
implements InfGraph {
    public static final Log log = LogFactory.getLog(PelletInfGraph.class);
    public static boolean DEBUG = false;
    public static boolean GET_ONLY_PROPERTIES = false;
    public static final byte SUBJ = 0;
    public static final byte PRED = 1;
    public static final byte OBJ = 2;
    public static final Node RDF_type = RDF.Nodes.type;
    public static final Node RDF_directType = ReasonerVocabulary.directRDFType.asNode();
    public static final Node RDFS_subClassOf = RDFS.Nodes.subClassOf;
    public static final Node RDFS_directSubClassOf = ReasonerVocabulary.directSubClassOf.asNode();
    public static final Node OWL_equivalentClass = OWL.equivalentClass.asNode();
    public static final Node OWL_complementOf = OWL.complementOf.asNode();
    public static final Node OWL_disjointWith = OWL.disjointWith.asNode();
    public static final Node RDFS_subPropertyOf = RDFS.Nodes.subPropertyOf;
    public static final Node RDFS_directSubPropertyOf = ReasonerVocabulary.directSubPropertyOf.asNode();
    public static final Node OWL_equivalentProperty = OWL.equivalentProperty.asNode();
    public static final Node OWL_Class = OWL.Class.asNode();
    public static final Node RDFS_domain = RDFS.Nodes.domain;
    public static final Node RDFS_range = RDFS.Nodes.range;
    public static final Node OWL_differentFrom = OWL.differentFrom.asNode();
    public static final Node OWL_sameAs = OWL.sameAs.asNode();
    private static final Set TBOX_PROPS = SetUtils.create(new Node[]{RDFS_subClassOf, RDFS_directSubClassOf, OWL_equivalentClass, OWL_complementOf, OWL_disjointWith});
    private static final Set ABOX_PROPS = SetUtils.create(new Node[]{OWL.sameAs.asNode(), OWL.differentFrom.asNode()});
    private static final Set RBOX_PROPS = SetUtils.create(new Node[]{RDFS_subPropertyOf, RDFS_directSubPropertyOf, OWL_equivalentProperty, OWL.inverseOf.asNode()});
    private static final Set RBOX_TYPES = SetUtils.create(new Node[]{RDF.Property.asNode(), OWL.ObjectProperty.asNode(), OWL.DatatypeProperty.asNode(), OWL.FunctionalProperty.asNode(), OWL.InverseFunctionalProperty.asNode(), OWL.SymmetricProperty.asNode(), OWL.TransitiveProperty.asNode()});
    private static final Filter filterSystemPredicates = new Filter(){

        public boolean accept(Object obj) {
            Triple triple = (Triple)obj;
            return triple.getPredicate().equals((Object)RDFS_directSubPropertyOf);
        }
    };
    private OWLReasoner reasoner = new OWLReasoner();
    protected KnowledgeBase kb;
    private Graph deductionsGraph;
    private Graph rbox;
    private boolean lazyConsistency = false;
    private ATermToNodeMapper nodeMapper = new ATermToNodeMapper();

    public PelletInfGraph(Graph graph, PelletReasoner pellet) {
        super(graph, (Reasoner)pellet);
        this.kb = this.reasoner.getKB();
        if (pellet.getSchema() != null) {
            DisjointMultiUnion union = new DisjointMultiUnion(graph, this.kb, this.reasoner.getLoader());
            union.addGraph(pellet.getSchema());
            this.fdata = new FGraph((Graph)union);
        }
        this.rebind();
    }

    public boolean isLazyConsistency() {
        return this.lazyConsistency;
    }

    public void setLazyConsistency(boolean lazyConsistency) {
        this.lazyConsistency = lazyConsistency;
    }

    public ExtendedIterator find(Node subject, Node property, Node object, Graph param) {
        this.prepare();
        OWLLoader loader = this.reasoner.getLoader();
        Graph graph = loader.getGraph();
        Union union = new Union(graph, param);
        loader.setGraph((Graph)union);
        ExtendedIterator result = this.graphBaseFind(subject, property, object);
        loader.setGraph(graph);
        return result;
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder finder) {
        this.prepare();
        Node subject = pattern.getSubject().isVariable() ? Node.ANY : pattern.getSubject();
        Node predicate = pattern.getPredicate().isVariable() ? Node.ANY : pattern.getPredicate();
        Node object = pattern.getObject().isVariable() ? Node.ANY : pattern.getObject();
        ExtendedIterator i = new MultiIterator((Iterator)this.findInTBox(subject, predicate, object)).andThen((ClosableIterator)this.findInRBox(subject, predicate, object).andThen((ClosableIterator)this.findInABox(subject, predicate, object)));
        if (finder != null) {
            TriplePattern tp = new TriplePattern(subject, predicate, object);
            i = i.andThen((ClosableIterator)finder.find(tp));
        }
        return UniqueExtendedIterator.create((Iterator)i);
    }

    public Graph getSchemaGraph() {
        return ((PelletReasoner)this.getReasoner()).getSchema();
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void prepare() {
        DisjointMultiUnion diff;
        if (this.isPrepared) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing PelletInfGraph...");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computing changes...");
        }
        DisjointMultiUnion union = (DisjointMultiUnion)this.reasoner.getModel().getGraph();
        Graph rawGraph = this.getRawGraph();
        DisjointMultiUnion newUnion = new DisjointMultiUnion(rawGraph);
        DisjointMultiUnion disjointMultiUnion = diff = union.isStatementDeleted() ? null : newUnion.minus(union);
        if (diff != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading diff...");
            }
            this.reasoner.load(diff);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Reloading...");
            }
            this.reasoner.clear();
            this.reasoner.load(newUnion);
        }
        newUnion.releaseListeners();
        union.resetChanged();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consistency...");
        }
        if (this.lazyConsistency) {
            this.kb.prepare();
        } else {
            this.kb.isConsistent();
        }
        this.deductionsGraph = null;
        ModelExtractor extractor = this.reasoner.getModelExtractor();
        extractor.setVerbose(true);
        extractor.setIncludeDirects(true);
        this.rbox = extractor.extractPropertyModel().getGraph();
        if (log.isDebugEnabled()) {
            log.debug((Object)"done.");
        }
        this.isPrepared = true;
    }

    public boolean isConsistent() {
        this.prepare();
        return this.kb.isConsistent();
    }

    public boolean isClassified() {
        return this.isPrepared && this.kb.isRealized();
    }

    public void classify() {
        this.prepare();
        this.kb.realize();
    }

    public Graph getDeductionsGraph() {
        if (!PelletOptions.RETURN_DEDUCTIONS_GRAPH) {
            return null;
        }
        this.classify();
        if (this.deductionsGraph == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Realizing PelletInfGraph...");
            }
            this.kb.realize();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extract model...");
            }
            ModelExtractor extractor = this.reasoner.getModelExtractor();
            extractor.setVerbose(true);
            extractor.setIncludeDirects(true);
            Model extractedModel = extractor.extractModel();
            this.deductionsGraph = extractedModel.getGraph();
            if (log.isDebugEnabled()) {
                log.debug((Object)"done.");
            }
        }
        return this.deductionsGraph;
    }

    private ExtendedIterator findInABox(Node subject, Node predicate, Node object) {
        ATermAppl s = this.node2term(subject);
        ATermAppl p = this.node2term(predicate);
        ATermAppl o = this.node2term(object);
        boolean possibleInABox = true;
        possibleInABox &= !subject.isConcrete() || this.kb.isIndividual((ATerm)s);
        if (predicate.equals((Object)RDF_type) || predicate.equals((Object)RDF_directType)) {
            possibleInABox &= !object.isConcrete() || this.kb.isClass((ATerm)o);
        } else {
            if (predicate.isURI()) {
                possibleInABox &= ABOX_PROPS.contains(predicate) || this.kb.isABoxProperty((ATerm)p);
            }
            possibleInABox &= !object.isConcrete() || this.kb.isIndividual((ATerm)o) || ATermUtils.isLiteral(o);
        }
        if (!possibleInABox) {
            return NullIterator.instance;
        }
        Object iterator = NullIterator.instance;
        if (!predicate.isURI()) {
            if (subject.isConcrete()) {
                if (object.isConcrete()) {
                    iterator = iterator.andThen((ClosableIterator)this.propertyIterator(subject, s, object, o));
                    if (!GET_ONLY_PROPERTIES && this.kb.isIndividual((ATerm)o)) {
                        if (this.kb.isSameAs(s, o)) {
                            iterator = iterator.andThen((ClosableIterator)this.singletonIterator(subject, OWL_sameAs, object));
                        } else if (this.kb.isDifferentFrom(s, o)) {
                            iterator = iterator.andThen((ClosableIterator)this.singletonIterator(subject, OWL_differentFrom, object));
                        }
                    }
                } else {
                    iterator = new ABoxPredObjIterator(subject, s, 2);
                    if (!GET_ONLY_PROPERTIES) {
                        iterator = iterator.andThen((ClosableIterator)this.typeIterator(subject, s));
                        iterator = iterator.andThen((ClosableIterator)this.sameAsIterator(subject, s, (byte)2));
                        iterator = iterator.andThen((ClosableIterator)this.differentFromIterator(subject, s, (byte)2));
                    }
                }
            } else if (object.isConcrete()) {
                iterator = new ABoxPredObjIterator(object, o, 0);
                if (!GET_ONLY_PROPERTIES && this.kb.isIndividual((ATerm)o)) {
                    iterator = iterator.andThen((ClosableIterator)this.sameAsIterator(object, o, (byte)0));
                    iterator = iterator.andThen((ClosableIterator)this.differentFromIterator(object, o, (byte)0));
                }
            } else {
                iterator = new ABoxSubjPredObjIterator(2);
                if (!GET_ONLY_PROPERTIES) {
                    iterator = iterator.andThen((ClosableIterator)new ABoxSubjPredObjIterator(0));
                    iterator = iterator.andThen((ClosableIterator)new ABoxSubjPredObjIterator(3));
                    iterator = iterator.andThen((ClosableIterator)new ABoxSubjPredObjIterator(4));
                }
            }
        } else if (predicate.equals((Object)RDF_type)) {
            if (subject.isConcrete()) {
                if (object.isConcrete()) {
                    if (this.kb.isType(s, o)) {
                        iterator = this.singletonIterator(subject, RDF_type, object);
                    }
                } else {
                    iterator = this.typeIterator(subject, s);
                }
            } else {
                iterator = object.isConcrete() ? this.instanceIterator(object, o) : new ABoxSubjPredObjIterator(0);
            }
        } else if (predicate.equals((Object)RDF_directType)) {
            if (subject.isConcrete()) {
                if (object.isConcrete()) {
                    if (this.kb.getTypes(s, true).contains(o)) {
                        iterator = this.singletonIterator(subject, RDF_directType, object);
                    }
                } else {
                    iterator = this.directTypeIterator(subject, s);
                }
            } else {
                iterator = object.isConcrete() ? this.directInstanceIterator(object, o) : new ABoxSubjPredObjIterator(1);
            }
        } else if (predicate.equals((Object)OWL_sameAs)) {
            if (subject.isConcrete() && object.isConcrete()) {
                if (this.kb.isSameAs(s, o)) {
                    iterator = this.singletonIterator(subject, predicate, object);
                }
            } else if (subject.isConcrete()) {
                iterator = this.sameAsIterator(subject, s, (byte)2);
            } else if (object.isConcrete()) {
                iterator = this.sameAsIterator(object, o, (byte)0);
            }
        } else if (predicate.equals((Object)OWL_differentFrom)) {
            if (subject.isConcrete() && object.isConcrete()) {
                if (this.kb.isDifferentFrom(s, o)) {
                    iterator = this.singletonIterator(subject, predicate, object);
                }
            } else if (subject.isConcrete()) {
                iterator = this.differentFromIterator(subject, s, (byte)2);
            } else if (object.isConcrete()) {
                iterator = this.differentFromIterator(object, o, (byte)0);
            }
        } else if (!subject.isConcrete()) {
            iterator = !object.isConcrete() ? new ABoxSubjObjIterator(predicate, p) : this.subjectIterator(object, o, predicate, p);
        } else if (!object.isConcrete()) {
            iterator = this.objectIterator(subject, s, predicate, p);
        } else if (this.kb.hasPropertyValue(s, p, o)) {
            iterator = this.singletonIterator(subject, predicate, object);
        }
        return iterator;
    }

    private ExtendedIterator findInRBox(Node subject, Node predicate, Node object) {
        boolean possibleInRBox = true;
        possibleInRBox &= !subject.isURI() || this.kb.isProperty((ATerm)this.node2term(subject));
        if (predicate.equals((Object)RDF_type)) {
            possibleInRBox &= !object.isURI() || RBOX_TYPES.contains(object);
        } else {
            possibleInRBox &= !object.isURI() || this.kb.isProperty((ATerm)this.node2term(object));
            if (predicate.isURI()) {
                possibleInRBox &= RBOX_PROPS.contains(predicate);
            }
        }
        if (!possibleInRBox) {
            return NullIterator.instance;
        }
        return this.rbox.find(subject, predicate, object).filterDrop(filterSystemPredicates);
    }

    private ExtendedIterator findInTBox(Node subject, Node predicate, Node object) {
        ATermAppl s = this.node2term(subject);
        ATermAppl o = this.node2term(object);
        boolean possibleInTBox = true;
        possibleInTBox &= !subject.isConcrete() || this.kb.isClass((ATerm)s);
        if (predicate.equals((Object)RDF_type)) {
            possibleInTBox &= !object.isConcrete() || object.equals((Object)OWL_Class);
        } else {
            if (predicate.isURI()) {
                possibleInTBox &= TBOX_PROPS.contains(predicate);
            }
            possibleInTBox &= !object.isConcrete() || this.kb.isClass((ATerm)o);
        }
        if (!possibleInTBox) {
            return NullIterator.instance;
        }
        Object iterator = NullIterator.instance;
        if (!predicate.isURI()) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(null) : this.eqClassIterator(object, o, (byte)0).andThen((ClosableIterator)this.subClassIterator(object, o, false).andThen((ClosableIterator)this.disjointIterator(object, o, (byte)0).andThen((ClosableIterator)this.complementIterator(object, o, (byte)0))));
            } else if (!object.isConcrete()) {
                iterator = this.typeClassIterator(subject).andThen((ClosableIterator)this.eqClassIterator(subject, s, (byte)2).andThen((ClosableIterator)this.superClassIterator(subject, s, false).andThen((ClosableIterator)this.disjointIterator(subject, s, (byte)2).andThen((ClosableIterator)this.complementIterator(subject, s, (byte)2)))));
            }
        } else if (predicate.equals((Object)RDFS_subClassOf)) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(RDFS_subClassOf) : this.subClassIterator(object, o, false);
            } else if (!object.isConcrete()) {
                iterator = this.superClassIterator(subject, s, false);
            } else if (this.kb.isSubClassOf(s, o)) {
                iterator = this.singletonIterator(subject, predicate, object);
            }
        } else if (predicate.equals((Object)RDFS_directSubClassOf)) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(RDFS_directSubClassOf) : this.subClassIterator(object, o, true);
            } else if (!object.isConcrete()) {
                iterator = this.superClassIterator(subject, s, true);
            } else if (this.kb.getSubClasses(s, true).contains(o)) {
                iterator = this.singletonIterator(subject, RDFS_directSubClassOf, object);
            }
        } else if (predicate.equals((Object)RDF_type)) {
            if (!subject.isConcrete()) {
                iterator = WrappedIterator.create(this.kb.getAllClasses().iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubj(RDF_type, OWL_Class));
            } else if (this.kb.isClass((ATerm)s)) {
                iterator = this.typeClassIterator(subject);
            }
        } else if (predicate.equals((Object)OWL_equivalentClass)) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(OWL_equivalentClass) : this.eqClassIterator(object, o, (byte)0);
            } else if (!object.isConcrete()) {
                iterator = this.eqClassIterator(subject, s, (byte)2);
            } else if (this.kb.isEquivalentClass(s, o)) {
                iterator = this.singletonIterator(subject, OWL_equivalentClass, object);
            }
        } else if (predicate.equals((Object)OWL_disjointWith)) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(OWL_disjointWith) : this.disjointIterator(object, o, (byte)0);
            } else if (!object.isConcrete()) {
                iterator = this.disjointIterator(subject, s, (byte)2);
            } else if (this.kb.isDisjoint(s, o)) {
                iterator = this.singletonIterator(subject, OWL_disjointWith, object);
            }
        } else if (predicate.equals((Object)OWL_complementOf)) {
            if (!subject.isConcrete()) {
                iterator = !object.isConcrete() ? new TBoxSubjObjIterator(OWL_complementOf) : this.complementIterator(object, o, (byte)0);
            } else if (!object.isConcrete()) {
                iterator = this.complementIterator(subject, s, (byte)2);
            } else if (this.kb.isDisjoint(s, o)) {
                iterator = this.singletonIterator(subject, OWL_complementOf, object);
            }
        }
        return iterator;
    }

    protected boolean graphBaseContains(Triple pattern) {
        if (this.getRawGraph().contains(pattern)) {
            return true;
        }
        this.prepare();
        Node subject = pattern.getSubject().isVariable() ? Node.ANY : pattern.getSubject();
        Node predicate = pattern.getPredicate().isVariable() ? Node.ANY : pattern.getPredicate();
        Node object = pattern.getObject().isVariable() ? Node.ANY : pattern.getObject();
        Boolean contains = this.containedInTBox(subject, predicate, object);
        if (contains != null) {
            return contains;
        }
        contains = this.containedInABox(subject, predicate, object);
        if (contains != null) {
            return contains;
        }
        return this.rbox.contains(subject, predicate, object);
    }

    private SingletonIterator singletonIterator(Node s, Node p, Node o) {
        return new SingletonIterator((Object)new Triple(s, p, o));
    }

    private ExtendedIterator instanceIterator(Node objNode, ATermAppl obj) {
        return WrappedIterator.create(this.kb.getInstances(obj).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubj(RDF_type, objNode));
    }

    private ExtendedIterator directInstanceIterator(Node objNode, ATermAppl obj) {
        return WrappedIterator.create(this.kb.getInstances(obj, true).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubj(RDF_directType, objNode));
    }

    private ExtendedIterator typeIterator(Node subjNode, ATermAppl subj) {
        return WrappedIterator.create((Iterator)((Object)new CollectionsIterator(this.kb.getTypes(subj)))).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillObj(subjNode, RDF_type));
    }

    private ExtendedIterator directTypeIterator(Node subjNode, ATermAppl subj) {
        return WrappedIterator.create((Iterator)((Object)new CollectionsIterator(this.kb.getTypes(subj, true)))).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillObj(subjNode, RDF_directType));
    }

    private ExtendedIterator propertyIterator(Node subjNode, ATermAppl subj, Node objNode, ATermAppl obj) {
        return WrappedIterator.create(this.kb.getProperties(subj, obj).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillPred(subjNode, objNode));
    }

    private ExtendedIterator subjectIterator(Node objNode, ATermAppl obj, Node predNode, ATermAppl pred) {
        return WrappedIterator.create(this.kb.getIndividualsWithProperty(pred, obj).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubj(objNode, predNode));
    }

    private ExtendedIterator objectIterator(Node subjNode, ATermAppl subj, Node predNode, ATermAppl pred) {
        return WrappedIterator.create(this.kb.getPropertyValues(pred, subj).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillObj(subjNode, predNode));
    }

    private ExtendedIterator typeClassIterator(Node clsNode) {
        return this.singletonIterator(clsNode, RDF_type, OWL_Class);
    }

    private ExtendedIterator eqClassIterator(Node clsNode, ATermAppl cls, byte which) {
        return WrappedIterator.create(this.kb.getAllEquivalentClasses(cls).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubjObj(OWL_equivalentClass, clsNode, which));
    }

    private ExtendedIterator subClassIterator(Node clsNode, ATermAppl cls, boolean direct) {
        ExtendedIterator iterator = WrappedIterator.create((Iterator)((Object)new CollectionsIterator(this.kb.getSubClasses(cls, direct))));
        if (!direct) {
            iterator = iterator.andThen((ClosableIterator)WrappedIterator.create(this.kb.getAllEquivalentClasses(cls).iterator()));
        }
        return iterator.mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubj(RDFS_subClassOf, clsNode));
    }

    private ExtendedIterator superClassIterator(Node clsNode, ATermAppl cls, boolean direct) {
        ExtendedIterator iterator = WrappedIterator.create((Iterator)((Object)new CollectionsIterator(this.kb.getSuperClasses(cls, direct))));
        if (!direct) {
            iterator = iterator.andThen((ClosableIterator)WrappedIterator.create(this.kb.getAllEquivalentClasses(cls).iterator()));
        }
        return iterator.mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillObj(clsNode, RDFS_subClassOf));
    }

    private ExtendedIterator disjointIterator(Node clsNode, ATermAppl cls, byte which) {
        return WrappedIterator.create((Iterator)((Object)new CollectionsIterator(this.kb.getDisjoints(cls)))).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubjObj(OWL_disjointWith, clsNode, which));
    }

    private ExtendedIterator complementIterator(Node clsNode, ATermAppl cls, byte which) {
        return WrappedIterator.create(this.kb.getComplements(cls).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubjObj(OWL_complementOf, clsNode, which));
    }

    private ExtendedIterator sameAsIterator(Node instanceNode, ATermAppl instance, byte which) {
        return WrappedIterator.create(this.kb.getAllSames(instance).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubjObj(OWL.sameAs.asNode(), instanceNode, which));
    }

    private ExtendedIterator differentFromIterator(Node instanceNode, ATermAppl instance, byte which) {
        return WrappedIterator.create(this.kb.getDifferents(instance).iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)TripleFiller.fillSubjObj(OWL.differentFrom.asNode(), instanceNode, which));
    }

    private Boolean containedInABox(Node subject, Node predicate, Node object) {
        if (!predicate.isURI()) {
            return null;
        }
        ATermAppl s = this.node2term(subject);
        ATermAppl p = this.node2term(predicate);
        ATermAppl o = this.node2term(object);
        if (subject.isConcrete() && !this.kb.isIndividual((ATerm)s)) {
            return null;
        }
        String predURI = predicate.getURI();
        if (predURI.equals(RDF.type.getURI())) {
            if (object.isConcrete() && !this.kb.isClass((ATerm)o)) {
                return null;
            }
            if (subject.isConcrete()) {
                if (object.isConcrete()) {
                    return this.kb.isType(s, o) ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (object.isConcrete()) {
                return this.kb.hasInstance((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object.isConcrete() && !this.kb.isIndividual((ATerm)o) && !ATermUtils.isLiteral(o)) {
            return null;
        }
        if (predURI.equals(OWL.sameAs.getURI())) {
            if (subject.isConcrete() && object.isConcrete()) {
                return this.kb.isSameAs(s, o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (predURI.equals(OWL.differentFrom.getURI())) {
            if (subject.isConcrete() && object.isConcrete()) {
                return this.kb.isDifferentFrom(s, o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        Role r = this.kb.getProperty((ATerm)p);
        if (r == null || r.isAnnotationRole() || r.isOntologyRole()) {
            return null;
        }
        if (!subject.isConcrete() && !object.isConcrete()) {
            List<ATermAppl> candidates = this.kb.retrieveIndividualsWithProperty(p);
            return !candidates.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!subject.isConcrete()) {
            if (r.isDatatypeRole()) {
                return Boolean.FALSE;
            }
            ATermAppl invP = r.getInverse().getName();
            return this.kb.hasPropertyValue(o, invP, null) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!object.isConcrete()) {
            return this.kb.hasPropertyValue(s, p, null) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.kb.hasPropertyValue(s, p, o) ? Boolean.TRUE : Boolean.FALSE;
    }

    private Boolean containedInTBox(Node subject, Node predicate, Node object) {
        if (!predicate.isURI()) {
            return null;
        }
        ATermAppl s = this.node2term(subject);
        ATermAppl o = this.node2term(object);
        String predURI = predicate.getURI();
        if (predURI.equals(RDF.type.getURI())) {
            if (!object.isConcrete()) {
                return Boolean.TRUE;
            }
            if (object.equals((Object)OWL.Class.asNode()) || object.equals((Object)RDFS.Class.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getClasses().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isClass((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)RDF.Property.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.ObjectProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getObjectProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isObjectProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.DatatypeProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getDataProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isDatatypeProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.AnnotationProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isAnnotationProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.TransitiveProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getTransitiveProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isTransitiveProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.SymmetricProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getSymmetricProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isSymmetricProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.FunctionalProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getFunctionalProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isFunctionalProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.InverseFunctionalProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getInverseFunctionalProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isInverseFunctionalProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL_1_1.ReflexiveProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getReflexiveProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isReflexiveProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL_1_1.IrreflexiveProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getIrreflexiveProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isIrreflexiveProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL_1_1.AntisymmetricProperty.asNode())) {
                if (!subject.isConcrete()) {
                    return !this.kb.getAntisymmetricProperties().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
                }
                return this.kb.isAntisymmetricProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
        if (predURI.equals(RDFS.subClassOf.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isClass((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isClass((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isSubClassOf(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.complementOf.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return !this.kb.getComplements(o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return !this.kb.getComplements(s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isComplement(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.equivalentClass.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isClass((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isClass((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isEquivalentClass(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.disjointWith.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return !this.kb.getDisjoints(o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return Boolean.TRUE;
            }
            return this.kb.isDisjoint(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL_1_1.disjointObjectProperties.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isObjectProperty((ATerm)o) && !this.kb.getDisjointProperties(o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isObjectProperty((ATerm)s) && !this.kb.getDisjointProperties(s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isObjectProperty((ATerm)s) && this.kb.isObjectProperty((ATerm)o) && this.kb.isDisjointProperty(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL_1_1.disjointDataProperties.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isDatatypeProperty((ATerm)o) && !this.kb.getDisjointProperties(o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isDatatypeProperty((ATerm)s) && !this.kb.getDisjointProperties(s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isDatatypeProperty((ATerm)s) && this.kb.isDatatypeProperty((ATerm)o) && this.kb.isDisjointProperty(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.equivalentProperty.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isProperty((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isEquivalentProperty(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.subPropertyOf.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isProperty((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return this.kb.isProperty((ATerm)s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isSubPropertyOf(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.inverseOf.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return !this.kb.getInverses((ATerm)o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return !this.kb.getInverses((ATerm)s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.isInverse(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.domain.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isClass((ATerm)o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return !this.kb.getDomains(s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.hasDomain(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.range.getURI())) {
            if (!subject.isConcrete()) {
                if (!object.isConcrete()) {
                    return Boolean.TRUE;
                }
                return this.kb.isClass((ATerm)o) || this.kb.isDatatype(o) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!object.isConcrete()) {
                return !this.kb.getRanges((ATerm)s).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.kb.hasRange(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public OWLReasoner getOWLReasoner() {
        return this.reasoner;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.isPrepared = false;
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.isPrepared = false;
    }

    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport report = new StandardValidityReport();
        this.kb.setDoExplanation(true);
        boolean consistent = this.reasoner.isConsistent();
        this.kb.setDoExplanation(false);
        if (!consistent) {
            report.add(true, "KB is inconsistent!", this.kb.getExplanation());
        } else {
            for (ATermAppl c : this.kb.getClasses()) {
                if (this.kb.isSatisfiable(c)) continue;
                String name = this.nodeMapper.map1(c).toString();
                report.add(false, "Unsatisfiable class", name);
            }
        }
        return report;
    }

    public ATermAppl node2term(Node node) {
        if (node == Node.ANY) {
            return null;
        }
        return this.reasoner.getLoader().node2term(node);
    }

    public ATermAppl node2term(RDFNode node) {
        return this.node2term(node.asNode());
    }

    private class TBoxSubjObjIterator
    extends NiceIterator {
        private Node predNode;
        private ATermAppl subj;
        private Node subjNode;
        private Iterator subjects;
        private Iterator objects;

        public TBoxSubjObjIterator(Node predNode) {
            this.predNode = predNode;
            this.subjects = PelletInfGraph.this.kb.getAllClasses().iterator();
            this.findNextSubject();
        }

        private void findNextSubject() {
            while (this.subjects.hasNext()) {
                this.subj = (ATermAppl)this.subjects.next();
                this.subjNode = (Node)PelletInfGraph.this.nodeMapper.map1(this.subj);
                if (this.predNode == null) {
                    this.objects = PelletInfGraph.this.eqClassIterator(this.subjNode, this.subj, (byte)2).andThen((ClosableIterator)PelletInfGraph.this.superClassIterator(this.subjNode, this.subj, false).andThen((ClosableIterator)PelletInfGraph.this.disjointIterator(this.subjNode, this.subj, (byte)2).andThen((ClosableIterator)PelletInfGraph.this.complementIterator(this.subjNode, this.subj, (byte)2))));
                } else if (this.predNode.equals((Object)RDFS_subClassOf)) {
                    this.objects = PelletInfGraph.this.superClassIterator(this.subjNode, this.subj, false);
                } else if (this.predNode.equals((Object)RDFS_directSubClassOf)) {
                    this.objects = PelletInfGraph.this.superClassIterator(this.subjNode, this.subj, true);
                } else if (this.predNode.equals((Object)OWL_equivalentClass)) {
                    this.objects = PelletInfGraph.this.eqClassIterator(this.subjNode, this.subj, (byte)2);
                } else if (this.predNode.equals((Object)OWL_disjointWith)) {
                    this.objects = PelletInfGraph.this.disjointIterator(this.subjNode, this.subj, (byte)2);
                } else if (this.predNode.equals((Object)OWL_complementOf)) {
                    this.objects = PelletInfGraph.this.complementIterator(this.subjNode, this.subj, (byte)2);
                } else {
                    throw new InternalReasonerException("Invalid TBox predicate " + this.predNode);
                }
                if (!this.objects.hasNext()) continue;
                return;
            }
            this.objects = NullIterator.instance;
        }

        public boolean hasNext() {
            if (this.objects.hasNext()) {
                return true;
            }
            this.findNextSubject();
            return this.objects.hasNext();
        }

        public Object next() {
            this.ensureHasNext();
            return this.objects.next();
        }
    }

    private class ABoxSubjPredObjIterator
    extends NiceIterator {
        public static final byte TYPES = 0;
        public static final byte DIRECT_TYPES = 1;
        public static final byte PROPS = 2;
        public static final byte SAMES = 3;
        public static final byte DIFFERENTS = 4;
        private Iterator subjects;
        private ATermAppl subj;
        private Node subjNode;
        private Iterator iterator;
        private byte which;

        public ABoxSubjPredObjIterator(byte which) {
            this.which = which;
            this.subjects = PelletInfGraph.this.kb.getIndividuals().iterator();
            this.findNextSubject();
        }

        private void findNextSubject() {
            while (this.subjects.hasNext()) {
                this.subj = (ATermAppl)this.subjects.next();
                this.subjNode = (Node)PelletInfGraph.this.nodeMapper.map1(this.subj);
                switch (this.which) {
                    case 0: {
                        this.iterator = PelletInfGraph.this.typeIterator(this.subjNode, this.subj);
                        break;
                    }
                    case 1: {
                        this.iterator = PelletInfGraph.this.directTypeIterator(this.subjNode, this.subj);
                        break;
                    }
                    case 2: {
                        this.iterator = new ABoxPredObjIterator(this.subjNode, this.subj, 2);
                        break;
                    }
                    case 3: {
                        this.iterator = PelletInfGraph.this.sameAsIterator(this.subjNode, this.subj, (byte)2);
                        break;
                    }
                    case 4: {
                        this.iterator = PelletInfGraph.this.differentFromIterator(this.subjNode, this.subj, (byte)2);
                        break;
                    }
                    default: {
                        throw new InternalReasonerException("Invalid iterator");
                    }
                }
                if (!this.iterator.hasNext()) continue;
                return;
            }
            this.iterator = NullIterator.instance;
        }

        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            this.findNextSubject();
            return this.iterator.hasNext();
        }

        public Object next() {
            this.ensureHasNext();
            return this.iterator.next();
        }
    }

    private class ABoxPredObjIterator
    extends NiceIterator {
        private ATermAppl subj;
        private Node subjNode;
        private ATermAppl pred;
        private Node predNode;
        private Iterator<ATermAppl> predicates;
        private Iterator objects;
        private byte which;

        public ABoxPredObjIterator(Node subjNode, ATermAppl subj, byte which) {
            this.subjNode = subjNode;
            this.subj = subj;
            this.which = which;
            this.predicates = PelletInfGraph.this.kb.getProperties().iterator();
            this.findNextPredicate();
        }

        private void findNextPredicate() {
            while (this.predicates.hasNext()) {
                this.pred = this.predicates.next();
                this.objects = this.which == 2 ? PelletInfGraph.this.kb.getPropertyValues(this.pred, this.subj).iterator() : PelletInfGraph.this.kb.getIndividualsWithProperty(this.pred, this.subj).iterator();
                if (!this.objects.hasNext()) continue;
                this.predNode = (Node)PelletInfGraph.this.nodeMapper.map1(this.pred);
                return;
            }
            this.objects = NullIterator.instance;
        }

        public boolean hasNext() {
            if (this.objects.hasNext()) {
                return true;
            }
            this.findNextPredicate();
            return this.objects.hasNext();
        }

        public Object next() {
            this.ensureHasNext();
            Object obj = this.objects.next();
            Node objNode = (Node)PelletInfGraph.this.nodeMapper.map1(obj);
            Triple triple = this.which == 2 ? new Triple(this.subjNode, this.predNode, objNode) : new Triple(objNode, this.predNode, this.subjNode);
            return triple;
        }
    }

    private class ABoxSubjObjIterator
    extends NiceIterator {
        private ATermAppl pred;
        private Node predNode;
        private ATermAppl subj;
        private Node subjNode;
        private Iterator subjects;
        private Iterator objects;

        public ABoxSubjObjIterator(Node predNode, ATermAppl pred) {
            this.predNode = predNode;
            this.pred = pred;
            this.subjects = PelletInfGraph.this.kb.retrieveIndividualsWithProperty(pred).iterator();
            this.findNextSubject();
        }

        private void findNextSubject() {
            while (this.subjects.hasNext()) {
                this.subj = (ATermAppl)this.subjects.next();
                this.objects = PelletInfGraph.this.kb.getPropertyValues(this.pred, this.subj).iterator();
                if (!this.objects.hasNext()) continue;
                this.subjNode = (Node)PelletInfGraph.this.nodeMapper.map1(this.subj);
                return;
            }
            this.objects = NullIterator.instance;
        }

        public boolean hasNext() {
            if (this.objects.hasNext()) {
                return true;
            }
            this.findNextSubject();
            return this.objects.hasNext();
        }

        public Object next() {
            this.ensureHasNext();
            ATermAppl obj = (ATermAppl)this.objects.next();
            Node objNode = (Node)PelletInfGraph.this.nodeMapper.map1(obj);
            Triple triple = new Triple(this.subjNode, this.predNode, objNode);
            return triple;
        }
    }
}

