/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.output.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTreePrinter
extends TreeTaxonomyPrinter<ATermAppl>
implements TaxonomyPrinter<ATermAppl> {
    @Override
    protected void printNode(Set<ATermAppl> set) {
        super.printNode(set);
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this.taxonomy, set.iterator().next());
        if (instances.size() > 0) {
            this.out.print(" - (");
            boolean printed = false;
            int anonCount = 0;
            Iterator<ATermAppl> ins = instances.iterator();
            int k = 0;
            while (ins.hasNext()) {
                ATermAppl x = ins.next();
                if (x.getName().startsWith("bNode")) {
                    ++anonCount;
                } else {
                    if (printed) {
                        this.out.print(", ");
                    } else {
                        printed = true;
                    }
                    this.printURI(this.out, x);
                }
                ++k;
            }
            if (anonCount > 0) {
                if (printed) {
                    this.out.print(", ");
                }
                this.out.print(anonCount + " Anonymous Individual");
                if (anonCount > 1) {
                    this.out.print("s");
                }
            }
            this.out.print(")");
        }
    }

    @Override
    protected void printURI(OutputFormatter out, ATermAppl c) {
        String uri = null;
        uri = c.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (c.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : c.toString());
        out.printURI(uri);
    }
}

