/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLTaxonomyPrinter
implements TaxonomyPrinter<ATermAppl> {
    static final String OWL_EQUIVALENT_CLASS = "owl:equivalentClass";
    static final String RDFS_SUB_CLASS_OF = "rdfs:subClassOf";
    static final String RDF_TYPE = "rdf:type";
    private Taxonomy<ATermAppl> taxonomy;
    private OutputFormatter out;
    private Set<ATermAppl> visited;

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy) {
        this.print(taxonomy, new OutputFormatter());
    }

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy, OutputFormatter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println();
        out.println("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
        out.println("         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
        out.println("         xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> ");
        out.println();
        this.printTree();
        out.println();
        out.println("</rdf:RDF>");
        out.flush();
    }

    private void printTree() {
        this.visited = new HashSet<ATermAppl>();
        this.visited.add(ATermUtils.BOTTOM);
        this.printTree(ATermUtils.TOP);
        this.printTree(ATermUtils.BOTTOM);
        for (ATermAppl c : this.taxonomy.getClasses()) {
            this.printTree(c);
        }
    }

    private void printTree(ATermAppl c) {
        if (this.visited.contains(c)) {
            return;
        }
        Set<ATermAppl> eqClasses = ATermUtils.primitiveOrBottom(this.taxonomy.getEquivalents(c));
        this.visited.add(c);
        this.visited.addAll(eqClasses);
        this.printConceptDefinition(c, false);
        for (ATermAppl eq : eqClasses) {
            this.printTriple(OWL_EQUIVALENT_CLASS, eq);
        }
        if (!c.equals(ATermUtils.BOTTOM)) {
            Set<Set<ATermAppl>> supers = this.taxonomy.getSupers(c, true);
            for (Set<ATermAppl> equivalenceSet : supers) {
                ATermAppl subClass = ATermUtils.primitiveOrBottom(equivalenceSet).iterator().next();
                this.printTriple(RDFS_SUB_CLASS_OF, subClass);
            }
        }
        this.out.println("</owl:Class>");
        for (ATermAppl eqClass : eqClasses) {
            this.out.println();
            this.printConceptDefinition(eqClass, true);
        }
        this.out.println();
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this.taxonomy, c);
        for (ATermAppl instance : instances) {
            if (ATermUtils.isBnode(instance)) {
                return;
            }
            this.out.print("<rdf:Description rdf:about=\"");
            this.out.print(instance.getName());
            this.out.println("\">");
            this.printTriple(RDF_TYPE, c);
            this.out.println("</rdf:Description>");
        }
    }

    private void printTriple(String predicate, ATermAppl c2) {
        this.out.print("   <" + predicate);
        this.out.print(" rdf:resource=\"");
        this.printConcept(c2);
        this.out.println("\"/> ");
    }

    private void printConceptDefinition(ATermAppl c, boolean close) {
        this.out.print("<owl:Class rdf:about=\"");
        this.printConcept(c);
        if (close) {
            this.out.println("\"/> ");
        } else {
            this.out.println("\"> ");
        }
    }

    private void printConcept(ATermAppl c) {
        String uri = null;
        uri = c.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (c.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : c.getName());
        this.out.print(uri);
    }
}

