/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    static final String INDENT = "  ";
    protected Taxonomy<T> taxonomy;
    protected OutputFormatter out;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new OutputFormatter());
    }

    @Override
    public void print(Taxonomy<T> taxonomy, OutputFormatter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        out.println();
        this.printTree();
        out.println();
        out.flush();
    }

    protected void printTree() {
        LinkedHashSet<T> top = new LinkedHashSet<T>();
        top.add(this.taxonomy.getTop().getName());
        top.addAll(this.taxonomy.getTop().getEquivalents());
        this.out.printHTML("<ul>");
        this.printTree(top, " ");
        this.out.printHTML("</ul>");
        LinkedHashSet<T> bottom = new LinkedHashSet<T>();
        bottom.add(this.taxonomy.getBottom().getName());
        bottom.addAll(this.taxonomy.getBottom().getEquivalents());
        if (bottom.size() > 1) {
            this.out.printHTML("<ul>");
            this.printNode(bottom, " ");
            this.out.printHTML("</ul>");
        }
    }

    protected void printTree(Set<T> set, String indent) {
        if (set.contains(this.taxonomy.getBottom().getName())) {
            return;
        }
        this.printNode(set, indent);
        this.out.printHTML("<ul>");
        T c = set.iterator().next();
        Set<Set<T>> subs = this.taxonomy.getSubs(c, true);
        for (Set<T> eqs : subs) {
            if (eqs.contains(c)) continue;
            this.printTree(eqs, indent + "   ");
        }
        this.out.printHTML("</ul>");
    }

    protected void printNode(Set<T> set, String indent) {
        if (this.out.isFormatHTML()) {
            this.out.printHTML("<li>");
        } else {
            this.out.print(indent);
        }
        this.printNode(set);
        if (this.out.isFormatHTML()) {
            this.out.printHTML("</li>");
        } else {
            this.out.println();
        }
    }

    protected void printNode(Set<T> set) {
        Iterator<T> i = set.iterator();
        T c = i.next();
        this.printURI(this.out, c);
        while (i.hasNext()) {
            this.out.print(" = ");
            this.printURI(this.out, i.next());
        }
    }

    protected void printURI(OutputFormatter out, T e) {
        out.printURI(e.toString());
    }
}

